/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.screens;

import com.atlassian.jira.auditing.handlers.FieldScreenSchemeHandler;
import com.atlassian.jira.issue.fields.screen.FieldScreenFactory;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeManager;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.issue.operation.ScreenableIssueOperation;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.issuefields.screens.AbstractFieldScreenSchemeItemAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;

@WebSudoRequired
public class AddFieldScreenSchemeItem
extends AbstractFieldScreenSchemeItemAction {
    private final FieldScreenFactory fieldScreenFactory;
    private final FieldScreenSchemeHandler fieldScreenSchemeHandler;

    public AddFieldScreenSchemeItem(FieldScreenSchemeManager fieldScreenSchemeManager, FieldScreenManager fieldScreenManager, FieldScreenFactory fieldScreenFactory, FieldScreenSchemeHandler fieldScreenSchemeHandler) {
        super(fieldScreenSchemeManager, fieldScreenManager);
        this.fieldScreenFactory = fieldScreenFactory;
        this.fieldScreenSchemeHandler = fieldScreenSchemeHandler;
    }

    protected void doValidation() {
        this.validateIssueOperationId();
        this.validateFieldScreenId();
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doInput() {
        return "input";
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() {
        FieldScreenSchemeItem fieldScreenSchemeItem = this.fieldScreenFactory.createFieldScreenSchemeItem();
        if (this.getIssueOperationId() != null) {
            fieldScreenSchemeItem.setIssueOperation(IssueOperations.getIssueOperation((Long)this.getIssueOperationId()));
        } else {
            fieldScreenSchemeItem.setIssueOperation(null);
        }
        fieldScreenSchemeItem.setFieldScreen(this.getFieldScreenManager().getFieldScreen(this.getFieldScreenId()));
        FieldScreenScheme fieldScreenScheme = this.getFieldScreenScheme();
        fieldScreenScheme.addFieldScreenSchemeItem(fieldScreenSchemeItem);
        this.fieldScreenSchemeHandler.handleFieldScreenSchemeItemCreated(fieldScreenScheme, fieldScreenSchemeItem);
        return this.redirectToView();
    }

    public Long getIssueOperaionId(ScreenableIssueOperation issueOperation) {
        return issueOperation.getId();
    }
}

