/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuetypes.pro;

import com.atlassian.jira.bulkedit.operation.BulkMoveOperation;
import com.atlassian.jira.config.IssueTypeSchemeService;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.option.OptionSetManager;
import com.atlassian.jira.issue.fields.option.ProjectOption;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.issuetypes.AbstractManageIssueTypeOptionsAction;
import com.atlassian.jira.web.action.admin.issuetypes.IssueTypeManageableOption;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

@WebSudoRequired
public class AssociateIssueTypeSchemesWithDefault
extends AbstractManageIssueTypeOptionsAction {
    private Long[] projects;
    protected final ProjectManager projectManager;
    private Collection<ProjectOption> availableProjects;

    public AssociateIssueTypeSchemesWithDefault(FieldConfigSchemeManager configSchemeManager, IssueTypeSchemeManager issueTypeSchemeManager, FieldManager fieldManager, OptionSetManager optionSetManager, IssueTypeManageableOption manageableOptionType, BulkMoveOperation bulkMoveOperation, ProjectManager projectManager, IssueManager issueManager, IssueTypeSchemeService issueTypeSchemeService) {
        super(configSchemeManager, issueTypeSchemeManager, fieldManager, optionSetManager, manageableOptionType, bulkMoveOperation, issueManager, issueTypeSchemeService);
        this.projectManager = projectManager;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        List contexts = CustomFieldUtils.buildJiraIssueContexts((boolean)false, (Long[])this.getProjects(), (ProjectManager)this.projectManager);
        this.configSchemeManager.removeSchemeAssociation(contexts, this.getConfigurableField());
        this.fieldManager.refresh();
        return this.getRedirect(this.getConfigScheme());
    }

    public Collection<ProjectOption> getAllProjects() {
        if (this.availableProjects == null) {
            ArrayList projects = new ArrayList(this.projectManager.getProjectObjects());
            final FieldConfigScheme defaultIssueTypeScheme = this.issueTypeSchemeManager.getDefaultIssueTypeScheme();
            CollectionUtils.filter(projects, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    Project project = (Project)object;
                    FieldConfigScheme configScheme = AssociateIssueTypeSchemesWithDefault.this.issueTypeSchemeManager.getConfigScheme(project);
                    return !defaultIssueTypeScheme.equals(configScheme);
                }
            });
            this.availableProjects = ProjectOption.transform(projects);
        }
        return this.availableProjects;
    }

    public Collection getOptions(FieldConfigScheme configScheme) {
        if (configScheme != null) {
            FieldConfig config = configScheme.getOneAndOnlyConfig();
            return this.optionSetManager.getOptionsForConfig(config).getOptions();
        }
        return Collections.emptyList();
    }

    public Long[] getProjects() {
        return this.projects;
    }

    public void setProjects(Long[] projects) {
        this.projects = projects;
    }

    public boolean isDefault() {
        return true;
    }
}

