/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.priorities;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.PriorityManager;
import com.atlassian.jira.issue.fields.config.PrioritySchemeService;
import com.atlassian.jira.issue.fields.config.manager.PrioritySchemeManager;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.Colours;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.admin.constants.AbstractViewConstants;
import com.atlassian.jira.web.action.admin.priorities.AddOrEditPriorityAction;
import com.atlassian.jira.web.action.admin.translation.TranslationManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;

@WebSudoRequired
public class ViewPriorities
extends AbstractViewConstants<Priority>
implements AddOrEditPriorityAction {
    private boolean preview = false;
    private String statusColor;
    private final PriorityManager priorityManager;
    private final PageBuilderService pageBuilderService;
    private final FeatureManager featureManager;
    private final PrioritySchemeManager prioritySchemeManager;
    private final PrioritySchemeService prioritySchemeService;
    private final ProjectManager projectManager;

    public ViewPriorities(TranslationManager translationManager, PriorityManager priorityManager, PageBuilderService pageBuilderService, FeatureManager featureManager, PrioritySchemeManager prioritySchemeManager, PrioritySchemeService prioritySchemeService, ProjectManager projectManager) {
        super(translationManager);
        this.priorityManager = priorityManager;
        this.pageBuilderService = pageBuilderService;
        this.featureManager = featureManager;
        this.prioritySchemeManager = prioritySchemeManager;
        this.prioritySchemeService = prioritySchemeService;
        this.projectManager = projectManager;
    }

    private void requireResources() {
        this.pageBuilderService.assembler().resources().requireWebResource("jira.webresources:view-priorities");
    }

    @Override
    protected String getConstantEntityName() {
        return "Priority";
    }

    @Override
    protected String getNiceConstantName() {
        return this.getText("admin.issue.constant.priority.lowercase");
    }

    @Override
    protected String getIssueConstantField() {
        return "priority";
    }

    @Override
    protected Priority getConstant(String id) {
        return this.getConstantsManager().getPriorityObject(id);
    }

    @Override
    protected String getRedirectPage() {
        return "ViewPriorities.jspa";
    }

    @Override
    protected Collection<Priority> getConstants() {
        return this.getConstantsManager().getPriorities();
    }

    @Override
    protected void clearCaches() {
        this.getConstantsManager().refreshPriorities();
    }

    @ActionViewData
    public boolean isPrioritiesPerProjectEnabled() {
        return this.featureManager.isEnabled(JiraFeatureFlagRegistrar.PRIORITIES_PER_PROJECT);
    }

    @Override
    @ActionViewData
    public boolean isTranslatable() {
        return super.isTranslatable();
    }

    @ActionViewData
    public Collection<Priority> getPriorities() {
        return this.getConstantsManager().getPriorities();
    }

    @ActionViewData
    public String getDefaultPriorityId() {
        return this.getDefaultId();
    }

    @ActionViewData
    public boolean isAnySDProject() {
        if (!this.featureManager.isEnabled(JiraFeatureFlagRegistrar.PRIORITIES_PER_PROJECT)) {
            return false;
        }
        return this.prioritySchemeService.hasAnyNotPossibleToAssociateProject(this.projectManager.getProjects());
    }

    @ActionViewData
    public String getToken() {
        return this.getXsrfToken();
    }

    @ActionViewData
    public Map<String, Map<String, Long>> getPrioritySchemesCountForPriority() {
        if (!this.featureManager.isEnabled(JiraFeatureFlagRegistrar.PRIORITIES_PER_PROJECT)) {
            return ImmutableMap.of();
        }
        Map<String, Long> schemesCountPerPriorityId = this.prioritySchemeManager.getAllSchemes().stream().map(arg_0 -> ((PrioritySchemeManager)this.prioritySchemeManager).getFieldConfigForDefaultMapping(arg_0)).map(arg_0 -> ((PrioritySchemeManager)this.prioritySchemeManager).getOptions(arg_0)).flatMap(Collection::stream).collect(Collectors.groupingBy(priority -> priority, Collectors.counting()));
        return ImmutableMap.of((Object)"schemesCount", schemesCountPerPriorityId);
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        this.requireResources();
        return super.doExecute();
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doAddNewPriority() {
        this.setStatusColor("#ffffff");
        return "input";
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    public String doAddPriority() throws Exception {
        if (this.isPreview()) {
            return "input";
        }
        this.validateFields();
        this.addField("statusColor", this.getStatusColor());
        return this.doAddConstant();
    }

    private void validateFields() {
        if (StringUtils.isBlank((CharSequence)this.getIconurl())) {
            this.addError("iconurl", this.getText("admin.errors.must.specify.url.for.icon.of.priority"));
        }
        if (StringUtils.isBlank((CharSequence)this.getStatusColor())) {
            this.addError("statusColor", this.getText("admin.errors.must.specify.color"));
        } else if (!Colours.isHexColour(this.getStatusColor())) {
            this.addError("statusColor", this.getText("admin.errors.must.specify.priority.color.as.hex.value"));
        }
    }

    @Override
    protected String redirectToView() {
        return this.returnCompleteWithInlineRedirect("ViewPriorities.jspa");
    }

    @Override
    protected String getDefaultPropertyName() {
        return "jira.constant.default.priority";
    }

    public boolean isPreview() {
        return this.preview;
    }

    public void setPreview(boolean preview) {
        this.preview = preview;
    }

    public String getStatusColor() {
        return this.statusColor;
    }

    public void setStatusColor(String statusColor) {
        this.statusColor = statusColor;
    }

    @Override
    protected void addConstant() throws GenericEntityException {
        this.priorityManager.createPriority(this.name, this.description, this.iconurl, this.statusColor);
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    public String doMoveDown() {
        this.requireResources();
        this.priorityManager.movePriorityDown(this.down);
        return this.getResult();
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    public String doMoveUp() {
        this.requireResources();
        this.priorityManager.movePriorityUp(this.up);
        return this.getResult();
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    public String doMakeDefault() throws Exception {
        this.requireResources();
        this.priorityManager.setDefaultPriority(this.make);
        return "success";
    }

    @Override
    public String getPageTitle() {
        return this.getText("admin.issuesettings.priorities.add.new.priority");
    }

    @Override
    public String getTargetActionName() {
        return "AddPriority.jspa";
    }

    @Override
    public String getSubmitName() {
        return this.getText("common.forms.add");
    }

    @Override
    public String getTitle() {
        return this.getText("admin.issuesettings.priorities.add.new.priority");
    }

    @Override
    public boolean isAddIdField() {
        return false;
    }
}

