/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.priorities;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.fields.config.PrioritySchemeService;
import com.atlassian.jira.issue.fields.config.manager.PrioritySchemeManager;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.web.action.ActionViewDataMappings;
import com.atlassian.jira.web.action.admin.priorities.AbstractPrioritySchemesAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@WebSudoRequired
public class ViewPrioritySchemes
extends AbstractPrioritySchemesAction {
    private final FeatureManager featureManager;
    private final PageBuilderService pageBuilderService;
    private final PrioritySchemeService prioritySchemeService;
    private final ProjectManager projectManager;

    public ViewPrioritySchemes(FeatureManager featureManager, PageBuilderService pageBuilderService, PrioritySchemeManager prioritySchemeManager, PrioritySchemeService prioritySchemeService, ProjectManager projectManager) {
        super(prioritySchemeManager);
        this.featureManager = featureManager;
        this.pageBuilderService = pageBuilderService;
        this.prioritySchemeService = prioritySchemeService;
        this.projectManager = projectManager;
    }

    private void requireResources() {
        this.pageBuilderService.assembler().resources().requireWebResource("jira.webresources:administration-view-priority-schemes");
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        this.requireResources();
        if (!this.featureManager.isEnabled(JiraFeatureFlagRegistrar.PRIORITIES_PER_PROJECT)) {
            this.addErrorMessage(this.getText("admin.errors.priority.schemes.not.enabled"));
        }
        return this.getResult();
    }

    @ActionViewDataMappings(value={"success", "error"})
    public Map<String, Object> getSoyData() {
        Long actionedSchemeId;
        ImmutableMap.Builder data = new ImmutableMap.Builder().put((Object)"xsrfToken", (Object)StringUtils.defaultIfBlank((CharSequence)this.getXsrfToken(), (CharSequence)"")).put((Object)"globalErrors", (Object)this.getErrorMessages()).put((Object)"prioritySchemes", this.getPrioritySchemes()).put((Object)"priorities", this.getPriorities()).put((Object)"anySDProject", (Object)this.prioritySchemeService.hasAnyNotPossibleToAssociateProject(this.projectManager.getProjects())).put((Object)"defaultPrioritiesIds", this.getDefaultPrioritiesIds()).put((Object)"canEditDefaultScheme", (Object)this.featureManager.isEnabled(JiraFeatureFlagRegistrar.PRIORITIES_PER_PROJECT_EDIT_DEFAULT_SCHEME));
        Long defaultPrioritySchemeId = this.getDefaultPrioritySchemeId();
        if (defaultPrioritySchemeId != null) {
            data.put((Object)"defaultPrioritySchemeId", (Object)defaultPrioritySchemeId);
        }
        if ((actionedSchemeId = this.getActionedSchemeId()) != null) {
            data.put((Object)"actionedSchemeId", (Object)actionedSchemeId);
        }
        return data.build();
    }
}

