/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.priorities;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.PrioritySchemeManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import java.util.Collection;
import java.util.Optional;

@WebSudoRequired
public class ViewPrioritySchemesForPriority
extends JiraWebActionSupport {
    private String id;
    private Collection<FieldConfigScheme> schemes;
    private final PrioritySchemeManager prioritySchemeManager;
    private final PageBuilderService pageBuilderService;
    private final I18nHelper i18nHelper;
    private final FeatureManager featureManager;

    public ViewPrioritySchemesForPriority(PrioritySchemeManager prioritySchemeManager, PageBuilderService pageBuilderService, I18nHelper i18nHelper, FeatureManager featureManager) {
        this.prioritySchemeManager = prioritySchemeManager;
        this.pageBuilderService = pageBuilderService;
        this.i18nHelper = i18nHelper;
        this.featureManager = featureManager;
    }

    private void requireResources() {
        this.pageBuilderService.assembler().resources().requireWebResource("jira.webresources:view-priority-schemes-for-priority");
    }

    protected void doValidation() {
        if (!this.featureManager.isEnabled(JiraFeatureFlagRegistrar.PRIORITIES_PER_PROJECT)) {
            this.getErrorMessages().add(this.i18nHelper.getText("admin.issuesettings.priorities.view.priority.schemes.for.priority.not.enabled"));
            return;
        }
        if (this.id == null) {
            this.getErrorMessages().add(this.i18nHelper.getText("admin.issuesettings.priorities.view.priority.schemes.for.priority.no.id"));
            return;
        }
        if (this.getSchemes() == null || this.getSchemes().isEmpty()) {
            this.getErrorMessages().add(this.i18nHelper.getText("admin.issuesettings.priorities.view.priority.schemes.for.priority.no.schemes"));
        }
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        this.requireResources();
        return super.doExecute();
    }

    @ActionViewData
    public String getTitle() {
        return Optional.ofNullable(this.id).map(arg_0 -> ((PrioritySchemeManager)this.prioritySchemeManager).getPriority(arg_0)).map(IssueConstant::getName).map(name -> this.i18nHelper.getText("admin.issuesettings.priorities.view.priority.schemes.title", name)).orElse(this.i18nHelper.getText("admin.issuesettings.priorities.view.priority.schemes.title.without.name"));
    }

    @ActionViewData
    public Collection<String> getErrorMessages() {
        return super.getErrorMessages();
    }

    @ActionViewData
    public Collection<FieldConfigScheme> getSchemes() {
        if (this.schemes == null) {
            this.schemes = this.prioritySchemeManager.getAllRelatedSchemes(this.id);
        }
        return this.schemes;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

