/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.resolutions;

import com.atlassian.jira.config.ResolutionManager;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.constants.AbstractViewConstants;
import com.atlassian.jira.web.action.admin.translation.TranslationManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;
import org.ofbiz.core.entity.GenericEntityException;

@WebSudoRequired
public class ViewResolutions
extends AbstractViewConstants<Resolution> {
    private final ResolutionManager resolutionManager;

    public ViewResolutions(TranslationManager translationManager, ResolutionManager resolutionManager) {
        super(translationManager);
        this.resolutionManager = resolutionManager;
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        return super.doExecute();
    }

    @Override
    protected String getConstantEntityName() {
        return "Resolution";
    }

    @Override
    protected String getNiceConstantName() {
        return "resolution";
    }

    @Override
    protected String getIssueConstantField() {
        return this.getText("admin.issue.constant.resolution.lowercase");
    }

    @Override
    protected Resolution getConstant(String id) {
        return this.getConstantsManager().getResolution(id);
    }

    @Override
    protected String getRedirectPage() {
        return "ViewResolutions.jspa";
    }

    @Override
    protected Collection<Resolution> getConstants() {
        return this.getConstantsManager().getResolutions();
    }

    @Override
    protected void clearCaches() {
        this.getConstantsManager().refreshResolutions();
    }

    @Override
    protected String redirectToView() {
        return this.getRedirect("ViewResolutions.jspa");
    }

    @Override
    protected String getDefaultPropertyName() {
        return "jira.constant.default.resolution";
    }

    @Override
    @SupportedMethods(value={RequestMethod.POST})
    protected void addConstant() throws GenericEntityException {
        this.resolutionManager.createResolution(this.name, this.description);
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    public String doMakeDefault() throws Exception {
        this.resolutionManager.setDefaultResolution(this.make);
        return "success";
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    public String doMoveDown() {
        this.resolutionManager.moveResolutionDown(this.down);
        return this.getResult();
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    public String doMoveUp() {
        this.resolutionManager.moveResolutionUp(this.up);
        return this.getResult();
    }
}

