/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.systemfields;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.DefaultValueField;
import com.atlassian.jira.issue.fields.FieldId;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.util.BaseUrl;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.base.Suppliers;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@WebSudoRequired
public class ConfigureField
extends JiraWebActionSupport {
    private final BaseUrl baseUrl;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;
    private final FieldManager fieldManager;
    private final PageBuilderService pageBuilder;
    private final ScreenInfoConverter screenInfoConverter;
    private final FieldScreenManager fieldScreenManager;
    private FieldId fieldId;
    private ConfigurableField<?> field;
    private String selectedTab = "contexts";
    private final Supplier<Collection<ScreenInfo>> screens = Suppliers.memoize(this::loadScreens);

    public ConfigureField(BaseUrl baseUrl, FieldConfigSchemeManager fieldConfigSchemeManager, FieldManager fieldManager, PageBuilderService pageBuilder, FieldScreenManager fieldScreenManager) {
        this.baseUrl = baseUrl;
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
        this.fieldManager = fieldManager;
        this.pageBuilder = pageBuilder;
        this.fieldScreenManager = fieldScreenManager;
        this.screenInfoConverter = new ScreenInfoConverter();
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doExecute() throws Exception {
        this.pageBuilder.assembler().resources().requireContext("jira.webresources:configure-field").requireContext("jira.webresources:delete-field-config");
        this.pageBuilder.assembler().resources().requireContext("systemFieldsContextDialog");
        this.pageBuilder.assembler().resources().requireContext("systemFieldsIssuetypesProjectsDialog");
        this.pageBuilder.assembler().resources().requireContext("systemFieldsConfigureFieldPage");
        if (this.fieldId != null) {
            this.field = this.fieldManager.getConfigurableField(this.fieldId.toFullId());
            if (this.field != null) {
                return super.doExecute();
            }
        }
        return "error";
    }

    @ActionViewData
    public String getFieldId() {
        return this.fieldId.toFullId();
    }

    public void setFieldId(String id) {
        this.fieldId = FieldId.fromFullId(id);
    }

    @ActionViewData
    public String getFieldName() {
        return this.field.getName();
    }

    @ActionViewData
    public List<ConfigScheme> getConfigSchemes() {
        return this.fieldConfigSchemeManager.getConfigSchemesForField(this.field).stream().map(x$0 -> new ConfigScheme((FieldConfigScheme)x$0)).sorted(Comparator.comparing(ConfigScheme::getName)).collect(Collectors.toList());
    }

    @ActionViewData
    public Collection<ScreenInfo> getScreens() {
        return this.screens.get();
    }

    @ActionViewData
    public long getAssociatedScreensCount() {
        return this.screens.get().stream().filter(t -> ScreenTabInfo.isFieldOnTab(t)).count();
    }

    @ActionViewData
    public String getXsrfToken() {
        return super.getXsrfToken();
    }

    @ActionViewData
    public String getSelfUrl() {
        return this.baseUrl.resolveAddress("/secure/admin/ConfigureField.jspa?fieldId=" + this.fieldId.toFullId()).toString();
    }

    @ActionViewData
    public String getScreensUrl() {
        return this.getSelfUrl() + "&selectedTab=screens";
    }

    @ActionViewData
    public String getSelectedTab() {
        return this.selectedTab;
    }

    private Collection<ScreenInfo> loadScreens() {
        return this.fieldScreenManager.getFieldScreens().stream().map(fieldScreen -> this.screenInfoConverter.convert((FieldScreen)fieldScreen, this.getFieldId())).collect(Collectors.toList());
    }

    public void setSelectedTab(String selectedTab) {
        this.selectedTab = selectedTab;
    }

    @VisibleForTesting
    static class ScreenInfoConverter {
        ScreenInfoConverter() {
        }

        @VisibleForTesting
        ScreenInfo convert(FieldScreen fieldScreen, String fieldId) {
            return new ScreenInfo(fieldScreen.getId(), fieldScreen.getName(), fieldScreen.getTabs().stream().map(tab -> this.convert((FieldScreenTab)tab, fieldId)).collect(Collectors.toList()));
        }

        private ScreenTabInfo convert(FieldScreenTab tab, String fieldId) {
            return new ScreenTabInfo(tab.getId(), tab.getName(), tab.getPosition(), tab.isContainsField(fieldId));
        }
    }

    public static class ConfigScheme {
        private final FieldConfigScheme fieldConfigScheme;

        private ConfigScheme(FieldConfigScheme fieldConfigScheme) {
            this.fieldConfigScheme = fieldConfigScheme;
        }

        public long getId() {
            return this.fieldConfigScheme.getId();
        }

        public String getName() {
            return this.fieldConfigScheme.getName();
        }

        public String getDescription() {
            return this.fieldConfigScheme.getDescription();
        }

        public String getDefaultValue() {
            ConfigurableField field = this.fieldConfigScheme.getField();
            if (field instanceof DefaultValueField) {
                FieldConfig fieldConfig = this.getConfig();
                return ((DefaultValueField)field).getDefaultValueOperations().getViewHtml(fieldConfig, null);
            }
            return "";
        }

        public boolean isHasDefaultValue() {
            ConfigurableField field = this.fieldConfigScheme.getField();
            if (field instanceof DefaultValueField) {
                DefaultValueField defaultValueField = (DefaultValueField)field;
                return defaultValueField.getDefaultValueOperations().getDefaultValue(this.getConfig()) != null;
            }
            return false;
        }

        public FieldConfig getConfig() {
            return this.fieldConfigScheme.getOneAndOnlyConfig();
        }

        public long getIssueTypeCount() {
            return this.fieldConfigScheme.getAssociatedIssueTypeIds().stream().filter(Objects::nonNull).count();
        }

        public boolean isAllIssueTypes() {
            return this.fieldConfigScheme.isAllIssueTypes();
        }

        public long getProjectCount() {
            return this.fieldConfigScheme.getAssociatedProjectIds().stream().filter(Objects::nonNull).count();
        }

        public boolean isAllProjects() {
            return this.fieldConfigScheme.isAllProjects();
        }
    }

    public static class ScreenTabInfo {
        final Long id;
        final String name;
        final int position;
        final boolean fieldOnTab;

        public ScreenTabInfo(Long id, String name, int position, boolean fieldOnTab) {
            this.id = id;
            this.name = name;
            this.position = position;
            this.fieldOnTab = fieldOnTab;
        }

        public static boolean isFieldOnTab(ScreenInfo t) {
            return t.isFieldOnScreen();
        }

        public Long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public int getPosition() {
            return this.position;
        }

        public boolean isFieldOnTab() {
            return this.fieldOnTab;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ScreenTabInfo that = (ScreenTabInfo)o;
            return this.position == that.position && this.fieldOnTab == that.fieldOnTab && Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name, this.position, this.fieldOnTab);
        }

        public String toString() {
            return "ScreenTabInfo{id=" + this.id + ", name='" + this.name + '\'' + ", position=" + this.position + ", fieldOnTab=" + this.fieldOnTab + '}';
        }
    }

    public static class ScreenInfo {
        final Long id;
        final String name;
        final Collection<ScreenTabInfo> tabs;

        public ScreenInfo(Long id, String name, @Nonnull Collection<ScreenTabInfo> tabs) {
            this.id = id;
            this.name = name;
            this.tabs = tabs;
        }

        public Long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        @Nonnull
        public Collection<ScreenTabInfo> getTabs() {
            return this.tabs;
        }

        public boolean isFieldOnScreen() {
            return this.getTabs().stream().anyMatch(ScreenTabInfo::isFieldOnTab);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ScreenInfo that = (ScreenInfo)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.tabs, that.tabs);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name, this.tabs);
        }

        public String toString() {
            return "ScreenInfo{id=" + this.id + ", name='" + this.name + '\'' + ", tabs=" + this.tabs + '}';
        }
    }
}

