/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.impl.ImmutableGroup;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.embedded.InvalidGroupException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.group.GroupService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.util.GroupToPermissionSchemeMapper;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.GlobalPermissionGroupAssociationUtil;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.action.AbstractBrowser;
import com.atlassian.jira.web.bean.GroupBrowserFilter;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.jira.web.component.admin.group.GroupLabelView;
import com.atlassian.jira.web.component.admin.group.GroupLabelsService;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import webwork.action.ActionContext;
import webwork.util.BeanUtil;

@WebSudoRequired
public class GroupBrowser
extends AbstractBrowser {
    private List<Group> groups;
    private String addName;
    private GroupToPermissionSchemeMapper groupPermissionSchemeMapper;
    private final GlobalPermissionGroupAssociationUtil globalPermissionGroupAssociationUtil;
    private final CrowdService crowdService;
    private final GroupManager groupManager;
    private final UserManager userManager;
    private final CrowdDirectoryService crowdDirectoryService;
    private final GroupService groupService;
    private final GroupLabelsService groupLabels;
    private Boolean hasGroupWritableDirectory = null;

    public GroupBrowser(GroupToPermissionSchemeMapper groupToPermissionSchemeMapper, UserManager userManager, GlobalPermissionGroupAssociationUtil globalPermissionGroupAssociationUtil, CrowdService crowdService, CrowdDirectoryService crowdDirectoryService, GroupManager groupManager, GroupService groupService, GroupLabelsService groupLabels) {
        this.globalPermissionGroupAssociationUtil = globalPermissionGroupAssociationUtil;
        this.crowdService = crowdService;
        this.crowdDirectoryService = crowdDirectoryService;
        this.groupService = groupService;
        this.groupManager = groupManager;
        this.userManager = userManager;
        this.groupLabels = groupLabels;
        if (groupToPermissionSchemeMapper != null) {
            this.groupPermissionSchemeMapper = groupToPermissionSchemeMapper;
        } else {
            this.addErrorMessage(this.getText("groupbrowser.error.retrieve.group"));
        }
    }

    public GroupBrowser(GroupManager groupManager, UserManager userManager, CrowdService crowdService, CrowdDirectoryService crowdDirectoryService, GlobalPermissionGroupAssociationUtil globalPermissionGroupAssociationUtil, GroupService groupService, GroupLabelsService groupLabels) throws GenericEntityException {
        this(new GroupToPermissionSchemeMapper(ComponentAccessor.getPermissionSchemeManager(), ComponentAccessor.getPermissionManager()), userManager, globalPermissionGroupAssociationUtil, crowdService, crowdDirectoryService, groupManager, groupService, groupLabels);
    }

    @SupportedMethods(value={RequestMethod.GET, RequestMethod.POST})
    protected String doExecute() throws Exception {
        this.resetPager();
        BeanUtil.setProperties((Map)this.params, (Object)((Object)this.getFilter()));
        return "success";
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    public String doAdd() throws Exception {
        if (!this.addNewGroup()) {
            return "error";
        }
        return this.doExecute();
    }

    private boolean addNewGroup() {
        if (StringUtils.isEmpty((CharSequence)this.addName)) {
            this.addError("addName", this.getText("admin.errors.cannot.add.groups.invalid.group.name"));
            return false;
        }
        if (!this.userManager.hasGroupWritableDirectory()) {
            this.addErrorMessage(this.getText("admin.errors.cannot.add.groups.directories.read.only"));
            return false;
        }
        if (this.crowdService.getGroup(this.addName) == null) {
            try {
                this.crowdService.addGroup((Group)new ImmutableGroup(this.addName));
            }
            catch (OperationNotPermittedException | InvalidGroupException | OperationFailedException e) {
                this.addError("addName", this.getText("groupbrowser.error.add", this.addName));
                this.log.error((Object)("Error occurred adding group : " + this.addName), e);
            }
            this.addName = null;
        } else {
            this.addError("addName", this.getText("groupbrowser.error.group.exists"));
        }
        return true;
    }

    @Override
    public PagerFilter getPager() {
        return this.getFilter();
    }

    @Override
    public void resetPager() {
        ActionContext.getSession().put("jira.group.filter", null);
    }

    public GroupBrowserFilter getFilter() {
        GroupBrowserFilter filter = (GroupBrowserFilter)((Object)ActionContext.getSession().get("jira.group.filter"));
        if (filter == null) {
            filter = new GroupBrowserFilter();
            ActionContext.getSession().put("jira.group.filter", filter);
        }
        return filter;
    }

    @Override
    public List getCurrentPage() {
        return this.getFilter().getCurrentPage(this.getBrowsableItems());
    }

    @Override
    public List getBrowsableItems() {
        if (this.groups == null) {
            try {
                this.groups = this.getFilter().getFilteredGroups();
            }
            catch (Exception e) {
                this.log.error((Object)("Exception getting groups: " + e), (Throwable)e);
                return Collections.emptyList();
            }
        }
        return this.groups;
    }

    public String getAddName() {
        return this.addName;
    }

    public void setAddName(String addName) {
        this.addName = addName.trim();
    }

    public String escapeAmpersand(String str) {
        return StringUtils.replaceAll((String)str, (String)"&", (String)"%26");
    }

    public int getUsersInGroupCount(Group group) {
        return this.groupManager.getUsersInGroupCount(group);
    }

    public Collection<Scheme> getPermissionSchemes(String groupName) {
        if (this.groupPermissionSchemeMapper != null) {
            return this.groupPermissionSchemeMapper.getMappedValues(groupName);
        }
        return Collections.emptyList();
    }

    public boolean hasGroupWritableDirectory() {
        if (this.hasGroupWritableDirectory == null) {
            this.hasGroupWritableDirectory = new Boolean(this.userManager.hasGroupWritableDirectory());
        }
        return this.hasGroupWritableDirectory;
    }

    public boolean isUserAbleToDeleteGroup(String groupName) {
        return this.globalPermissionGroupAssociationUtil.isUserAbleToDeleteGroup(this.getLoggedInUser(), groupName);
    }

    @Nonnull
    public String isGroupDeletable(@Nonnull String groupName) {
        JiraServiceContext currentRequest = this.getJiraServiceContext();
        SimpleErrorCollection potentialDeleteErrors = new SimpleErrorCollection();
        JiraServiceContextImpl potentialDelete = new JiraServiceContextImpl(currentRequest.getLoggedInApplicationUser(), (ErrorCollection)potentialDeleteErrors, currentRequest.getI18nBean());
        this.groupService.validateDelete((JiraServiceContext)potentialDelete, groupName, null);
        if (potentialDeleteErrors.hasAnyErrors()) {
            if (this.groupService.getCommentsAndWorklogsGuardedByGroupCount(groupName) > 0L) {
                return "";
            }
            return (String)potentialDeleteErrors.getErrorMessages().iterator().next();
        }
        return "";
    }

    public boolean isNestedGroupsEnabledForAnyDirectory() {
        for (Directory directory : this.crowdDirectoryService.findAllDirectories()) {
            if (!this.crowdDirectoryService.supportsNestedGroups(directory.getId().longValue())) continue;
            return true;
        }
        return false;
    }

    public List<GroupLabelView> getGroupLabels(Group group) {
        return this.groupLabels.getGroupLabels(group, Optional.empty());
    }
}

