/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow;

import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ComponentFactory;
import com.atlassian.jira.web.action.admin.workflow.AbstractWorkflowStep;
import com.atlassian.jira.web.action.admin.workflow.WorkflowViewMode;
import com.atlassian.jira.web.component.WorkflowHeaderWebComponent;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@WebSudoRequired
public class ViewWorkflowSteps
extends AbstractWorkflowStep {
    private WorkflowHeaderWebComponent workflowHeaderWebComponent;
    private WorkflowViewMode viewMode;

    public ViewWorkflowSteps(JiraWorkflow workflow, ConstantsManager constantsManager, WorkflowService workflowService, ComponentFactory factory) {
        super(workflow, constantsManager, workflowService);
        this.workflowHeaderWebComponent = factory.createObject(WorkflowHeaderWebComponent.class, new Object[0]);
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        return super.doExecute();
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    public String doAddStep() {
        if (StringUtils.isNotBlank((CharSequence)this.getStepName())) {
            List existingSteps = this.getWorkflow().getDescriptor().getSteps();
            for (StepDescriptor existingStep : existingSteps) {
                if (this.getStepName().equalsIgnoreCase(existingStep.getName())) {
                    this.addError("stepName", this.getText("admin.errors.step.with.name.already.exists"));
                }
                if (!this.getStepStatus().equalsIgnoreCase((String)existingStep.getMetaAttributes().get("jira.status.id"))) continue;
                this.addError("stepStatus", this.getText("admin.errors.existing.step.already.linked"));
            }
        } else {
            this.addError("stepName", this.getText("admin.errors.step.name.must.be.specified"));
        }
        if (!this.invalidInput()) {
            StepDescriptor newStep = DescriptorFactory.getFactory().createStepDescriptor();
            newStep.setName(this.getStepName());
            newStep.setId(WorkflowUtil.getNextId((List)this.getWorkflow().getDescriptor().getSteps()));
            newStep.getMetaAttributes().put("jira.status.id", this.getStepStatus());
            newStep.setParent((AbstractDescriptor)this.getWorkflow().getDescriptor());
            this.getWorkflow().getDescriptor().addStep(newStep);
            this.workflowService.updateWorkflow(this.getJiraServiceContext(), this.getWorkflow());
        }
        return "success";
    }

    public boolean isTransitionWithoutStepChange(ActionDescriptor transition) {
        return transition.getUnconditionalResult().getStep() == -1;
    }

    public Status getStatus(String id) {
        return this.getConstantsManager().getStatusObject(id);
    }

    public String getHeaderHtml() {
        return this.workflowHeaderWebComponent.getHtml(this.getWorkflow(), "workflow", this.getProject());
    }

    public String getLinksHtml() {
        String viewMode = this.workflow.isEditable() || !this.isDiagramMode() ? "text" : "diagram";
        return this.workflowHeaderWebComponent.getLinksHtml(this.getWorkflow(), this.getProject(), viewMode, this.getWorkflow().isEditable());
    }

    public boolean isDiagramMode() {
        if (this.viewMode == null) {
            this.viewMode = WorkflowViewMode.parseFromAction(this);
        }
        return this.viewMode == WorkflowViewMode.DIAGRAM;
    }
}

