/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow.scheme;

import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.task.TaskContext;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.action.admin.workflow.WorkflowMigrationResult;
import com.atlassian.jira.web.action.admin.workflow.scheme.SelectProjectWorkflowScheme;
import com.atlassian.jira.web.bean.TaskDescriptorBean;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.jira.workflow.migration.EnterpriseWorkflowTaskContext;
import com.atlassian.jira.workflow.migration.WorkflowSchemeMigrationTaskAccessor;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.HashMap;
import java.util.Map;

@WebSudoRequired
public class SelectProjectWorkflowSchemeStep3
extends SelectProjectWorkflowScheme {
    private static final String ABORTED_MIGRATION_MESSAGE_KEY = "admin.workflowmigration.aborted.defaultworkflow";
    private static final String FAILURE_MIGRATION_MESSAGE_KEY = "admin.workflowmigration.withfailure.defaultworkflow";
    private final Map<Long, String> failedIssueIds = new HashMap<Long, String>();
    private Long taskId;

    public Long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public SelectProjectWorkflowSchemeStep3(WorkflowSchemeMigrationTaskAccessor taskAccessor, TaskManager taskManager, WorkflowSchemeManager workflowSchemeManager, TaskDescriptorBean.Factory taskDescriptorFactory) {
        super(taskAccessor, taskManager, workflowSchemeManager, taskDescriptorFactory);
    }

    @Override
    protected void doValidation() {
        super.doValidation();
        Long taskId = this.getTaskId();
        TaskDescriptor<WorkflowMigrationResult> taskDescriptor = null;
        if (taskId != null) {
            taskDescriptor = this.getTaskManager().getTask(taskId);
        }
        if (taskDescriptor == null) {
            this.addErrorMessage(this.getText("common.tasks.task.not.found"));
        } else {
            TaskContext context = taskDescriptor.getTaskContext();
            if (!(context instanceof EnterpriseWorkflowTaskContext)) {
                this.addErrorMessage(this.getText("common.tasks.wrong.task.context", EnterpriseWorkflowTaskContext.class.getName(), context.getClass().getName()));
            } else {
                this.initTaskDescriptorBean(taskDescriptor);
            }
        }
    }

    @Override
    @SupportedMethods(value={RequestMethod.GET, RequestMethod.POST})
    protected String doExecute() throws Exception {
        if (!this.hasPermission()) {
            return "securitybreach";
        }
        if (!this.isDone()) {
            return "success";
        }
        WorkflowMigrationResult migrationResult = null;
        migrationResult = (WorkflowMigrationResult)this.getCurrentTask().getResult();
        if (migrationResult == null) {
            return "error";
        }
        ErrorCollection errorCollection = migrationResult.getErrorCollection();
        if (errorCollection != null && errorCollection.hasAnyErrors()) {
            this.addErrorCollection(errorCollection);
            return "workflowmigrationerror";
        }
        if (0 == migrationResult.getResult()) {
            if (migrationResult.getNumberOfFailedIssues() > 0) {
                this.failedIssueIds.putAll(migrationResult.getFailedIssues());
                return "workflowmigrationwithfailure";
            }
            return "success";
        }
        this.failedIssueIds.putAll(migrationResult.getFailedIssues());
        return "workflowmigrationaborted";
    }

    @Override
    public TaskDescriptorBean getCurrentTask() {
        return super.getCurrentTask(false);
    }

    public String getDestinationURL() {
        return this.getRedirectURL();
    }

    public boolean isDone() {
        TaskDescriptorBean currentTask = this.getCurrentTask();
        return currentTask != null && currentTask.isFinished();
    }

    public Map<Long, String> getFailedIssueIds() {
        return this.failedIssueIds;
    }

    public static String getAbortedMigrationMessageKey() {
        return ABORTED_MIGRATION_MESSAGE_KEY;
    }

    public static String getFailureMigrationMessageKey() {
        return FAILURE_MIGRATION_MESSAGE_KEY;
    }
}

