/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.filter;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.filter.FilterSubscriptionService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.issue.subscription.FilterSubscription;
import com.atlassian.jira.issue.subscription.SubscriptionManager;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.web.action.filter.AbstractFilterAction;
import com.atlassian.jira.web.action.filter.FilterOperationsAction;
import com.atlassian.jira.web.bean.FilterUtils;
import com.atlassian.jira.web.component.cron.CronEditorBean;
import com.atlassian.jira.web.component.cron.CronEditorWebComponent;
import com.atlassian.jira.web.component.cron.generator.CronExpressionGenerator;
import com.atlassian.jira.web.component.cron.parser.CronExpressionParser;
import com.opensymphony.util.TextUtils;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import webwork.action.ActionContext;

public class EditSubscription
extends AbstractFilterAction
implements FilterOperationsAction {
    private Long subId = null;
    private String groupName;
    private Boolean emailOnEmpty = Boolean.FALSE;
    private Date lastRun;
    private Date nextRun;
    private CronEditorBean cronEditorBean;
    private final FilterSubscriptionService filterSubscriptionService;
    private final SubscriptionManager subscriptionManager;
    private final FeatureManager featureManager;
    private final GlobalPermissionManager globalPermissionManager;
    private final UserManager userManager;

    public EditSubscription(IssueSearcherManager issueSearcherManager, FilterSubscriptionService filterSubscriptionService, SearchService searchService, SubscriptionManager subscriptionManager, FeatureManager featureManager, GlobalPermissionManager globalPermissionManager, UserManager userManager) {
        super(issueSearcherManager, searchService);
        this.filterSubscriptionService = filterSubscriptionService;
        this.subscriptionManager = subscriptionManager;
        this.featureManager = featureManager;
        this.globalPermissionManager = globalPermissionManager;
        this.userManager = userManager;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        if (this.subId == null && this.getFilterId() == null) {
            this.addErrorMessage(this.getText("filtersubscription.please.select.a.subscription.or.filter"));
            return "error";
        }
        if (this.subId != null) {
            FilterSubscription subscription = this.getSubscription(this.subId, this.getLoggedInUser());
            if (subscription == null) {
                return "permissionviolation";
            }
            this.groupName = subscription.getGroupName();
            this.emailOnEmpty = subscription.isEmailOnEmpty();
            this.lastRun = subscription.getLastRunTime();
            String cronExpression = this.subscriptionManager.getCronExpressionForSubscription(subscription);
            CronExpressionParser cronExpresionParser = new CronExpressionParser(cronExpression);
            this.cronEditorBean = cronExpresionParser.getCronEditorBean();
            this.nextRun = null;
        }
        if (this.getFilterId() != null && this.getFilter() == null) {
            return "error";
        }
        return super.doDefault();
    }

    @Nullable
    private FilterSubscription getSubscription(@Nonnull Long subscriptionId, @Nullable ApplicationUser loggedInUser) throws GenericEntityException {
        if (this.featureManager.isEnabled(JiraFeatureFlagRegistrar.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS) && this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, loggedInUser)) {
            return this.subscriptionManager.getFilterSubscription(subscriptionId);
        }
        return this.subscriptionManager.getFilterSubscription(loggedInUser, subscriptionId);
    }

    public void doValidation() {
        this.cronEditorBean = new CronEditorBean("filter.subscription.prefix", ActionContext.getParameters());
        CronEditorWebComponent component = new CronEditorWebComponent();
        this.addErrorCollection(component.validateInput(this.cronEditorBean, "cron.editor.name"));
        if (!StringUtils.isEmpty((CharSequence)this.getGroupName()) && !this.getGroups().contains(this.getGroupName())) {
            this.addError("groupName", this.getI18nHelper().getText("filtersubscription.incorrect.group"));
        }
        if (!StringUtils.isEmpty((CharSequence)this.getGroupName()) && !this.hasGroupPermission()) {
            this.addErrorMessage(this.getI18nHelper().getText("filtersubscription.permission.error"));
        }
        if (!this.hasAnyErrors()) {
            JiraServiceContext serviceContext = this.getJiraServiceContext();
            String cronString = component.getCronExpressionFromInput(this.cronEditorBean);
            this.filterSubscriptionService.validateCronExpression(serviceContext, cronString);
        }
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET, RequestMethod.POST})
    protected String doExecute() throws Exception {
        String cronExpression = new CronExpressionGenerator().getCronExpressionFromInput(this.cronEditorBean);
        if (this.subId != null) {
            FilterSubscription subscription = this.getSubscription(this.subId, this.getLoggedInUser());
            if (subscription == null) {
                return "permissionviolation";
            }
            ApplicationUser owner = this.userManager.getUserByKeyEvenWhenUnknown(subscription.getUserKey());
            this.filterSubscriptionService.updateSubscription(this.getJiraServiceContext(), owner, this.subId, this.getGroupName(), cronExpression, this.emailOnEmpty.booleanValue());
        } else {
            if (this.getFilter() == null) {
                return "securitybreach";
            }
            this.filterSubscriptionService.storeSubscription(this.getJiraServiceContext(), this.getFilterId(), this.getGroupName(), cronExpression, this.getEmailOnEmpty().booleanValue());
        }
        if (this.isInlineDialogMode()) {
            return this.returnComplete(this.getReturnUrl());
        }
        return this.getReturnUrl() == null ? this.getRedirect("ViewSubscriptions.jspa?filterId=" + this.getFilterId()) : this.getRedirect(this.getReturnUrl());
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    public String doDelete() throws Exception {
        FilterSubscription subscription = this.getSubscription(this.subId, this.getLoggedInUser());
        if (subscription == null) {
            this.addErrorMessage(this.getText("subscriptions.error.delete.subscriptiondoesnotexist"));
            return "error";
        }
        this.subscriptionManager.deleteSubscription(this.subId);
        return this.getRedirect("ViewSubscriptions.jspa?filterId=" + this.getFilterId());
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    public String doRunNow() throws Exception {
        FilterSubscription subscription = this.getSubscription(this.subId, this.getLoggedInUser());
        if (subscription == null) {
            this.addErrorMessage(this.getText("subscriptions.error.runnow.subscriptiondoesnotexist"));
            return "error";
        }
        this.subscriptionManager.runSubscription(this.subId);
        return this.getRedirect("ViewSubscriptions.jspa?filterId=" + this.getFilterId());
    }

    public boolean hasGroupPermission() {
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.MANAGE_GROUP_FILTER_SUBSCRIPTIONS, this.getLoggedInUser());
    }

    public String getSubmitName() {
        if (this.subId == null) {
            return this.getText("filtersubscription.subscribe");
        }
        return this.getText("common.forms.update");
    }

    public String getCancelStr() {
        if (this.getReturnUrl() != null) {
            return this.getReturnUrl();
        }
        if (this.subId == null) {
            return "ManageFilters.jspa";
        }
        return "ViewSubscriptions.jspa?filterId=" + this.getFilterId();
    }

    public String getSubId() {
        if (this.subId == null) {
            return null;
        }
        return this.subId.toString();
    }

    public void setSubId(String subId) {
        if (TextUtils.stringSet((String)subId)) {
            this.subId = new Long(subId);
        }
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public Boolean getEmailOnEmpty() {
        return this.emailOnEmpty;
    }

    public void setEmailOnEmpty(Boolean emailOnEmpty) {
        this.emailOnEmpty = emailOnEmpty;
    }

    public String getLastRun() {
        if (this.lastRun == null) {
            return null;
        }
        return String.valueOf(this.lastRun.getTime());
    }

    public void setLastRun(String lastRun) {
        if (TextUtils.stringSet((String)lastRun)) {
            this.lastRun = new Timestamp(Long.parseLong(lastRun));
        }
    }

    public String getNextRun() {
        if (this.nextRun == null) {
            return null;
        }
        return String.valueOf(this.nextRun.getTime());
    }

    public void setNextRun(String nextRun) {
        if (TextUtils.stringSet((String)nextRun)) {
            this.nextRun = new Timestamp(Long.parseLong(nextRun));
        }
    }

    public String getLastRunStr() {
        return this.formatDate(this.lastRun);
    }

    public String getNextRunStr() {
        return this.formatDate(this.nextRun);
    }

    private String formatDate(Date date) {
        if (date == null) {
            return null;
        }
        return ((DateTimeFormatterFactory)ComponentAccessor.getComponent(DateTimeFormatterFactory.class)).formatter().withLocale(this.getLocale()).withStyle(DateTimeStyle.COMPLETE).format(date);
    }

    public Collection getGroups() {
        return FilterUtils.getGroups(this.getLoggedInUser());
    }

    public CronEditorBean getCronEditorBean() {
        if (this.cronEditorBean == null) {
            this.cronEditorBean = new CronExpressionParser().getCronEditorBean();
        }
        return this.cronEditorBean;
    }

    public String getHelpLink() {
        return "issue_filters_subscribing";
    }
}

