/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue.bulkedit;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bulkedit.BulkOperationManager;
import com.atlassian.jira.bulkedit.operation.ProgressAwareBulkOperation;
import com.atlassian.jira.event.operation.SpanningOperation;
import com.atlassian.jira.event.operation.SpanningOperationType;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.issue.bulkedit.AbstractBulkOperationDetailsAction;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.web.bean.BulkEditBeanSessionHelper;

public class BulkDelete
extends AbstractBulkOperationDetailsAction {
    private final ProgressAwareBulkOperation bulkDeleteOperation;
    private final PermissionManager permissionManager;

    public BulkDelete(SearchService searchService, BulkOperationManager bulkOperationManager, PermissionManager permissionManager, BulkEditBeanSessionHelper bulkEditBeanSessionHelper, TaskManager taskManager, I18nHelper i18nHelper) {
        super(searchService, bulkEditBeanSessionHelper, taskManager, i18nHelper);
        this.permissionManager = permissionManager;
        this.bulkDeleteOperation = bulkOperationManager.getProgressAwareOperation("bulk.delete.operation.name");
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        return super.doExecute();
    }

    public boolean isHasAvailableActions() throws Exception {
        return this.getBulkDeleteOperation().canPerform(this.getBulkEditBean(), this.getLoggedInUser());
    }

    public String getOperationDetailsActionName() {
        return this.getBulkDeleteOperation().getOperationName() + "Details.jspa";
    }

    public void doPerformValidation() {
        try {
            if (!this.permissionManager.hasPermission(33, this.getLoggedInUser())) {
                this.addErrorMessage(this.getText("bulk.change.no.permission", String.valueOf(this.getBulkEditBean().getSelectedIssues().size())));
            }
            if (!this.getBulkDeleteOperation().canPerform(this.getBulkEditBean(), this.getLoggedInUser())) {
                this.addErrorMessage(this.getText("bulk.delete.cannotperform.error", String.valueOf(this.getBulkEditBean().getSelectedIssues().size())));
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error occured while testing operation.", (Throwable)e);
            this.addErrorMessage(this.getText("bulk.canperform.error"));
        }
    }

    @Override
    @SupportedMethods(value={RequestMethod.GET})
    public String doDetails() throws Exception {
        if (this.getBulkEditBean() == null) {
            return this.redirectToStart();
        }
        if (this.isCanDisableMailNotifications() && this.getBulkEditBean().isHasMailServer()) {
            BulkEditBean bulkEditBean = this.getBulkEditBean();
            bulkEditBean.clearAvailablePreviousSteps();
            bulkEditBean.addAvailablePreviousStep(1);
            bulkEditBean.addAvailablePreviousStep(2);
            if (this.isCanDisableMailNotifications()) {
                bulkEditBean.setSendBulkNotification(false);
            } else {
                bulkEditBean.setSendBulkNotification(true);
            }
            bulkEditBean.setCurrentStep(3);
            return "input";
        }
        return this.getRedirect("BulkDeleteDetailsValidation.jspa");
    }

    @Override
    @SupportedMethods(value={RequestMethod.GET, RequestMethod.POST})
    public String doDetailsValidation() throws Exception {
        if (this.getBulkEditBean() == null) {
            return this.redirectToStart();
        }
        BulkEditBean bulkEditBean = this.getBulkEditBean();
        bulkEditBean.clearAvailablePreviousSteps();
        bulkEditBean.addAvailablePreviousStep(1);
        bulkEditBean.addAvailablePreviousStep(2);
        bulkEditBean.addAvailablePreviousStep(3);
        bulkEditBean.setCurrentStep(4);
        return "input";
    }

    @Override
    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    public String doPerform() throws Exception {
        if (this.getBulkEditBean() == null) {
            return this.redirectToStart();
        }
        this.doPerformValidation();
        if (this.invalidInput()) {
            return "error";
        }
        String taskName = this.getText("bulk.operation.progress.taskname.delete", this.getRootBulkEditBean().getSelectedIssuesIncludingSubTasks().size());
        return this.submitBulkOperationTask(this.getBulkEditBean(), this.getBulkDeleteOperation(), taskName, SpanningOperation.builder().type(SpanningOperationType.BULK_DELETE).generatedId().build());
    }

    public ProgressAwareBulkOperation getBulkDeleteOperation() {
        return this.bulkDeleteOperation;
    }
}

