/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.LazyLoadingApplicationUser;
import com.atlassian.jira.user.UserFilter;
import com.atlassian.jira.user.UserFilterManager;
import com.atlassian.jira.web.bean.FilterUtils;
import com.atlassian.jira.web.bean.PagerFilter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserPickerFilter
extends PagerFilter {
    private static final Logger log = LoggerFactory.getLogger(UserPickerFilter.class);
    static final String USER_SEARCH_RESULTS_LIMIT = "jira.user.search.maxresults.limit";
    private static final int MEMBERSHIP_CRITERIA_THRESHOLD = 1000;
    private UserFilter filter;
    private String nameFilter;
    private String emailFilter;
    private String group;
    private final FieldConfigManager fieldConfigManager;
    private final JiraServiceContext jiraServiceContext;
    private final PermissionManager permissionManager;
    private final UserFilterManager userFilterManager;
    private final UserSearchService userSearchService;
    private final ApplicationProperties applicationProperties;
    private String element;
    private Long fieldConfigId;
    private Collection<Long> projectIds;

    public UserPickerFilter(FieldConfigManager fieldConfigManager, JiraServiceContext jiraServiceContext, PermissionManager permissionManager, UserFilterManager userFilterManager, UserSearchService userSearchService, ApplicationProperties applicationProperties) {
        this.fieldConfigManager = fieldConfigManager;
        this.jiraServiceContext = jiraServiceContext;
        this.permissionManager = permissionManager;
        this.userFilterManager = userFilterManager;
        this.userSearchService = userSearchService;
        this.applicationProperties = applicationProperties;
    }

    public String getNameFilter() {
        return this.nameFilter;
    }

    public void setNameFilter(String nameFilter) {
        this.nameFilter = FilterUtils.verifyString(nameFilter);
    }

    public String getEmailFilter() {
        return this.emailFilter;
    }

    public void setEmailFilter(String emailFilter) {
        this.emailFilter = FilterUtils.verifyString(emailFilter);
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = FilterUtils.verifyString(group);
    }

    public String getElement() {
        return this.element;
    }

    public void setElement(String element) {
        this.element = element;
    }

    public Long getFieldConfigId() {
        return this.fieldConfigId;
    }

    public void setFieldConfigId(Long fieldConfigId) {
        this.fieldConfigId = fieldConfigId;
    }

    public Collection<Long> getProjectIds() {
        return this.projectIds;
    }

    public void setProjectId(String[] projectIds) {
        this.projectIds = Sets.newHashSetWithExpectedSize((int)projectIds.length);
        for (String projectIdStr : projectIds) {
            long projectId = NumberUtils.toLong((String)projectIdStr, (long)-1L);
            if (projectId == -1L) continue;
            this.projectIds.add(projectId);
        }
    }

    public List<ApplicationUser> getFilteredUsers() throws Exception {
        UserFilter filter = this.getFilter();
        Collection projectIdSet = CustomFieldUtils.getProjectIdsForUser((ApplicationUser)this.jiraServiceContext.getLoggedInApplicationUser(), this.projectIds, (PermissionManager)this.permissionManager, (UserFilter)filter);
        UserNameStringComparator userNameStringComparator = new UserNameStringComparator(this.jiraServiceContext.getI18nBean().getLocale());
        int maxResults = Integer.parseInt(this.applicationProperties.getDefaultBackedString(USER_SEARCH_RESULTS_LIMIT));
        UserSearchParams userSearchParams = UserSearchParams.builder().maxResults(Integer.valueOf(maxResults)).allowEmptyQuery(true).canMatchEmail(true).filter(filter).filterByProjectIds(projectIdSet).sorted(false).build();
        CrowdService crowdService = (CrowdService)ComponentAccessor.getComponentOfType(CrowdService.class);
        ArrayList<String> userNamesByFilter = this.userSearchService.findUserNames(this.nameFilter, this.emailFilter, userSearchParams);
        this.checkQueryPrecision((List<String>)userNamesByFilter, maxResults);
        if (this.group == null) {
            userNamesByFilter = new ArrayList<String>(userNamesByFilter);
            userNamesByFilter.sort(userNameStringComparator);
            return this.makeLazyApplicationUsersFromNames(userNamesByFilter, crowdService);
        }
        if (userNamesByFilter.size() > 1000) {
            UserFilter filterByGroup = new UserFilter(true, null, (Collection)ImmutableSet.of((Object)this.group));
            UserSearchParams userSearchParamsWithGroup = UserSearchParams.builder().maxResults(Integer.valueOf(maxResults)).allowEmptyQuery(true).canMatchEmail(true).filter(filterByGroup).build();
            List usersByGroup = this.userSearchService.findUserNames(this.nameFilter, this.emailFilter, userSearchParamsWithGroup);
            this.checkQueryPrecision(usersByGroup, maxResults);
            List<String> intersection = this.intersectLists(userNameStringComparator, userNamesByFilter, usersByGroup);
            return this.makeLazyApplicationUsersFromNames(intersection, crowdService);
        }
        ArrayList<String> fullMatches = new ArrayList<String>();
        for (String criteriaMatchingUser : userNamesByFilter) {
            if (!crowdService.isUserMemberOfGroup(criteriaMatchingUser, this.group)) continue;
            fullMatches.add(criteriaMatchingUser);
        }
        fullMatches.sort(userNameStringComparator);
        return this.makeLazyApplicationUsersFromNames(fullMatches, crowdService);
    }

    private void checkQueryPrecision(@Nonnull List<String> fetchedUsernames, int maxResults) {
        if (fetchedUsernames.size() == maxResults) {
            log.info("The number of fetched users was equal to the configured maximum ({}), meaning user picker results are not precise. Consider increasing the 'jira.user.search.maxresults.limit' property value to fix this.", (Object)maxResults);
        }
    }

    @VisibleForTesting
    <T> List<T> intersectLists(Comparator<? super T> userNameComparator, List<T> list1, List<T> list2) {
        if (list1 == null || list2 == null) {
            return ImmutableList.of();
        }
        TreeSet<T> intersection = new TreeSet<T>(userNameComparator);
        intersection.addAll(list1);
        intersection.retainAll(new HashSet<T>(list2));
        return ImmutableList.copyOf(intersection);
    }

    private UserFilter getFilter() {
        if (this.filter == null) {
            FieldConfig fieldConfig;
            this.filter = this.fieldConfigId == null ? UserFilter.DISABLED : ((fieldConfig = this.fieldConfigManager.getFieldConfig(this.fieldConfigId)) == null ? UserFilter.DISABLED : this.userFilterManager.getFilter(fieldConfig));
        }
        return this.filter;
    }

    private List<ApplicationUser> makeLazyApplicationUsersFromNames(Collection<String> userNames, CrowdService crowdService) {
        ArrayList<ApplicationUser> users = new ArrayList<ApplicationUser>(userNames.size());
        for (String userName : userNames) {
            users.add(new LazyLoadingApplicationUser(userName, crowdService));
        }
        return users;
    }

    private static class UserNameStringComparator
    implements Comparator<String> {
        private final Collator collator;

        public UserNameStringComparator(Locale locale) {
            this.collator = Collator.getInstance(locale);
            this.collator.setStrength(1);
        }

        @Override
        public int compare(String name1, String name2) {
            if (name1 == null || name2 == null) {
                throw new RuntimeException("Null user name");
            }
            return this.collator.compare(name1, name2);
        }
    }
}

