/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.steps.security;

import com.atlassian.jira.web.filters.steps.security.PathExclusion;
import com.atlassian.jira.web.filters.steps.security.PathExclusionImpl;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathExclusionModuleDescriptor
extends AbstractModuleDescriptor<PathExclusion> {
    private static final Logger log = LoggerFactory.getLogger(PathExclusionModuleDescriptor.class);
    private PathExclusion pathExclusion = ImmutableList::of;

    public PathExclusionModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(@Nonnull Plugin plugin, @Nonnull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.pathExclusion = new PathExclusionImpl(PathExclusionModuleDescriptor.parsePathElements(element));
        log.debug("plugin {} added clickjacking excluded paths: {}", (Object)plugin.getKey(), (Object)this.pathExclusion);
    }

    public PathExclusion getModule() {
        return this.pathExclusion;
    }

    public Class<PathExclusion> getModuleClass() {
        return PathExclusion.class;
    }

    public List<String> getExcludedPaths() {
        return this.getModule().getExcludedPaths();
    }

    private static List<String> parsePathElements(Element root) {
        List pathElements = root.elements("path");
        return pathElements.stream().map(Element::getStringValue).map(String::trim).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
    }
}

