/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.steps.security.csp;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.web.filters.steps.security.csp.Browser;
import com.atlassian.jira.web.filters.steps.security.csp.DynamicContentSecurityPolicyResponseWrapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.atlassian.util.concurrent.LazyReference;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicContentSecurityPolicyResponseWrapperFactory {
    private static final Logger log = LoggerFactory.getLogger(DynamicContentSecurityPolicyResponseWrapperFactory.class);
    private static final Set<String> cspSandboxContentTypeDefaultExceptionList = ImmutableSet.of((Object)"text/html", (Object)"text/javascript", (Object)"application/javascript");
    private static final Set<String> cspSandboxContentDispositionDefaultApplyList = ImmutableSet.of((Object)"attachment");
    private static final String ALLOW_SAME_ORIGIN_POSTFIX = "allow-same-origin";
    private static final String ALLOW_SCRIPTS_POSTFIX = "allow-scripts";
    private static final Map<Browser, String> cspSandboxBrowserDifferentiatedDefaultPostfixes = ImmutableMap.of((Object)((Object)Browser.CHROME_DESKTOP), (Object)"allow-same-origin", (Object)((Object)Browser.CHROME_ANDROID), (Object)"allow-same-origin", (Object)((Object)Browser.CHROME_IOS), (Object)"allow-scripts", (Object)((Object)Browser.SAFARI_DESKTOP), (Object)"allow-scripts", (Object)((Object)Browser.SAFARI_IOS), (Object)"allow-scripts");
    private static final Set<String> cspSandboxBrowserDifferentiatedDefaultPaths = ImmutableSet.of((Object)"/secure/attachment", (Object)"/secure/temporaryattachment");
    private static final String PROPERTY_READ_FAILED_MESSAGE = "Failed to read property '{}'. Check if jira.home is set.";

    public static DynamicContentSecurityPolicyResponseWrapper getWrapper(HttpServletResponse response, HttpServletRequest request) {
        boolean featureFlagEnabled = ComponentAccessor.getComponentSafely(FeatureManager.class).map(manager -> manager.isEnabled(JiraFeatureFlagRegistrar.ENABLE_SANDBOX_CONTENT_SECURITY_POLICY)).orElse(true);
        Optional applicationProperties = ComponentAccessor.getComponentSafely(ApplicationProperties.class);
        Set sandboxContentTypeExceptionList = applicationProperties.flatMap(DynamicContentSecurityPolicyResponseWrapperFactory.readApplicationProperty("jira.security.csp.sandbox.excluded.content.type")).orElse(new HashSet());
        sandboxContentTypeExceptionList.addAll(cspSandboxContentTypeDefaultExceptionList);
        Set<String> sandboxContentDispositionApplyList = applicationProperties.flatMap(DynamicContentSecurityPolicyResponseWrapperFactory.readApplicationProperty("jira.security.csp.sandbox.included.content.disposition")).orElse(cspSandboxContentDispositionDefaultApplyList);
        Set sandboxBrowserDifferentiatedPaths = applicationProperties.flatMap(DynamicContentSecurityPolicyResponseWrapperFactory.readApplicationProperty("jira.security.csp.sandbox.browser.differentiated.paths")).orElse(new HashSet());
        sandboxBrowserDifferentiatedPaths.addAll(cspSandboxBrowserDifferentiatedDefaultPaths);
        Map<Browser, String> sandboxBrowserDifferentiatedPostfixes = applicationProperties.flatMap(DynamicContentSecurityPolicyResponseWrapperFactory.readClausesProperty()).orElse(cspSandboxBrowserDifferentiatedDefaultPostfixes);
        return new DynamicContentSecurityPolicyResponseWrapper(response, request, featureFlagEnabled, sandboxContentTypeExceptionList, sandboxContentDispositionApplyList, sandboxBrowserDifferentiatedPaths, sandboxBrowserDifferentiatedPostfixes);
    }

    private DynamicContentSecurityPolicyResponseWrapperFactory() {
    }

    private static Function<ApplicationProperties, Optional<Set<String>>> readApplicationProperty(String propertyKey) {
        return properties -> {
            try {
                return DynamicContentSecurityPolicyResponseWrapperFactory.splitStringToSet(properties.getDefaultBackedString(propertyKey));
            }
            catch (LazyReference.InitializationException e) {
                log.error(PROPERTY_READ_FAILED_MESSAGE, (Object)propertyKey, (Object)e);
                return Optional.empty();
            }
        };
    }

    private static Function<ApplicationProperties, Optional<Map<Browser, String>>> readClausesProperty() {
        return properties -> {
            try {
                return DynamicContentSecurityPolicyResponseWrapperFactory.splitStringToBrowserMap(properties.getDefaultBackedString("jira.security.csp.sandbox.browser.differentiated.clauses"));
            }
            catch (LazyReference.InitializationException e) {
                log.error(PROPERTY_READ_FAILED_MESSAGE, (Object)"jira.security.csp.sandbox.browser.differentiated.clauses", (Object)e);
                return Optional.empty();
            }
        };
    }

    private static Optional<Set<String>> splitStringToSet(String list) {
        return Optional.ofNullable(list).map(l -> Arrays.stream(l.split(";")).collect(Collectors.toSet()));
    }

    private static Optional<Map<Browser, String>> splitStringToBrowserMap(String list) {
        return Optional.ofNullable(list).map(l -> Arrays.stream(l.split(";")).map(entry -> entry.split(":")).filter(entry -> ((String[])entry).length == 2).collect(Collectors.toMap(entry -> Browser.mapStringToBrowser(entry[0]), entry -> entry[1], (entry1, entry2) -> entry1 + " " + entry2)));
    }
}

