/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.AttachmentNotFoundException;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.AttachmentReadException;
import com.atlassian.jira.issue.attachment.NoAttachmentDataException;
import com.atlassian.jira.issue.attachment.zip.AttachmentZipEntryStreamConsumer;
import com.atlassian.jira.issue.attachment.zip.AttachmentZipFileCreator;
import com.atlassian.jira.issue.attachment.zip.ZipEntryNotFoundException;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.IOUtil;
import com.atlassian.jira.util.http.JiraHttpUtils;
import com.atlassian.jira.util.io.InputStreamConsumer;
import com.atlassian.jira.util.mime.MimeManager;
import com.atlassian.jira.web.exception.WebExceptionChecker;
import com.atlassian.jira.web.servlet.MimeSniffingKit;
import com.atlassian.seraph.util.RedirectUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentZipServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(AttachmentZipServlet.class);
    private static final String SECURE_VIEWS_SECURITYBREACH_JSP = "/secure/views/securitybreach.jsp";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final Pattern ISSUE_ID_ONLY = Pattern.compile(".+/([0-9]+)\\.zip");
    private static final Pattern ISSUE_ID_AND_ZIP = Pattern.compile(".+/unzip/([0-9]+)/([0-9]+)(\\[|%5B)([0-9]+)(\\]|%5D)/.*");

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Issue issue;
        if (!this.checkSupportEnabled()) {
            httpServletResponse.sendError(404, "Attachments as ZIP support is disabled");
            return;
        }
        String uri = httpServletRequest.getRequestURI();
        try {
            issue = this.getIssue(uri);
        }
        catch (PermissionException e) {
            this.redirectForSecurityBreach(httpServletRequest, httpServletResponse);
            return;
        }
        if (issue == null) {
            httpServletResponse.sendError(404, "Could not find issue");
            return;
        }
        if (uri.contains("unzip")) {
            this.unzipSpecifiedAttachment(httpServletResponse, issue, uri);
        } else {
            this.zipAllAttachments(httpServletRequest, httpServletResponse, issue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zipAllAttachments(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Issue issue) throws IOException, ServletException {
        block10: {
            File zipFile;
            String issueKey = issue.getKey();
            try {
                zipFile = this.createAttachmentsZipFile(issue);
            }
            catch (IOException e) {
                log.error("Can not create temporary zip file : " + httpServletRequest.getPathInfo() + ": " + e.getMessage(), (Throwable)e);
                httpServletResponse.sendError(404, "Could not create zip file for issue : " + issueKey);
                return;
            }
            try {
                this.setResponseHeaders(httpServletRequest, httpServletResponse, zipFile, issueKey);
                this.writeZipResponse(httpServletResponse, new FileInputStream(zipFile));
            }
            catch (Exception e) {
                if (WebExceptionChecker.canBeSafelyIgnored(e)) {
                    return;
                }
                if (!httpServletResponse.isCommitted()) {
                    httpServletResponse.sendError(404, "Could not serve zip file of attachments for issue " + issueKey + " : " + e.getMessage());
                    break block10;
                }
                throw new ServletException("Could not serve zip file of attachments for issue " + issueKey, (Throwable)e);
            }
            finally {
                this.deleteFile(zipFile);
            }
        }
    }

    private void unzipSpecifiedAttachment(HttpServletResponse httpServletResponse, Issue issue, String uri) throws IOException {
        String issueKey = issue.getKey();
        Matcher matcher = ISSUE_ID_AND_ZIP.matcher(uri);
        if (!matcher.find() || matcher.groupCount() != 5) {
            httpServletResponse.sendError(404, "Could not create zip file for issue : " + issueKey);
            return;
        }
        long attachmentId = Long.parseLong(matcher.group(2));
        int entryIndex = Integer.parseInt(matcher.group(4));
        AttachmentZipEntryStreamConsumer zipEntryStreamConsumer = new AttachmentZipEntryStreamConsumer((OutputStream)httpServletResponse.getOutputStream(), this.createOnZipExistsFunction(httpServletResponse), entryIndex, ComponentAccessor.getApplicationProperties());
        try {
            AttachmentManager attachmentManager = (AttachmentManager)ComponentAccessor.getComponent(AttachmentManager.class);
            Attachment attachment = attachmentManager.getAttachment(Long.valueOf(attachmentId));
            attachmentManager.streamAttachmentContent(attachment, (InputStreamConsumer)zipEntryStreamConsumer);
        }
        catch (AttachmentNotFoundException e) {
            httpServletResponse.sendError(404, String.format("Could not find attachment with id: %d", attachmentId));
        }
        catch (AttachmentReadException | NoAttachmentDataException e) {
            httpServletResponse.sendError(400, e.getMessage());
        }
        catch (ZipEntryNotFoundException e) {
            httpServletResponse.sendError(404, String.format("Could not find entry with index: %d  in attachment with id: %d", entryIndex, attachmentId));
        }
        catch (IOException e) {
            httpServletResponse.sendError(500, String.format("Could not load entry with index: %d in attachment with id: %d because of unexpected error", entryIndex, attachmentId));
        }
    }

    private Consumer<ZipArchiveEntry> createOnZipExistsFunction(final HttpServletResponse httpServletResponse) {
        return new Consumer<ZipArchiveEntry>(){

            public void consume(@Nonnull ZipArchiveEntry element) {
                AttachmentZipServlet.this.sniffContentAndSetZipEntryResponseHeaders(httpServletResponse, element);
            }
        };
    }

    private void sniffContentAndSetZipEntryResponseHeaders(HttpServletResponse httpServletResponse, ZipArchiveEntry zipEntry) {
        MimeManager mimeManager = (MimeManager)ComponentAccessor.getComponent(MimeManager.class);
        String suggestedContentType = mimeManager.getSanitisedMimeType(APPLICATION_OCTET_STREAM, zipEntry.getName());
        try {
            this.setFileDownloadHeaders(httpServletResponse, zipEntry.getSize(), zipEntry.getName(), suggestedContentType);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to set appropriate file download headers because of: " + e.getMessage());
        }
    }

    private void redirectForSecurityBreach(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.getLoggedInUser() != null) {
            RequestDispatcher rd = httpServletRequest.getRequestDispatcher(SECURE_VIEWS_SECURITYBREACH_JSP);
            JiraHttpUtils.setNoCacheHeaders((HttpServletResponse)httpServletResponse);
            rd.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        } else {
            httpServletResponse.sendRedirect(RedirectUtils.getLoginUrl((HttpServletRequest)httpServletRequest));
        }
    }

    private Issue getIssue(String url) throws PermissionException {
        Matcher matcher = ISSUE_ID_ONLY.matcher(url);
        String issueId = null;
        if (matcher.find()) {
            issueId = matcher.group(1);
        } else {
            matcher = ISSUE_ID_AND_ZIP.matcher(url);
            if (matcher.find() && matcher.groupCount() == 5) {
                issueId = matcher.group(1);
            }
        }
        return this.parseForIssue(issueId);
    }

    private Issue parseForIssue(String issueId) throws PermissionException {
        if (issueId == null) {
            return null;
        }
        try {
            Long id = Long.parseLong(issueId);
            MutableIssue issue = ComponentAccessor.getIssueManager().getIssueObject(id);
            if (issue != null && !this.hasPermissionToViewAttachment((Issue)issue)) {
                throw new PermissionException("The user does not have permission to see this issue");
            }
            return issue;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private File createAttachmentsZipFile(Issue issue) throws IOException {
        AttachmentZipFileCreator zipFileCreator = (AttachmentZipFileCreator)ComponentAccessor.getComponent(AttachmentZipFileCreator.class);
        return zipFileCreator.toZipFile(issue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeZipResponse(HttpServletResponse httpServletResponse, InputStream inputStream) throws IOException {
        boolean bytesWritten = false;
        ServletOutputStream out = httpServletResponse.getOutputStream();
        byte[] buffer = new byte[4096];
        try {
            int bytesRead;
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                bytesWritten = true;
            }
        }
        finally {
            IOUtil.shutdownStream(inputStream);
            IOUtil.shutdownStream((OutputStream)out);
        }
        return bytesWritten;
    }

    private void setResponseHeaders(HttpServletRequest request, HttpServletResponse response, File file, String issueKey) throws IOException {
        this.setFileDownloadHeaders(response, file.length(), issueKey + ".zip", "application/zip");
    }

    private void setFileDownloadHeaders(HttpServletResponse httpServletResponse, long fileSize, String fileName, String contentType) throws IOException {
        httpServletResponse.setContentType(contentType);
        if (fileSize >= 0L) {
            httpServletResponse.setContentLength((int)fileSize);
        }
        MimeSniffingKit sniffingKit = (MimeSniffingKit)ComponentAccessor.getComponent(MimeSniffingKit.class);
        sniffingKit.setAttachmentResponseHeaders(fileName, contentType, httpServletResponse);
    }

    private boolean hasPermissionToViewAttachment(Issue issue) throws DataAccessException {
        return ComponentAccessor.getPermissionManager().hasPermission(10, issue, this.getLoggedInUser());
    }

    private void deleteFile(File zipFile) {
        if (zipFile != null) {
            zipFile.delete();
        }
    }

    private boolean checkSupportEnabled() {
        ApplicationProperties ap = this.getApplicationProperties();
        return ap.getOption("jira.option.allowattachments") && ap.getOption("jira.attachment.allow.zip.support");
    }

    ApplicationProperties getApplicationProperties() {
        return ComponentAccessor.getApplicationProperties();
    }

    protected ApplicationUser getLoggedInUser() {
        return ((JiraAuthenticationContext)ComponentAccessor.getComponent(JiraAuthenticationContext.class)).getUser();
    }
}

