/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponseHeaders {
    private static final Logger log = LoggerFactory.getLogger(HttpResponseHeaders.class);
    private static final long ABOUT_ONE_YEAR = 31536000L;
    public static final long ONE_DAY = 86400L;
    public static final long ABOUT_ONE_YEAR_MILLIS = TimeUnit.MILLISECONDS.convert(31536000L, TimeUnit.SECONDS);
    private static final String CACHE_PRIVATELY_TEMPLATE = "private, max-age=%d";
    private static final String CACHE_PRIVATELY_ONE_YEAR = String.format("private, max-age=%d", ABOUT_ONE_YEAR_MILLIS);

    public static void cachePrivatelyForAboutOneYear(HttpServletResponse response) {
        HttpResponseHeaders.cachePrivatelyForSeconds(response, 31536000L);
    }

    public static void cachePrivatelyForSeconds(HttpServletResponse response, long seconds) {
        if (response == null) {
            throw new NullPointerException("response");
        }
        response.setHeader("Cache-control", String.format(CACHE_PRIVATELY_TEMPLATE, seconds));
        response.setDateHeader("Expires", -1L);
    }

    public static void cachePubliclyForAboutOneYear(HttpServletResponse response) {
        if (response == null) {
            throw new NullPointerException("response");
        }
        response.setHeader("Cache-control", CACHE_PRIVATELY_ONE_YEAR);
        response.setDateHeader("Expires", System.currentTimeMillis() + ABOUT_ONE_YEAR_MILLIS);
    }

    private HttpResponseHeaders() {
    }
}

