/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet.viewfile;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.AttachmentNotFoundException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.util.io.InputStreamConsumer;
import com.atlassian.jira.web.servlet.CommonAttachment;
import com.atlassian.jira.web.servlet.CommonAttachmentImpl;
import com.atlassian.jira.web.servlet.HttpResponseHeaders;
import com.atlassian.jira.web.servlet.MimeSniffingKit;
import com.atlassian.jira.web.servlet.viewfile.AbstractViewFileServlet;
import com.atlassian.jira.web.servlet.viewfile.RangeResponse;
import io.atlassian.fugue.Unit;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ViewAttachmentServlet
extends AbstractViewFileServlet {
    private final Supplier<MimeSniffingKit> mimeSniffingKitSupplier = () -> (MimeSniffingKit)ComponentAccessor.getComponent(MimeSniffingKit.class);

    @Override
    protected int getContentLength(String attachmentPath) {
        Attachment attachment = this.getAttachment(attachmentPath);
        return attachment.getFilesize().intValue();
    }

    @Override
    protected boolean supportsRangeRequests() {
        return true;
    }

    @Override
    protected void getInputStream(HttpServletRequest request, String attachmentQuery, InputStreamConsumer<Unit> consumer) throws IOException, PermissionException {
        Attachment attachment = this.getAttachment(attachmentQuery);
        this.checkRequesterIsPermittedToViewTheAttachment(attachment, request, "You do not have permissions to view this issue");
        this.getAttachmentManager().streamAttachmentContent(attachment, consumer);
    }

    @Override
    protected void setResponseContentHeaders(HttpServletRequest request, Optional<RangeResponse> rangeResponse, HttpServletResponse response) throws AttachmentNotFoundException, IOException {
        CommonAttachment attachment = this.getCommonAttachment(this.attachmentQuery(request));
        response.setContentType(attachment.getContentType());
        if (rangeResponse.isPresent()) {
            response.setStatus(206);
            response.setContentLength(rangeResponse.get().calculateContentLength());
            response.setHeader("Content-Range", rangeResponse.get().calculateContentRange());
        } else {
            response.setContentLength(attachment.getLength());
        }
        response.setHeader("Accept-Ranges", "bytes");
        this.mimeSniffingKitSupplier.get().setAttachmentResponseHeaders(attachment, request.getHeader("USER-AGENT"), response);
        HttpResponseHeaders.cachePrivatelyForAboutOneYear(response);
    }

    protected CommonAttachment getCommonAttachment(String query) {
        Attachment attachment = this.getAttachment(query);
        return new CommonAttachmentImpl(attachment.getFilename(), attachment.getMimetype(), attachment.getFilesize().intValue());
    }
}

