/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.sitemesh;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.admin.TabLoadedDataProvider;
import com.atlassian.jira.admin.TabLoadedEvent;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkSection;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.soy.SoyTemplateRendererProvider;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.http.JiraUrl;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.model.WebPanel;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminDecoratorHelper {
    public static final String SYSTEM_ADMIN_TOP_NAVIGATION_BAR = "system.admin.top.navigation.bar";
    public static final String SYSTEM_ADMIN_TOP = "system.admin.top";
    public static final String ACTIVE_SECTION_KEY = "admin.active.section";
    public static final String ACTIVE_TAB_LINK_KEY = "admin.active.tab";
    private static final Logger log = LoggerFactory.getLogger(AdminDecoratorHelper.class);
    private static final String ADMIN_SIDEBAR_LOCATION = "atl.jira.proj.config.main-sidebar";
    private static final String NAV_PANEL_LOCATION = "atl.jira.proj.config.sidebar";
    private static final String PROJECT_CONFIG = "atl.jira.proj.config";
    public static final String WEB_ITEM_SOURCE_QUERY_PARAM = "s";
    private static final String ADMIN_UI_LOCATIONS_DOCS = "ui.locations.admin";
    private final WebInterfaceManager webInterfaceManager;
    private final ProjectService service;
    private final JiraAuthenticationContext authCtx;
    private final JiraProperties jiraProperties;
    private final HelpUrls helpUrls;
    private final SimpleLinkManager linkManager;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final EventPublisher eventPublisher;
    private final TabLoadedDataProvider tabLoadedDataProvider;
    private String projectKey;
    private String currentTab;
    private String currentSection;
    private String selectedMenuSection;
    private boolean selectedLinkFound;
    private boolean selectedLinkFoundUsingLinkId;
    private ProjectService.GetProjectResult result;
    private Sidebar sidebar;
    private String sidebarHtml;
    private List<Header> headers;
    private String headerHtml;
    private Map<String, Object> sideMenuSoyRenderData;
    private LinkedList<PathSegment> pathToLink;

    public AdminDecoratorHelper(WebInterfaceManager webInterfaceManager, ProjectService projectService, JiraAuthenticationContext authenticationContext, JiraProperties jiraProperties, HelpUrls helpUrls, SimpleLinkManager linkManager, SoyTemplateRendererProvider soyTemplateRendererProvider, EventPublisher eventPublisher, TabLoadedDataProvider tabLoadedDataProvider) {
        this.webInterfaceManager = webInterfaceManager;
        this.service = projectService;
        this.authCtx = authenticationContext;
        this.jiraProperties = jiraProperties;
        this.helpUrls = helpUrls;
        this.linkManager = linkManager;
        this.soyTemplateRenderer = soyTemplateRendererProvider.getRenderer();
        this.eventPublisher = eventPublisher;
        this.tabLoadedDataProvider = tabLoadedDataProvider;
    }

    public boolean isProjectAdministration() {
        return this.getProject() != null;
    }

    public boolean isAdminMenusAllHidden() {
        return this.getSelectedMenuSection() == null || this.getSelectedMenuSection().equals(SYSTEM_ADMIN_TOP_NAVIGATION_BAR);
    }

    public AdminDecoratorHelper setProject(String projectKey) {
        this.clearCache();
        this.projectKey = StringUtils.stripToNull((String)projectKey);
        return this;
    }

    public AdminDecoratorHelper setCurrentTab(String currentTab) {
        this.clearCache();
        this.selectedLinkFound = false;
        this.selectedLinkFoundUsingLinkId = false;
        this.currentTab = StringUtils.stripToNull((String)currentTab);
        this.sideMenuSoyRenderData = this.makeSideMenuSoyRenderData(null, null, SYSTEM_ADMIN_TOP, SYSTEM_ADMIN_TOP_NAVIGATION_BAR, null, 0, true);
        if (this.jiraProperties.isDevMode()) {
            String helpUrl = this.helpUrls.getUrl(ADMIN_UI_LOCATIONS_DOCS).getUrl();
            if (!this.selectedLinkFound) {
                if (Objects.isNull(currentTab)) {
                    log.error("Jira was NOT able to figure out the selected web-item. Please provide a meta tag, withthe name: {} , e.g <meta name=\"{}\" content=\"WEB-ITEM-LINK-ID-GOES-HERE\"/> To learn more: {}", new Object[]{ACTIVE_TAB_LINK_KEY, ACTIVE_TAB_LINK_KEY, helpUrl});
                } else {
                    log.error("Jira was NOT able to figure out the selected web-item. A meta tag with the name: {} was detected, but content: {} didn't match any web-item's link ID. To learn more: {}", new Object[]{ACTIVE_TAB_LINK_KEY, currentTab, helpUrl});
                }
            }
            if (this.selectedLinkFound && !this.selectedLinkFoundUsingLinkId) {
                if (Objects.isNull(currentTab)) {
                    log.warn("Jira was able to figure out the selected web-item, but there's no guarantee it will always be able to. Please provide a meta tag, with the name: {} , e.g<meta name=\"{}\" content=\"WEB-ITEM-LINK-ID-GOES-HERE\"/> To learn more: {}", new Object[]{ACTIVE_TAB_LINK_KEY, ACTIVE_TAB_LINK_KEY, helpUrl});
                } else {
                    log.warn("Jira was able to figure out the selected web-item, but there's no guarantee it will always be able to. A meta tag with the name: {} was detected, but the content: {} didn't match any web-item's link ID. To learn more: {}", new Object[]{ACTIVE_TAB_LINK_KEY, currentTab, helpUrl});
                }
            }
        }
        return this;
    }

    public AdminDecoratorHelper setCurrentSection(String currentSection) {
        this.clearCache();
        this.currentSection = StringUtils.stripToNull((String)currentSection);
        this.selectedMenuSection = StringUtils.contains((CharSequence)currentSection, (CharSequence)"/") ? currentSection.substring(0, currentSection.indexOf("/")) : currentSection;
        if (StringUtils.equals((CharSequence)PROJECT_CONFIG, (CharSequence)this.selectedMenuSection)) {
            this.selectedMenuSection = "admin_project_current";
        }
        return this;
    }

    public void triggerTabLoaded() {
        Project project = this.getProject();
        Long projectId = project != null ? project.getId() : 0L;
        this.eventPublisher.publish((Object)new TabLoadedEvent(projectId, this.currentTab, this.tabLoadedDataProvider.isAdmin(this.authCtx.getLoggedInUser()), this.tabLoadedDataProvider.isSysAdmin(this.authCtx.getLoggedInUser()), this.tabLoadedDataProvider.hasExtPermission(project)));
    }

    public String getSelectedMenuSection() {
        if (this.selectedMenuSection == null && this.pathToLink != null) {
            for (PathSegment pathSegment : this.pathToLink) {
                if (!SYSTEM_ADMIN_TOP_NAVIGATION_BAR.equals(pathSegment.getParentSectionId())) continue;
                this.selectedMenuSection = pathSegment.getSectionId();
            }
        }
        return this.selectedMenuSection;
    }

    public boolean hasKey() {
        return this.projectKey != null;
    }

    private Sidebar getSidebar() {
        if (this.sidebar != null) {
            return this.sidebar;
        }
        Project project = this.getProject();
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("project", project);
        context.put("helper", new JiraHelper(ExecutingHttpRequest.get(), project));
        List panels = this.webInterfaceManager.getDisplayableWebPanels(ADMIN_SIDEBAR_LOCATION, context);
        Optional<Sidebar> sidebar = panels.stream().findFirst().map(panel -> new Sidebar((WebPanel)panel, context));
        if (sidebar.isPresent()) {
            this.sidebar = sidebar.get();
        }
        return this.sidebar;
    }

    public List<Header> getHeaders() {
        List headers;
        String headerPanelSection;
        HashMap<String, Object> context;
        if (this.headers != null) {
            return this.headers;
        }
        Project project = this.getProject();
        if (project == null) {
            List<Map<String, Object>> adminNavigationSections = this.getSoyReadyAdminNavigationSections();
            context = MapBuilder.build((Object)ACTIVE_SECTION_KEY, (Object)this.currentSection, (Object)ACTIVE_TAB_LINK_KEY, (Object)this.currentTab, (Object)"adminNavigationPrimary", adminNavigationSections);
            headerPanelSection = "system.admin.decorator.header";
        } else {
            List<Map<String, Object>> adminNavigationLinksPrimary = this.getSoyReadyNavigationLinksForSection("atj.jira.proj.nav.switcher", "project-navswitcher");
            List<Map<String, Object>> adminNavigationLinksSecondary = this.getSoyReadyNavigationLinksForSection("atj.jira.proj.nav.switcher", "project-navswitcher-secondary");
            context = new HashMap<String, Object>();
            context.put("project", project);
            context.put(ACTIVE_SECTION_KEY, this.currentSection);
            context.put(ACTIVE_TAB_LINK_KEY, this.currentTab);
            context.put("adminNavigationPrimary", adminNavigationLinksPrimary);
            context.put("adminNavigationSecondary", adminNavigationLinksSecondary);
            headerPanelSection = "atl.jira.proj.config.header";
        }
        List panels = this.webInterfaceManager.getDisplayableWebPanels(headerPanelSection, Collections.emptyMap());
        this.headers = headers = (List)panels.stream().map(panel -> new Header((WebPanel)panel, context)).collect(CollectorsUtil.toNewArrayListWithSizeOf((Collection)panels));
        return this.headers;
    }

    private List<Map<String, Object>> getSoyReadyNavigationLinksForSection(String parentSection, String section) {
        List<SimpleLink> projectAdminLinks = this.getLinksForSection(parentSection, section);
        if (projectAdminLinks == null) {
            return Lists.newArrayList();
        }
        ArrayList soyedMainLinkSections = Lists.newArrayListWithCapacity((int)projectAdminLinks.size());
        for (SimpleLink currentLink : projectAdminLinks) {
            HashMap<String, Object> soyedSection = new HashMap<String, Object>();
            String id = currentLink.getId();
            soyedSection.put("id", id);
            soyedSection.put("link", currentLink.getUrl());
            soyedSection.put("label", currentLink.getLabel());
            soyedSection.put("isSelected", id.equalsIgnoreCase("project-admin-link"));
            if (StringUtils.isNotEmpty((CharSequence)currentLink.getStyleClass())) {
                soyedSection.put("styleClass", currentLink.getStyleClass());
            }
            soyedMainLinkSections.add(soyedSection);
        }
        return soyedMainLinkSections;
    }

    private List<Map<String, Object>> getSoyReadyAdminNavigationSections() {
        Iterable mainAdminSections = Iterables.concat((Iterable)Iterables.transform(this.getChildSectionsForSection(SYSTEM_ADMIN_TOP), section -> this.getChildSectionsForSection(section.getId())));
        ArrayList soyedMainLinkSections = Lists.newArrayList();
        for (SimpleLinkSection currentSection : mainAdminSections) {
            HashMap soyedSection = Maps.newHashMap();
            SimpleLink firstLink = this.findFirstLinkForSection(currentSection, this.authCtx.getUser(), this.getJiraHelper());
            if (firstLink == null) {
                firstLink = this.findFirstLinkForMainSection(currentSection, this.authCtx.getUser(), this.getJiraHelper());
            }
            if (firstLink == null) continue;
            soyedSection.put("link", firstLink.getUrl());
            soyedSection.put("label", currentSection.getLabel());
            soyedSection.put("isSelected", currentSection.getId().equalsIgnoreCase(this.getSelectedMenuSection()));
            soyedMainLinkSections.add(soyedSection);
        }
        return soyedMainLinkSections;
    }

    private SimpleLink findFirstLinkForMainSection(SimpleLinkSection adminMainSection, ApplicationUser user, JiraHelper helper) {
        List links = this.linkManager.getLinksForSection(adminMainSection.getId(), user, helper);
        if (!links.isEmpty()) {
            return (SimpleLink)links.get(0);
        }
        return null;
    }

    @Nullable
    private SimpleLink findFirstLinkForSection(@Nonnull SimpleLinkSection adminHeaderSection, @Nullable ApplicationUser user, @Nonnull JiraHelper helper) {
        List nonEmptySubSections = this.linkManager.getNotEmptySectionsForLocation(adminHeaderSection.getId(), user, helper);
        for (SimpleLinkSection subSection : nonEmptySubSections) {
            if (PROJECT_CONFIG.equals(subSection.getId())) continue;
            String subSectionKey = adminHeaderSection.getId() + "/" + subSection.getId();
            List links = this.linkManager.getLinksForSection(subSectionKey, user, helper);
            if (!links.isEmpty()) {
                return (SimpleLink)links.get(0);
            }
            SimpleLink firstLinkOfSubSection = this.findFirstLinkForSection(subSection, user, helper);
            if (firstLinkOfSubSection == null) continue;
            return firstLinkOfSubSection;
        }
        return null;
    }

    public String getHeaderHtml() {
        if (this.headerHtml != null) {
            return this.headerHtml;
        }
        StringBuilder builder = new StringBuilder();
        for (Header header : this.getHeaders()) {
            builder.append(header.getHtml());
        }
        this.headerHtml = StringUtils.trimToEmpty((String)builder.toString());
        return this.headerHtml;
    }

    public String getSidebarHtml() {
        if (this.sidebarHtml != null) {
            return this.sidebarHtml;
        }
        Sidebar sidebar = this.getSidebar();
        if (sidebar != null) {
            this.sidebarHtml = sidebar.getHtml();
        }
        return StringUtils.trimToEmpty((String)this.sidebarHtml);
    }

    public boolean isHasSidebar() {
        return StringUtils.isNotEmpty((CharSequence)this.getSidebarHtml());
    }

    public boolean isHasHeader() {
        return StringUtils.isNotEmpty((CharSequence)this.getHeaderHtml());
    }

    public String getSideMenuHtml(String sectionId) {
        List<SimpleLinkSection> sections = this.getChildSectionsForSection(SYSTEM_ADMIN_TOP_NAVIGATION_BAR);
        SimpleLinkSection section = null;
        for (SimpleLinkSection simpleLinkSection : sections) {
            if (!simpleLinkSection.getId().equals(sectionId)) continue;
            section = simpleLinkSection;
            break;
        }
        if (section == null) {
            return null;
        }
        Map currentSectionMenuData = null;
        if (!StringUtils.equals((CharSequence)"admin_project_current", (CharSequence)sectionId)) {
            String menuLabel;
            String string = menuLabel = section.getTitle() != null ? section.getTitle() : section.getLabel();
            if (this.sideMenuSoyRenderData != null) {
                for (Map sectionMenuData : (List)this.sideMenuSoyRenderData.get("sections")) {
                    if (sectionMenuData == null || !sectionMenuData.get("sectionId").equals(sectionId)) continue;
                    currentSectionMenuData = sectionMenuData;
                    currentSectionMenuData.put("menuLabel", menuLabel);
                    currentSectionMenuData.remove("label");
                    break;
                }
            }
        } else {
            currentSectionMenuData = this.makeSideMenuSoyRenderData(null, null, SYSTEM_ADMIN_TOP_NAVIGATION_BAR, sectionId, null, 0, true);
        }
        if (currentSectionMenuData == null) {
            return null;
        }
        try {
            return this.soyTemplateRenderer.render("com.atlassian.jira.jira-header-plugin:admin-side-nav-menu", "JIRA.Templates.Menu.admin.side.navigation.menusection", currentSectionMenuData);
        }
        catch (SoyException e) {
            log.warn("Could not render soy template for side admin menu");
            log.debug("Exception: ", (Throwable)e);
            return null;
        }
    }

    private Map<String, Object> makeSideMenuSoyRenderData(String title, String label, String parentSectionId, String sectionId, String sectionLabel, int weight, boolean blessedSection) {
        if (!this.getSectionContainsAtleastOneLink(parentSectionId, sectionId)) {
            return null;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("title", title);
        data.put("label", label);
        data.put("menuLabel", sectionLabel);
        data.put("parentSectionId", parentSectionId);
        data.put("sectionId", sectionId);
        String selectedMenuSection = this.getSelectedMenuSection();
        if (blessedSection || SYSTEM_ADMIN_TOP.equals(parentSectionId) || SYSTEM_ADMIN_TOP_NAVIGATION_BAR.equals(parentSectionId) || parentSectionId.equals(selectedMenuSection)) {
            data.put("links", this.makeLinksForSection(parentSectionId, sectionId));
            data.put("sections", this.makeChildSectionsForSection(sectionId, blessedSection || parentSectionId.equals(selectedMenuSection)));
        }
        data.put("weight", weight);
        return data;
    }

    private List<Map<String, Object>> makeChildSectionsForSection(String sectionId, boolean blessedSection) {
        ArrayList sections = Lists.newArrayList();
        for (SimpleLinkSection linkSection : this.getChildSectionsForSection(sectionId)) {
            Map<String, Object> section = this.makeSideMenuSoyRenderData(linkSection.getTitle(), linkSection.getLabel(), sectionId, linkSection.getId(), null, linkSection.getWeight(), blessedSection);
            if (section == null) continue;
            sections.add(section);
        }
        if (sectionId.toLowerCase().equals(PROJECT_CONFIG)) {
            sections.addAll(this.getProjectAdminNavPanelSections());
            Collections.sort(sections, new NavSectionComparator());
        }
        return sections;
    }

    private List<Map<String, Object>> getProjectAdminNavPanelSections() {
        List webPanelDescriptors = this.webInterfaceManager.getDisplayableWebPanelDescriptors(NAV_PANEL_LOCATION, Collections.emptyMap());
        ArrayList panelSectionList = Lists.newArrayListWithExpectedSize((int)webPanelDescriptors.size());
        for (WebPanelModuleDescriptor panelDescriptor : webPanelDescriptors) {
            CollectionUtils.addIgnoreNull((Collection)panelSectionList, (Object)SafePluginPointAccess.call(() -> this.makeSideMenuSoyRenderDataForWebPanel(panelDescriptor)).getOrNull());
        }
        return panelSectionList;
    }

    private Map<String, Object> makeSideMenuSoyRenderDataForWebPanel(WebPanelModuleDescriptor panelDescriptor) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("title", panelDescriptor.getKey());
        data.put("sectionId", panelDescriptor.getKey());
        data.put("weight", panelDescriptor.getWeight());
        HashMap<String, Project> contextMap = new HashMap<String, Project>();
        contextMap.put("project", this.getProject());
        data.put("html", ((WebPanel)panelDescriptor.getModule()).getHtml(contextMap));
        return data;
    }

    @VisibleForTesting
    List<Map<String, Object>> makeLinksForSection(String parentSectionId, String sectionId) {
        List<SimpleLink> linksForSection = this.getLinksForSection(parentSectionId, sectionId);
        ArrayList links = Lists.newArrayListWithCapacity((int)linksForSection.size());
        for (SimpleLink simpleLink : linksForSection) {
            HashMap<String, Object> link = new HashMap<String, Object>();
            link.put("url", simpleLink.getUrl());
            link.put("id", simpleLink.getId());
            link.put("label", simpleLink.getLabel());
            link.put("accessKey", simpleLink.getAccessKey());
            link.put("selected", this.isSelectedLink(simpleLink));
            link.put("params", simpleLink.getParams());
            link.put("isLabs", simpleLink.getParams() != null && Boolean.valueOf((String)simpleLink.getParams().get("labs")) != false);
            links.add(link);
        }
        return links;
    }

    private boolean isSelectedLink(SimpleLink simpleLink) {
        boolean selected;
        boolean bl = selected = simpleLink.getId() != null && simpleLink.getId().equalsIgnoreCase(this.currentTab);
        if (selected) {
            this.selectedLinkFoundUsingLinkId = true;
        }
        if (!selected && this.noCurrentTabSelected()) {
            String src = this.getHttpRequest().getParameter(WEB_ITEM_SOURCE_QUERY_PARAM);
            boolean bl2 = selected = src != null ? src.equals(simpleLink.getId()) : this.linkPointsToCurrentRequestURI(simpleLink);
        }
        if (selected) {
            this.selectedLinkFound = true;
            this.selectedMenuSection = this.findMenuSection(simpleLink);
            if (!this.noCurrentTabSelected() && !this.linkPointsToCurrentRequestURI(simpleLink)) {
                PathSegment pathSegment = this.pathToLink.getLast();
                this.pathToLink.add(new PathSegment(pathSegment.getSectionId(), this.currentTab, simpleLink.getLabel(), simpleLink.getUrl()));
            }
        }
        return selected;
    }

    private boolean noCurrentTabSelected() {
        return StringUtils.isBlank((CharSequence)this.currentTab);
    }

    private boolean linkPointsToCurrentRequestURI(SimpleLink simpleLink) {
        return this.getHttpRequest().getRequestURI().endsWith(JiraUrl.extractActionFromURL((String)simpleLink.getUrl()));
    }

    private String findMenuSection(SimpleLink simpleLink) {
        LinkedList<PathSegment> pathToLink = this.getPathToLink(simpleLink);
        for (PathSegment pathSegment : pathToLink) {
            if (!SYSTEM_ADMIN_TOP_NAVIGATION_BAR.equals(pathSegment.getParentSectionId())) continue;
            return pathSegment.getSectionId();
        }
        return null;
    }

    private Project getProject() {
        ProjectService.GetProjectResult projectResult = this.getProjectResult();
        if (projectResult != null && projectResult.isValid()) {
            return projectResult.getProject();
        }
        return null;
    }

    private ProjectService.GetProjectResult getProjectResult() {
        if (this.result == null && this.hasKey()) {
            this.result = this.service.getProjectByKeyForAction(this.authCtx.getUser(), this.projectKey, ProjectAction.EDIT_PROJECT_CONFIG);
        }
        return this.result;
    }

    private void clearCache() {
        this.result = null;
        this.sidebar = null;
        this.sidebarHtml = null;
        this.headers = null;
        this.headerHtml = null;
    }

    public HttpServletRequest getHttpRequest() {
        return ExecutingHttpRequest.get();
    }

    protected String encode(String string) {
        return JiraUrlCodec.encode((String)string, (boolean)true);
    }

    private JiraHelper getJiraHelper() {
        MapBuilder context = MapBuilder.newBuilder();
        context.add((Object)"project", (Object)this.getProject());
        if (this.getProject() != null) {
            context.add((Object)"projectKeyEncoded", (Object)this.encode(this.getProject().getKey()));
        }
        return new JiraHelper(this.getHttpRequest(), this.getProject(), context.toMap());
    }

    public List<SimpleLinkSection> getChildSectionsForSection(String location) {
        return this.linkManager.getSectionsForLocation(location, this.authCtx.getUser(), this.getJiraHelper());
    }

    public List<SimpleLink> getLinksForSection(String parentSection, String section) {
        if (parentSection.equals(PROJECT_CONFIG) && this.getProject() == null) {
            return Lists.newArrayList();
        }
        MapBuilder context = MapBuilder.newBuilder();
        context.add((Object)"project", (Object)this.getProject());
        if (this.getProject() != null) {
            context.add((Object)"projectKeyEncoded", (Object)this.encode(this.getProject().getKey()));
        }
        String sectionId = parentSection + "/" + section;
        return this.linkManager.getLinksForSection(sectionId, this.authCtx.getUser(), this.getJiraHelper());
    }

    public boolean getSectionContainsAtleastOneLink(String parentSection, String section) {
        LinkedList<Pair> parentAndSectionList = new LinkedList<Pair>();
        parentAndSectionList.add(Pair.nicePairOf((Object)parentSection, (Object)section));
        while (!parentAndSectionList.isEmpty()) {
            List<SimpleLink> links;
            Pair currentPair = (Pair)parentAndSectionList.pop();
            List<SimpleLinkSection> sectionList = this.getChildSectionsForSection((String)currentPair.second());
            if (sectionList != null) {
                for (SimpleLinkSection aSectionList : sectionList) {
                    parentAndSectionList.addLast(Pair.of((Object)currentPair.second(), (Object)aSectionList.getId()));
                }
            }
            if ((links = this.getLinksForSection((String)currentPair.first(), (String)currentPair.second())) == null || links.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public LinkedList<PathSegment> getPathToLink(SimpleLink simpleLink) {
        if (this.pathToLink != null) {
            return this.pathToLink;
        }
        this.pathToLink = this.generatePathToLink(SYSTEM_ADMIN_TOP, simpleLink);
        return this.pathToLink;
    }

    private LinkedList<PathSegment> generatePathToLink(String section, SimpleLink simpleLink) {
        LinkedList potentiallPathsList = new LinkedList();
        LinkedList<PathSegment> sectionsList = new LinkedList<PathSegment>();
        sectionsList.add(new PathSegment(null, section, null, null));
        potentiallPathsList.add(sectionsList);
        while (!potentiallPathsList.isEmpty()) {
            LinkedList currentList = (LinkedList)potentiallPathsList.pop();
            PathSegment currentPathSegment = (PathSegment)currentList.getLast();
            for (SimpleLinkSection simpleLinkSection : this.getChildSectionsForSection(currentPathSegment.getSectionId())) {
                boolean found = false;
                LinkedList<PathSegment> currentPathSegmentList = new LinkedList<PathSegment>();
                currentPathSegmentList.addAll(currentList);
                SimpleLinkSection currentLinkSection = simpleLinkSection;
                String name = currentLinkSection.getTitle() != null ? currentLinkSection.getTitle() : currentLinkSection.getLabel();
                List<SimpleLink> linksForSection = this.getLinksForSection(currentPathSegment.getSectionId(), currentLinkSection.getId());
                String linkForSection = null;
                if (linksForSection != null && !linksForSection.isEmpty() && linksForSection.contains(simpleLink)) {
                    found = true;
                }
                currentPathSegmentList.addLast(new PathSegment(currentPathSegment.getSectionId(), currentLinkSection.getId(), name, linkForSection));
                if (found) {
                    return currentPathSegmentList;
                }
                potentiallPathsList.addLast(currentPathSegmentList);
            }
        }
        return null;
    }

    private static final class NavSectionComparator
    implements Comparator<Map<String, Object>> {
        private NavSectionComparator() {
        }

        @Override
        public int compare(Map<String, Object> item1, Map<String, Object> item2) {
            return ((Integer)item1.get("weight")).compareTo((Integer)item2.get("weight"));
        }
    }

    private class PathSegment {
        private final String parentSectionId;
        private final String sectionId;
        private final String name;
        private final String link;

        public PathSegment(String parentSectionId, String sectionId, String name, String link) {
            this.parentSectionId = parentSectionId;
            this.sectionId = sectionId;
            this.name = name;
            this.link = link;
        }

        public String getParentSectionId() {
            return this.parentSectionId;
        }

        public String getSectionId() {
            return this.sectionId;
        }

        public String getName() {
            return this.name;
        }

        public String getLink() {
            return this.link;
        }
    }

    public static class Header {
        private final Map<String, Object> contextMap;
        private final WebPanel panel;

        private Header(WebPanel panel, Map<String, Object> contextMap) {
            this.contextMap = contextMap;
            this.panel = panel;
        }

        public String getHtml() {
            return this.panel.getHtml(this.contextMap);
        }
    }

    public static class Sidebar {
        private final Map<String, Object> contextMap;
        private final WebPanel panel;

        private Sidebar(WebPanel panel, Map<String, Object> contextMap) {
            this.contextMap = contextMap;
            this.panel = panel;
        }

        public String getHtml() {
            return this.panel.getHtml(this.contextMap);
        }
    }
}

