/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormatSymbols;
import java.util.Arrays;
import java.util.Map;

public class DateFormatProvider
implements WebResourceDataProvider {
    private final JiraAuthenticationContext authenticationContext;
    private final ApplicationProperties applicationProperties;

    public DateFormatProvider(JiraAuthenticationContext authenticationContext, ApplicationProperties applicationProperties) {
        this.authenticationContext = authenticationContext;
        this.applicationProperties = applicationProperties;
    }

    public Jsonable get() {
        return new Jsonable(){

            public void write(Writer writer) throws IOException {
                try {
                    DateFormatProvider.this.getAllFormatsAsJson().write(writer);
                }
                catch (JSONException e) {
                    throw new Jsonable.JsonMappingException((Throwable)e);
                }
            }
        };
    }

    private JSONObject getAllFormatsAsJson() {
        DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(this.authenticationContext.getLocale());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"dateFormats", (Object)this.getDateFormatsJson(dateFormatSymbols));
        builder.put((Object)"lookAndFeelFormats", (Object)this.getLookAndFeelFormatsJson());
        return new JSONObject((Map)builder.build());
    }

    private JSONObject getLookAndFeelFormatsJson() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"relativize", (Object)this.applicationProperties.getDefaultBackedString("jira.lf.date.relativize"));
        builder.put((Object)"time", (Object)this.applicationProperties.getDefaultBackedString("jira.lf.date.time"));
        builder.put((Object)"day", (Object)this.applicationProperties.getDefaultBackedString("jira.lf.date.day"));
        builder.put((Object)"dmy", (Object)this.applicationProperties.getDefaultBackedString("jira.lf.date.dmy"));
        builder.put((Object)"complete", (Object)this.applicationProperties.getDefaultBackedString("jira.lf.date.complete"));
        return new JSONObject((Map)builder.build());
    }

    private JSONObject getDateFormatsJson(DateFormatSymbols dateFormatSymbols) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"meridiem", Arrays.asList(dateFormatSymbols.getAmPmStrings()));
        builder.put((Object)"eras", Arrays.asList(dateFormatSymbols.getEras()));
        builder.put((Object)"months", Arrays.asList(dateFormatSymbols.getMonths()).subList(0, 12));
        builder.put((Object)"monthsShort", Arrays.asList(dateFormatSymbols.getShortMonths()).subList(0, 12));
        builder.put((Object)"weekdaysShort", Arrays.asList(dateFormatSymbols.getShortWeekdays()).subList(1, 8));
        builder.put((Object)"weekdays", Arrays.asList(dateFormatSymbols.getWeekdays()).subList(1, 8));
        return new JSONObject((Map)builder.build());
    }
}

