/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.util.TextUtils;
import java.util.Map;
import java.util.stream.Collectors;

public class ProductVersionDataBean {
    private final String metaTags;
    private final String bodyAttributes;
    private final Map<String, String> bodyAttributesMap;

    public ProductVersionDataBean(BuildUtilsInfo buildUtilsInfo) {
        this.metaTags = String.format("<meta name=\"application-name\" content=\"JIRA\" data-name=\"jira\" data-version=\"%s\">", TextUtils.htmlEncode((String)buildUtilsInfo.getVersion()));
        this.bodyAttributesMap = ImmutableMap.of((Object)"data-version", (Object)TextUtils.htmlEncode((String)buildUtilsInfo.getVersion()));
        this.bodyAttributes = this.bodyAttributesMap.entrySet().stream().map(e -> String.format("%s=\"%s\"", e.getKey(), e.getValue())).collect(Collectors.joining(" "));
    }

    @HtmlSafe
    public String getMetaTags() {
        return this.metaTags;
    }

    @HtmlSafe
    public String getBodyHtmlAttributes() {
        return this.bodyAttributes;
    }

    public Map<String, String> getBodyHtmlAttributesMap() {
        return this.bodyAttributesMap;
    }
}

