/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.edit;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.workflow.edit.TransitionData;
import com.atlassian.jira.workflow.edit.Workflow;
import com.atlassian.jira.workflow.edit.WorkflowLoopedTransitions;
import com.atlassian.jira.workflow.edit.Workflows;
import com.atlassian.jira.workflow.edit.utilities.OutcomeHelper;
import org.apache.commons.lang3.StringUtils;

public class WorkflowLoopedTransitionsImpl
implements WorkflowLoopedTransitions {
    private final Workflows workflows;
    private final FieldScreenManager fieldScreenManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final OutcomeHelper outcomeHelper;
    private final WorkflowService workflowService;

    public WorkflowLoopedTransitionsImpl(Workflows workflows, FieldScreenManager fieldScreenManager, JiraAuthenticationContext jiraAuthenticationContext, OutcomeHelper outcomeHelper, WorkflowService workflowService) {
        this.workflows = workflows;
        this.fieldScreenManager = fieldScreenManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.outcomeHelper = outcomeHelper;
        this.workflowService = workflowService;
    }

    @Override
    public ServiceOutcome<TransitionData> createLoopedTransition(String loopedTransitionName, String loopedTransitionDescription, Long screenId, String workflowName) {
        FieldScreen screen;
        ServiceOutcome<Workflow> verificationResult = this.verifyLoopedTransitionCanBeAdded(loopedTransitionName, workflowName, screenId);
        if (!verificationResult.isValid()) {
            return this.outcomeHelper.errorOutcome(verificationResult.getErrorCollection());
        }
        Workflow workflow = (Workflow)verificationResult.getReturnedValue();
        ServiceOutcome<TransitionData> transitionAdded = workflow.addLoopedTransition(loopedTransitionName, loopedTransitionDescription, screen = this.screenIdSet(screenId) ? this.fieldScreenManager.getFieldScreen(screenId) : null);
        if (transitionAdded.isValid()) {
            this.workflows.saveWorkflow(workflow);
        }
        return transitionAdded;
    }

    @Override
    public ServiceOutcome<Workflow> deleteLoopedTransition(int loopedTransitionId, String workflowName) {
        if (!this.workflowService.isWorkflowEditable(this.jiraAuthenticationContext.getLoggedInUser(), this.workflowService.getWorkflow((JiraServiceContext)new JiraServiceContextImpl(this.jiraAuthenticationContext.getLoggedInUser()), workflowName))) {
            return this.outcomeHelper.errorOutcome("workflow.edit.forbidden", new Object[0]);
        }
        ServiceOutcome<Workflow> workflowOutcome = this.workflows.getMutableWorkflow(workflowName);
        if (!workflowOutcome.isValid()) {
            return workflowOutcome;
        }
        Workflow workflow = (Workflow)workflowOutcome.getReturnedValue();
        ServiceOutcome<Workflow> result = workflow.deleteLoopedTransition(loopedTransitionId);
        if (!result.isValid()) {
            return result;
        }
        return this.workflows.saveWorkflow(workflow);
    }

    @Override
    public ServiceOutcome<Workflow> updateLoopedTransition(int transitionId, String name, String description, Long screenId, String workflowName) {
        ServiceOutcome<Workflow> verificationResult = this.verifyLoopedTransitionCanBeUpdated(transitionId, name, workflowName, screenId);
        if (!verificationResult.isValid()) {
            return verificationResult;
        }
        Workflow workflow = (Workflow)verificationResult.getReturnedValue();
        ServiceOutcome<Workflow> updateOutcome = workflow.updateLoopedTransition(transitionId, name, description, this.fieldScreenManager.getFieldScreen(screenId));
        if (!updateOutcome.isValid()) {
            return updateOutcome;
        }
        return this.workflows.saveWorkflow((Workflow)updateOutcome.getReturnedValue());
    }

    @Override
    public ServiceOutcome<Workflow> verifyLoopedTransitionCanBeAdded(String name, String workflowName, Long screenId) {
        FieldScreen fieldScreen;
        if (!this.workflowService.isWorkflowEditable(this.jiraAuthenticationContext.getLoggedInUser(), this.workflowService.getWorkflow((JiraServiceContext)new JiraServiceContextImpl(this.jiraAuthenticationContext.getLoggedInUser()), workflowName))) {
            return this.outcomeHelper.errorOutcome("workflow.edit.forbidden", new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            return this.outcomeHelper.errorOutcome("workflow.edit.enter.a.name", new Object[0]);
        }
        ServiceOutcome<Workflow> workflowOutcome = this.workflows.getMutableWorkflow(workflowName);
        if (!workflowOutcome.isValid()) {
            return this.outcomeHelper.errorOutcome(workflowOutcome.getErrorCollection());
        }
        Workflow workflow = (Workflow)workflowOutcome.getReturnedValue();
        if (workflow.isDuplicateLoopedTransitionName(name)) {
            return this.outcomeHelper.errorOutcome("workflow.edit.transition.name.exists", new Object[0]);
        }
        if (this.screenIdSet(screenId) && (fieldScreen = this.fieldScreenManager.getFieldScreen(screenId)) == null) {
            return this.outcomeHelper.errorOutcome("workflow.edit.transition.screen.not.found", new Object[0]);
        }
        return this.outcomeHelper.okOutcome(workflow);
    }

    @Override
    public ServiceOutcome<Workflow> verifyLoopedTransitionCanBeUpdated(int transitionId, String name, String workflowName, Long screenId) {
        FieldScreen fieldScreen;
        if (!this.workflowService.isWorkflowEditable(this.jiraAuthenticationContext.getLoggedInUser(), this.workflowService.getWorkflow((JiraServiceContext)new JiraServiceContextImpl(this.jiraAuthenticationContext.getLoggedInUser()), workflowName))) {
            return this.outcomeHelper.errorOutcome("workflow.edit.forbidden", new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            return this.outcomeHelper.errorOutcome("workflow.edit.enter.a.name", new Object[0]);
        }
        ServiceOutcome<Workflow> workflowOutcome = this.workflows.getMutableWorkflow(workflowName);
        if (!workflowOutcome.isValid()) {
            return this.outcomeHelper.errorOutcome(workflowOutcome.getErrorCollection());
        }
        Workflow workflow = (Workflow)workflowOutcome.getReturnedValue();
        if (!workflow.hasTransition(transitionId)) {
            return this.outcomeHelper.errorOutcome("workflow.edit.updating.transition.not.found", new Object[0]);
        }
        if (!name.equals(workflow.getTransitionName(transitionId)) && workflow.isDuplicateLoopedTransitionName(name)) {
            return this.outcomeHelper.errorOutcome("workflow.edit.transition.name.exists", new Object[0]);
        }
        if (this.screenIdSet(screenId) && (fieldScreen = this.fieldScreenManager.getFieldScreen(screenId)) == null) {
            return this.outcomeHelper.errorOutcome("workflow.edit.transition.screen.not.found", new Object[0]);
        }
        return this.outcomeHelper.okOutcome(workflow);
    }

    private boolean screenIdSet(Long screenId) {
        return screenId != null && screenId != 0L;
    }
}

