/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.edit;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.jira.workflow.edit.TransitionData;
import com.atlassian.jira.workflow.edit.Workflow;
import com.atlassian.jira.workflow.edit.WorkflowTransitions;
import com.atlassian.jira.workflow.edit.Workflows;
import com.atlassian.jira.workflow.edit.utilities.OutcomeHelper;
import com.opensymphony.workflow.loader.ActionDescriptor;
import org.apache.commons.lang3.StringUtils;

public class WorkflowTransitionsImpl
implements WorkflowTransitions {
    private static final long NO_SCREEN_ID = 0L;
    private final Workflows workflows;
    private final FieldScreenManager fieldScreenManager;
    private final StatusManager statusManager;
    private final GlobalPermissionManager globalPermissionManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final OutcomeHelper outcomeHelper;
    private final WorkflowService workflowService;

    public WorkflowTransitionsImpl(Workflows workflows, FieldScreenManager fieldScreenManager, StatusManager statusManager, GlobalPermissionManager globalPermissionManager, JiraAuthenticationContext jiraAuthenticationContext, OutcomeHelper outcomeHelper, WorkflowService workflowService) {
        this.workflows = workflows;
        this.statusManager = statusManager;
        this.fieldScreenManager = fieldScreenManager;
        this.globalPermissionManager = globalPermissionManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.outcomeHelper = outcomeHelper;
        this.workflowService = workflowService;
    }

    @Override
    public ServiceOutcome<TransitionData> addTransitionToWorkflow(String name, String description, Long screenId, int sourceStepId, int targetStepId, String workflowName) {
        ServiceOutcome<Workflow> verificationResult;
        if (!this.userIsAdministrator(this.jiraAuthenticationContext.getLoggedInUser())) {
            screenId = 0L;
        }
        if (!(verificationResult = this.verifyTransitionCanBeAdded(name, workflowName, sourceStepId, targetStepId, screenId)).isValid()) {
            return this.outcomeHelper.errorOutcome(verificationResult.getErrorCollection());
        }
        Workflow workflow = (Workflow)verificationResult.getReturnedValue();
        ServiceOutcome<TransitionData> transitionAdded = workflow.addTransition(Workflow.AddTransitionParameters.builder().name(name).description(description).screen(this.fieldScreenManager.getFieldScreen(screenId)).sourceStepId(sourceStepId).targetStepId(targetStepId).build());
        if (transitionAdded.isValid()) {
            this.workflows.saveWorkflow(workflow);
        }
        return transitionAdded;
    }

    @Override
    public ServiceOutcome<Workflow> updateTransition(int transitionId, String name, String description, Long screenId, int sourceStepId, String workflowName) {
        ServiceOutcome<Workflow> verificationResult;
        if (!this.userIsAdministrator(this.jiraAuthenticationContext.getLoggedInUser())) {
            ServiceOutcome<Workflow> workflowOutcome = this.workflows.getMutableWorkflow(workflowName);
            if (!workflowOutcome.isValid()) {
                return this.outcomeHelper.errorOutcome(workflowOutcome.getErrorCollection());
            }
            screenId = this.getScreen((Workflow)workflowOutcome.getReturnedValue(), transitionId);
        }
        if (!(verificationResult = this.verifyTransitionCanBeUpdated(transitionId, name, sourceStepId, workflowName, screenId)).isValid()) {
            return verificationResult;
        }
        Workflow workflow = (Workflow)verificationResult.getReturnedValue();
        ServiceOutcome<Workflow> updateOutcome = workflow.updateTransition(transitionId, name, description, this.fieldScreenManager.getFieldScreen(screenId));
        if (!updateOutcome.isValid()) {
            return updateOutcome;
        }
        return this.workflows.saveWorkflow(workflow);
    }

    private Long getScreen(Workflow workflow, int transitionId) {
        ActionDescriptor actionDescriptor = workflow.getJiraWorkflow().getDescriptor().getAction(transitionId);
        String existingScreenId = (String)actionDescriptor.getMetaAttributes().get("jira.fieldscreen.id");
        Long screenId = StringUtils.isEmpty((CharSequence)existingScreenId) ? Long.valueOf(0L) : Long.valueOf(Long.parseLong(existingScreenId));
        return screenId;
    }

    @Override
    public ServiceOutcome<Workflow> deleteTransition(int transitionId, int sourceStepId, String workflowName) {
        if (!this.workflowService.isWorkflowEditable(this.jiraAuthenticationContext.getLoggedInUser(), this.workflowService.getWorkflow((JiraServiceContext)new JiraServiceContextImpl(this.jiraAuthenticationContext.getLoggedInUser()), workflowName))) {
            return this.outcomeHelper.errorOutcome("workflow.edit.forbidden", new Object[0]);
        }
        ServiceOutcome<Workflow> workflowOutcome = this.workflows.getMutableWorkflow(workflowName);
        if (!workflowOutcome.isValid()) {
            return this.outcomeHelper.errorOutcome(workflowOutcome.getErrorCollection());
        }
        Workflow workflow = (Workflow)workflowOutcome.getReturnedValue();
        ServiceOutcome<Workflow> result = workflow.deleteTransition(transitionId, sourceStepId);
        if (!result.isValid()) {
            return this.outcomeHelper.errorOutcome(result.getErrorCollection());
        }
        return this.workflows.saveWorkflow(workflow);
    }

    @Override
    public ServiceOutcome<Workflow> updateTransitionTarget(int transitionId, String targetStatusId, String workflowName) {
        Status status;
        ServiceOutcome<Pair<Workflow, Status>> verificationResult = this.verifyTransitionTargetCanBeUpdated(transitionId, targetStatusId, workflowName);
        if (!verificationResult.isValid()) {
            return this.outcomeHelper.errorOutcome(verificationResult);
        }
        Pair result = (Pair)verificationResult.getReturnedValue();
        Workflow workflow = (Workflow)result.first();
        ServiceOutcome<Workflow> updateOutcome = workflow.updateTransitionTarget(transitionId, status = (Status)result.second());
        if (!updateOutcome.isValid()) {
            return updateOutcome;
        }
        return this.workflows.saveWorkflow(workflow);
    }

    @Override
    public ServiceOutcome<Workflow> updateTransitionSource(int transitionId, String newSourceStatusId, String originalSourceStatusId, String workflowName) {
        ServiceOutcome<TransitionSourceUpdateData> verificationResult = this.verifyTransitionSourceCanBeUpdated(transitionId, newSourceStatusId, originalSourceStatusId, workflowName);
        if (!verificationResult.isValid()) {
            return this.outcomeHelper.errorOutcome(verificationResult);
        }
        TransitionSourceUpdateData result = (TransitionSourceUpdateData)verificationResult.getReturnedValue();
        Workflow workflow = result.getWorkflow();
        Status originalSourceStatus = result.getOriginalSourceStatus();
        Status newSourceStatus = result.getNewSourceStatus();
        ServiceOutcome<Workflow> updateOutcome = workflow.updateTransitionSource(transitionId, newSourceStatus, originalSourceStatus);
        if (!updateOutcome.isValid()) {
            return updateOutcome;
        }
        return this.workflows.saveWorkflow(workflow);
    }

    @Override
    public ServiceOutcome<Workflow> addCommonTransition(String sourceStatusId, int transitionId, String workflowName) {
        ServiceOutcome<Workflow> verificationResult = this.verifyCommonTransitionCanBeUsed(transitionId, sourceStatusId, workflowName);
        if (!verificationResult.isValid()) {
            return verificationResult;
        }
        Workflow workflow = (Workflow)verificationResult.getReturnedValue();
        ServiceOutcome<Workflow> commonTransitionAdded = workflow.addCommonTransition(sourceStatusId, transitionId);
        if (!commonTransitionAdded.isValid()) {
            return commonTransitionAdded;
        }
        return this.workflows.saveWorkflow(workflow);
    }

    private ServiceOutcome<Workflow> verifyCommonTransitionCanBeUsed(int commonTransitionId, String sourceStatusId, String workflowName) {
        if (!this.workflowService.isWorkflowEditable(this.jiraAuthenticationContext.getLoggedInUser(), this.workflowService.getWorkflow((JiraServiceContext)new JiraServiceContextImpl(this.jiraAuthenticationContext.getLoggedInUser()), workflowName))) {
            return this.outcomeHelper.errorOutcome("workflow.edit.forbidden", new Object[0]);
        }
        ServiceOutcome<Workflow> workflowOutcome = this.workflows.getMutableWorkflow(workflowName);
        if (!workflowOutcome.isValid()) {
            return this.outcomeHelper.errorOutcome(workflowOutcome.getErrorCollection());
        }
        Workflow workflow = (Workflow)workflowOutcome.getReturnedValue();
        Status status = this.statusManager.getStatus(sourceStatusId);
        if (status == null || !workflow.stepExists(status)) {
            return this.outcomeHelper.errorOutcome("workflow.edit.selected.source.status.not.found", new Object[0]);
        }
        if (!workflow.hasTransition(commonTransitionId)) {
            return this.outcomeHelper.errorOutcome("workflow.edit.common.transition.not.found", new Object[0]);
        }
        ServiceOutcome<Boolean> statusHasOutgoingTransitionOutcome = workflow.statusHasOutgoingTransition(status, commonTransitionId);
        if (!statusHasOutgoingTransitionOutcome.isValid()) {
            return this.outcomeHelper.errorOutcome(statusHasOutgoingTransitionOutcome.getErrorCollection());
        }
        if (((Boolean)statusHasOutgoingTransitionOutcome.getReturnedValue()).booleanValue()) {
            return this.outcomeHelper.errorOutcome("workflow.edit.duplicate.common.transition", new Object[0]);
        }
        return this.outcomeHelper.okOutcome(workflow);
    }

    private ServiceOutcome<Workflow> verifyTransitionCanBeAdded(String name, String workflowName, int sourceStepId, int targetStepId, Long screenId) {
        FieldScreen fieldScreen;
        if (!this.workflowService.isWorkflowEditable(this.jiraAuthenticationContext.getLoggedInUser(), this.workflowService.getWorkflow((JiraServiceContext)new JiraServiceContextImpl(this.jiraAuthenticationContext.getLoggedInUser()), workflowName))) {
            return this.outcomeHelper.errorOutcome("workflow.edit.forbidden", new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            return this.outcomeHelper.errorOutcome("workflow.edit.enter.a.name", new Object[0]);
        }
        ServiceOutcome<Workflow> workflowOutcome = this.workflows.getMutableWorkflow(workflowName);
        if (!workflowOutcome.isValid()) {
            return this.outcomeHelper.errorOutcome(workflowOutcome.getErrorCollection());
        }
        Workflow workflow = (Workflow)workflowOutcome.getReturnedValue();
        if (!workflow.stepExists(sourceStepId)) {
            return this.outcomeHelper.errorOutcome("workflow.edit.selected.source.status.not.found", new Object[0]);
        }
        if (!workflow.stepExists(targetStepId)) {
            return this.outcomeHelper.errorOutcome("workflow.edit.selected.target.status.not.found", new Object[0]);
        }
        if (this.screenIdSet(screenId) && (fieldScreen = this.fieldScreenManager.getFieldScreen(screenId)) == null) {
            return this.outcomeHelper.errorOutcome("workflow.edit.transition.screen.not.found", new Object[0]);
        }
        return this.outcomeHelper.okOutcome(workflow);
    }

    private ServiceOutcome<Workflow> verifyTransitionCanBeUpdated(int transitionId, String name, int sourceStepId, String workflowName, Long screenId) {
        FieldScreen fieldScreen;
        if (!this.workflowService.isWorkflowEditable(this.jiraAuthenticationContext.getLoggedInUser(), this.workflowService.getWorkflow((JiraServiceContext)new JiraServiceContextImpl(this.jiraAuthenticationContext.getLoggedInUser()), workflowName))) {
            return this.outcomeHelper.errorOutcome("workflow.edit.forbidden", new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            return this.outcomeHelper.errorOutcome("workflow.edit.enter.a.name", new Object[0]);
        }
        ServiceOutcome<Workflow> workflowOutcome = this.workflows.getMutableWorkflow(workflowName);
        if (!workflowOutcome.isValid()) {
            return this.outcomeHelper.errorOutcome(workflowOutcome.getErrorCollection());
        }
        Workflow workflow = (Workflow)workflowOutcome.getReturnedValue();
        if (!workflow.hasTransition(transitionId)) {
            return this.outcomeHelper.errorOutcome("workflow.edit.updating.transition.not.found", new Object[0]);
        }
        if (!name.equals(workflow.getTransitionName(transitionId)) && workflow.isDuplicateTransitionName(name, sourceStepId)) {
            return this.outcomeHelper.errorOutcome("workflow.edit.transition.name.exists", new Object[0]);
        }
        if (this.screenIdSet(screenId) && (fieldScreen = this.fieldScreenManager.getFieldScreen(screenId)) == null) {
            return this.outcomeHelper.errorOutcome("workflow.edit.transition.screen.not.found", new Object[0]);
        }
        return this.outcomeHelper.okOutcome(workflow);
    }

    private ServiceOutcome<Pair<Workflow, Status>> verifyTransitionTargetCanBeUpdated(int transitionId, String targetStatusId, String workflowName) {
        if (!this.workflowService.isWorkflowEditable(this.jiraAuthenticationContext.getLoggedInUser(), this.workflowService.getWorkflow((JiraServiceContext)new JiraServiceContextImpl(this.jiraAuthenticationContext.getLoggedInUser()), workflowName))) {
            return this.outcomeHelper.errorOutcome("workflow.edit.forbidden", new Object[0]);
        }
        ServiceOutcome<Workflow> workflowOutcome = this.workflows.getMutableWorkflow(workflowName);
        if (!workflowOutcome.isValid()) {
            return this.outcomeHelper.errorOutcome(workflowOutcome);
        }
        Workflow workflow = (Workflow)workflowOutcome.getReturnedValue();
        if (!workflow.hasTransition(transitionId)) {
            return this.outcomeHelper.errorOutcome("workflow.edit.updating.transition.not.found", new Object[0]);
        }
        Status status = this.statusManager.getStatus(targetStatusId);
        if (status == null || !workflow.stepExists(status)) {
            return this.outcomeHelper.errorOutcome("workflow.edit.selected.target.status.not.found", new Object[0]);
        }
        return this.outcomeHelper.okOutcome(Pair.of((Object)workflow, (Object)status));
    }

    private ServiceOutcome<TransitionSourceUpdateData> verifyTransitionSourceCanBeUpdated(int transitionId, String newSourceStatusId, String originalSourceStatusId, String workflowName) {
        if (!this.workflowService.isWorkflowEditable(this.jiraAuthenticationContext.getLoggedInUser(), this.workflowService.getWorkflow((JiraServiceContext)new JiraServiceContextImpl(this.jiraAuthenticationContext.getLoggedInUser()), workflowName))) {
            return this.outcomeHelper.errorOutcome("workflow.edit.forbidden", new Object[0]);
        }
        ServiceOutcome<Workflow> workflowOutcome = this.workflows.getMutableWorkflow(workflowName);
        if (!workflowOutcome.isValid()) {
            return this.outcomeHelper.errorOutcome(workflowOutcome);
        }
        Workflow workflow = (Workflow)workflowOutcome.getReturnedValue();
        if (!workflow.hasTransition(transitionId)) {
            return this.outcomeHelper.errorOutcome("workflow.edit.updating.transition.not.found", new Object[0]);
        }
        Status originalSourceStatus = this.statusManager.getStatus(originalSourceStatusId);
        if (originalSourceStatus == null || !workflow.stepExists(originalSourceStatus)) {
            return this.outcomeHelper.errorOutcome("workflow.edit.selected.source.status.not.found", new Object[0]);
        }
        Status newSourceStatus = this.statusManager.getStatus(newSourceStatusId);
        if (newSourceStatus == null || !workflow.stepExists(newSourceStatus)) {
            return this.outcomeHelper.errorOutcome("workflow.edit.selected.new.source.status.not.found", new Object[0]);
        }
        if (workflow.commonTransitionExistsFromSource(transitionId, newSourceStatus)) {
            return this.outcomeHelper.errorOutcome("workflow.edit.common.transition.exists", new Object[0]);
        }
        return this.outcomeHelper.okOutcome(new TransitionSourceUpdateData(workflow, newSourceStatus, originalSourceStatus));
    }

    private boolean screenIdSet(Long screenId) {
        return screenId != null && screenId != 0L;
    }

    private boolean userIsAdministrator(ApplicationUser user) {
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
    }

    private static class TransitionSourceUpdateData {
        private Workflow workflow;
        private Status originalSourceStatus;
        private Status newSourceStatus;

        public TransitionSourceUpdateData(Workflow workflow, Status newSourceStatus, Status originalSourceStatus) {
            this.workflow = workflow;
            this.newSourceStatus = newSourceStatus;
            this.originalSourceStatus = originalSourceStatus;
        }

        private Status getNewSourceStatus() {
            return this.newSourceStatus;
        }

        private Status getOriginalSourceStatus() {
            return this.originalSourceStatus;
        }

        private Workflow getWorkflow() {
            return this.workflow;
        }
    }
}

