/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mail.auth;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.mail.auth.JiraMailOAuth2Credentials;
import com.atlassian.mail.auth.JiraOAuth2TokenUnrecoverableEvent;
import com.atlassian.mail.server.auth.AuthenticationContext;
import com.atlassian.mail.server.auth.Credentials;
import com.atlassian.oauth2.client.api.ClientToken;
import com.atlassian.oauth2.client.api.ClientTokenMetadata;
import com.atlassian.oauth2.client.api.storage.TokenHandler;
import com.atlassian.oauth2.client.api.storage.token.ClientTokenEntity;
import com.atlassian.oauth2.client.api.storage.token.ClientTokenStorageService;
import com.atlassian.oauth2.client.api.storage.token.exception.RecoverableTokenException;
import com.atlassian.oauth2.client.api.storage.token.exception.UnrecoverableTokenException;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.mail.AuthenticationFailedException;
import javax.mail.MessagingException;
import javax.mail.Service;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JiraOauth2AuthenticationContext
implements AuthenticationContext {
    static final Map<String, String> XOAUTH2_CONFIG = ImmutableMap.of((Object)"mail.imap.ssl.enable", (Object)"true", (Object)"mail.pop3s.ssl.enable", (Object)"true", (Object)"mail.imaps.auth.mechanisms", (Object)"XOAUTH2", (Object)"mail.pop3s.auth.mechanisms", (Object)"XOAUTH2");
    private final JiraMailOAuth2Credentials credentials;
    private final EventPublisher eventPublisher;
    private static final Logger log = LoggerFactory.getLogger(JiraOauth2AuthenticationContext.class);

    JiraOauth2AuthenticationContext(JiraMailOAuth2Credentials credentials) {
        if (credentials == null) {
            throw new IllegalArgumentException("Can not be instantiated for null credentials");
        }
        this.credentials = credentials;
        this.eventPublisher = (EventPublisher)ComponentAccessor.getComponent(EventPublisher.class);
    }

    @NotNull
    public Credentials getCredentials() {
        return this.credentials;
    }

    public boolean isAuthenticating() {
        return this.credentials.getUserName() != null;
    }

    public Properties preparePropertiesForSession(Properties properties) {
        Properties sessionProperties = new Properties();
        sessionProperties.putAll((Map<?, ?>)properties);
        sessionProperties.putAll((Map<?, ?>)this.credentials.getProperties().orElseGet(Properties::new));
        XOAUTH2_CONFIG.forEach(sessionProperties::setProperty);
        return sessionProperties;
    }

    public void connectService(Service service) throws MessagingException {
        log.debug("Connecting to service {} using XOAUTH2.", (Object)service.getURLName());
        try {
            this.connectUsingToken(service, this.credentials.getUserName(), this.credentials.getAccessToken());
        }
        catch (AuthenticationFailedException ex) {
            log.debug("XOAUTH2 authentication to service {} failed. Trying to recover.", (Object)service.getURLName());
            this.recoverOrRethrow(service, ex);
        }
    }

    private void recoverOrRethrow(Service service, AuthenticationFailedException cause) throws MessagingException {
        String tokenId = this.credentials.getTokenId();
        if (this.isTokenRecoverable(tokenId)) {
            Optional<String> accessTokenOpt = this.refreshAccessToken(tokenId);
            if (accessTokenOpt.isPresent()) {
                this.connectUsingToken(service, this.credentials.getUserName(), accessTokenOpt.get());
                return;
            }
            log.debug("Won't connect to service {}. Token recovery failed.", (Object)service.getURLName());
        } else {
            log.debug("Won't connect to service {}. Invalid XOAUTH2 token.", (Object)service.getURLName());
            this.publishUnrecoverableTokenEvent(tokenId);
        }
        throw cause;
    }

    private void connectUsingToken(Service service, String userName, String accessToken) throws MessagingException {
        service.connect(userName, accessToken);
        log.debug("Successful XOAUTH2 authentication to service {}.", (Object)service.getURLName());
    }

    private Optional<String> refreshAccessToken(String tokenId) {
        try {
            TokenHandler tokenHandler = (TokenHandler)ComponentAccessor.getOSGiComponentInstanceOfType(TokenHandler.class);
            ClientToken clientToken = tokenHandler.getRefreshedToken(tokenId);
            return Optional.ofNullable(clientToken).map(ClientToken::getAccessToken);
        }
        catch (UnrecoverableTokenException ex) {
            this.publishUnrecoverableTokenEvent(tokenId);
            log.debug("Access token can not be refreshed.", (Throwable)ex);
            return Optional.empty();
        }
        catch (RecoverableTokenException ex) {
            log.debug("Access token can not be refreshed.", (Throwable)ex);
            return Optional.empty();
        }
    }

    private boolean isTokenRecoverable(String tokenId) {
        ClientTokenStorageService tokenService = (ClientTokenStorageService)ComponentAccessor.getOSGiComponentInstanceOfType(ClientTokenStorageService.class);
        Optional tokenEntityOpt = tokenService.getById(tokenId);
        return tokenEntityOpt.isPresent() && !ClientTokenMetadata.ClientTokenStatus.UNRECOVERABLE.equals((Object)((ClientTokenEntity)tokenEntityOpt.get()).getStatus());
    }

    private void publishUnrecoverableTokenEvent(String tokenId) {
        this.eventPublisher.publish((Object)new JiraOAuth2TokenUnrecoverableEvent(tokenId));
    }
}

