/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.velocity;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.template.velocity.VelocityEngineFactory;
import com.atlassian.jira.util.collect.CompositeMap;
import com.atlassian.velocity.DefaultVelocityManager;
import com.atlassian.velocity.DelegateDateFormat;
import io.atlassian.util.concurrent.LazyReference;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraVelocityManager
extends DefaultVelocityManager {
    private static final Logger log = LoggerFactory.getLogger(JiraVelocityManager.class);
    private final DateTimeFormatter dateTimeFormatter;
    private final VelocityEngineFactory velocityEngineFactory;

    public JiraVelocityManager(DateTimeFormatter dateTimeFormatter) {
        this.dateTimeFormatter = dateTimeFormatter != null ? dateTimeFormatter.forLoggedInUser().withStyle(DateTimeStyle.COMPLETE) : null;
        this.velocityEngineFactory = (VelocityEngineFactory)ComponentAccessor.getComponent(VelocityEngineFactory.class);
    }

    public JiraVelocityManager(DateTimeFormatter dateTimeFormatter, VelocityEngineFactory velocityEngineFactory) {
        this.velocityEngineFactory = velocityEngineFactory;
        this.dateTimeFormatter = dateTimeFormatter != null ? dateTimeFormatter.forLoggedInUser().withStyle(DateTimeStyle.COMPLETE) : null;
    }

    public DateFormat getDateFormat() {
        return new DelegateDateFormat((Supplier<DateFormat>)((Object)new DateFormatSupplier()));
    }

    public boolean isTemplateAvailable(String templateDirectory, String templateName, String encoding) {
        String templatePath = templateDirectory + templateName;
        try {
            return this.getVe().getTemplate(templatePath, encoding) != null;
        }
        catch (Exception e) {
            log.error("Template {} is not accessible.", (Object)templatePath, (Object)e);
            return false;
        }
    }

    protected VelocityContext createVelocityContext(Map params) {
        return super.createVelocityContext(CompositeMap.of(new HashMap(), (Map)params));
    }

    protected Map<String, ?> createContextParams(String baseurl, Map contextParameters) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("baseurl", baseurl);
        result.put("formatter", this.getDateFormat());
        return CompositeMap.of((Map)contextParameters, result);
    }

    protected VelocityEngine getVe() {
        return this.velocityEngineFactory.getEngine();
    }

    class DateFormatSupplier
    extends LazyReference<DateFormat> {
        DateFormatSupplier() {
        }

        protected DateFormat create() {
            return new SimpleDateFormat(JiraVelocityManager.this.dateTimeFormatter.getFormatHint());
        }
    }

    static final class Key {
        static final String BASE_URL = "baseurl";
        static final String FORMATTER = "formatter";

        Key() {
        }
    }
}

