/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import com.atlassian.jira.cluster.distribution.localq.rmi.auth.ClusterAuthRMIClientSocketFactoryHelper;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMISocketFactory;
import net.sf.ehcache.distribution.UnmodifiableSoTimeoutSocket;

public final class ConfigurableRMIClientSocketFactory
implements Serializable,
RMIClientSocketFactory {
    private static final boolean IS_HTTP_PROXY_CONFIGURED = ConfigurableRMIClientSocketFactory.isHttpProxyConfigured();
    private static final boolean RMI_CONNECT_TIMEOUTS_DISABLED = JiraSystemProperties.getInstance().getProperty("ehcache.rmiConnectTimeoutsDisabled", "false").equalsIgnoreCase("true");
    private static final int ONE_SECOND = 1000;
    private static final long serialVersionUID = 4920508630517373246L;
    private final int socketTimeoutMillis;

    public ConfigurableRMIClientSocketFactory(Integer socketTimeoutMillis) {
        this.socketTimeoutMillis = socketTimeoutMillis == null ? 1000 : socketTimeoutMillis;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return ClusterAuthRMIClientSocketFactoryHelper.createSocket(this::createSocketOrig, host, port);
    }

    private Socket createSocketOrig(String host, int port) throws IOException {
        if (RMI_CONNECT_TIMEOUTS_DISABLED) {
            Socket socket = ConfigurableRMIClientSocketFactory.getConfiguredRMISocketFactory().createSocket(host, port);
            socket.setSoTimeout(this.socketTimeoutMillis);
            return socket;
        }
        Socket socket = ConfigurableRMIClientSocketFactory.isCustomRMISocketFactoryConfigured() || IS_HTTP_PROXY_CONFIGURED ? ConfigurableRMIClientSocketFactory.getConfiguredRMISocketFactory().createSocket(host, port) : this.createSocketWithTimeout(host, port);
        socket.setSoTimeout(this.socketTimeoutMillis);
        return new UnmodifiableSoTimeoutSocket(socket);
    }

    private Socket createSocketWithTimeout(String host, int port) throws IOException {
        Socket socket = new Socket();
        socket.connect(new InetSocketAddress(host, port), this.socketTimeoutMillis);
        return socket;
    }

    public int hashCode() {
        return this.socketTimeoutMillis;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return this.getClass() == object.getClass() && this.socketTimeoutMillis == ((ConfigurableRMIClientSocketFactory)object).socketTimeoutMillis;
    }

    public static RMISocketFactory getConfiguredRMISocketFactory() {
        RMISocketFactory globalSocketFactory = RMISocketFactory.getSocketFactory();
        if (globalSocketFactory == null) {
            return RMISocketFactory.getDefaultSocketFactory();
        }
        return globalSocketFactory;
    }

    private static boolean isCustomRMISocketFactoryConfigured() {
        RMISocketFactory globalSocketFactory = RMISocketFactory.getSocketFactory();
        return globalSocketFactory != null;
    }

    private static boolean isHttpProxyConfigured() {
        String disableHttpString;
        Boolean disableHttp;
        String proxyHost = JiraSystemProperties.getInstance().getProperty("http.proxyHost");
        if (proxyHost == null) {
            proxyHost = JiraSystemProperties.getInstance().getProperty("proxyHost");
        }
        return (disableHttp = Boolean.valueOf((disableHttpString = JiraSystemProperties.getInstance().getProperty("java.rmi.server.disableHttp", "true")).equalsIgnoreCase("true"))) == false && proxyHost != null && proxyHost.length() > 0;
    }
}

