/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config;

import org.apache.commons.lang3.StringUtils;

public final class CheckMessage {
    private final String message;
    private final String checkId;

    public CheckMessage(String message, String checkId) {
        String s = StringUtils.trimToNull((String)message);
        this.message = s != null ? s : "<unknown>";
        this.checkId = StringUtils.trimToNull((String)checkId);
    }

    public CheckMessage(String message) {
        this(message, null);
    }

    public String getMessage() {
        return this.message;
    }

    public String getFormattedMessage() {
        if (this.checkId != null) {
            return String.format("[%s] - %s", this.checkId, this.message);
        }
        return this.message;
    }

    public String getCheckId() {
        return this.checkId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckMessage that = (CheckMessage)o;
        if (this.checkId != null ? !this.checkId.equals(that.checkId) : that.checkId != null) {
            return false;
        }
        return !(this.message != null ? !this.message.equals(that.message) : that.message != null);
    }

    public int hashCode() {
        int result = this.message != null ? this.message.hashCode() : 0;
        result = 31 * result + (this.checkId != null ? this.checkId.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.getFormattedMessage();
    }
}

