/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config;

import com.atlassian.jira.functest.config.ConfigException;
import com.atlassian.jira.functest.config.ConfigObjectWithId;
import com.atlassian.jira.functest.config.ConfigSequence;
import com.atlassian.jira.functest.config.ConfigXmlUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public abstract class ConfigCrudHelper<T extends ConfigObjectWithId> {
    private final Document document;
    private final ConfigSequence configSeqence;
    private final String elementName;

    public ConfigCrudHelper(Document document, ConfigSequence configSeqence, String elementName) {
        this.document = document;
        this.configSeqence = configSeqence;
        this.elementName = elementName;
    }

    public List<T> load() {
        List<Element> configNodes = ConfigXmlUtils.getTopElementsByName(this.document, this.elementName);
        ArrayList<T> returnList = new ArrayList<T>(configNodes.size());
        for (Element element : configNodes) {
            T t = this.elementToObject(element);
            if (t.getId() == null) {
                throw new ConfigException("Trying to read config object with no ID.");
            }
            returnList.add(t);
        }
        return returnList;
    }

    public boolean save(List<T> newList) {
        List<T> oldList = this.load();
        HashMap<Long, ConfigObjectWithId> oldMap = new HashMap<Long, ConfigObjectWithId>();
        for (ConfigObjectWithId old : oldList) {
            oldMap.put(old.getId(), old);
        }
        boolean returnValue = false;
        for (ConfigObjectWithId newObject : newList) {
            ConfigObjectWithId oldObject = (ConfigObjectWithId)oldMap.get(newObject.getId());
            if (oldObject == null) {
                Long newId = this.configSeqence.getNextId(this.elementName);
                Element element = ConfigXmlUtils.createNewElement(this.document.getRootElement(), this.elementName);
                this.newObject(element, newObject, newId);
                returnValue = true;
                continue;
            }
            if (!newObject.equals(oldObject)) {
                Element element = this.findObjectElement(oldObject);
                this.updateObject(element, newObject, oldObject);
                returnValue = true;
            }
            oldMap.remove(newObject.getId());
        }
        for (ConfigObjectWithId deleteObject : oldMap.values()) {
            Element element = this.findObjectElement(deleteObject);
            this.deleteObject(element, deleteObject);
            ConfigXmlUtils.removeElement(element);
            returnValue = true;
        }
        return returnValue;
    }

    protected abstract T elementToObject(Element var1);

    protected abstract void updateObject(Element var1, T var2, T var3);

    protected abstract void newObject(Element var1, T var2, Long var3);

    protected abstract void deleteObject(Element var1, T var2);

    private Element findObjectElement(T object) {
        Element element = ConfigXmlUtils.getElementByXpath(this.document, String.format("/*/%s[@id='%d']", this.elementName, object.getId()));
        if (element == null) {
            throw new ConfigException("Could not find element for object with id '" + object.getId() + "'");
        }
        return element;
    }
}

