/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config;

import com.atlassian.jira.functest.config.AttachmentDirectoryChecker;
import com.atlassian.jira.functest.config.BackupChecker;
import com.atlassian.jira.functest.config.ConfigurationCheck;
import com.atlassian.jira.functest.config.IndexDirectoryChecker;
import com.atlassian.jira.functest.config.ServiceChecker;
import com.atlassian.jira.functest.config.crowd.CrowdApplicationCheck;
import com.atlassian.jira.functest.config.crowd.PlaintextEncoderChecker;
import com.atlassian.jira.functest.config.dashboard.DashboardConfigurationCheck;
import com.atlassian.jira.functest.config.mail.MailChecker;
import com.atlassian.jira.webtests.util.LocalTestEnvironmentData;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.DelegateFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;

public final class ConfigurationDefaults {
    private ConfigurationDefaults() {
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Why are you calling me? I'm static.");
    }

    public static File getDefaultXmlDataLocation() {
        LocalTestEnvironmentData environmentData = LocalTestEnvironmentData.DEFAULT;
        File xmlDataLocation = environmentData.getXMLDataLocation();
        if (xmlDataLocation == null) {
            throw new RuntimeException("Func Test XML directory has not been configured.");
        }
        if (!xmlDataLocation.exists()) {
            throw new RuntimeException(String.format("Func Test XML directory '%s' does not exist.", xmlDataLocation));
        }
        return xmlDataLocation;
    }

    public static List<IOFileFilter> getDefaultExcludedFilters() {
        ArrayList<IOFileFilter> files = new ArrayList<IOFileFilter>();
        files.add(ConfigurationDefaults.createNameFilter("TestXmlIssueView-HSP-1-no-issue-links-v813.xml"));
        files.add(ConfigurationDefaults.createNameFilter("TestXmlIssueView-HSP-1-no-timetracking-v813.xml"));
        files.add(ConfigurationDefaults.createNameFilter("TestXmlIssueView-HSP-1-due-date-hidden-v813.xml"));
        files.add(ConfigurationDefaults.createNameFilter("TestXmlIssueView-HSP-1-v813.xml"));
        files.add(ConfigurationDefaults.createNameFilter("TestXmlIssueView-HSP-1-no-subtasks-v813.xml"));
        files.add(ConfigurationDefaults.createNameFilter("TestXmlIssueView-HSP-1-no-custom-fields-v813.xml"));
        files.add(ConfigurationDefaults.createNameFilter("check-cache.xml"));
        files.add(ConfigurationDefaults.createNameFilter("fixerBroken.zip"));
        files.add(ConfigurationDefaults.createParentFilter("TestDownloadZipAttachmentEntries/attachments"));
        files.add(ConfigurationDefaults.createParentFilter("TestZipAttachmentSecurity/attachments"));
        files.add(ConfigurationDefaults.createParentFilter("TestAttachmentsBlockSortingOnViewIssue/attachments"));
        files.add(ConfigurationDefaults.createParentFilter("TestBrowseZipAttachmentEntries/attachments"));
        files.add(ConfigurationDefaults.createNameFilter("TestEmptyStringDataRestore_out.xml"));
        return files;
    }

    public static List<ConfigurationCheck> createDefaultConfigurationChecks() {
        return ImmutableList.of((Object)new AttachmentDirectoryChecker(), (Object)new IndexDirectoryChecker(), (Object)new BackupChecker(), (Object)new MailChecker(), (Object)new DashboardConfigurationCheck(), (Object)new ServiceChecker(), (Object)new CrowdApplicationCheck(), (Object)new PlaintextEncoderChecker());
    }

    public static List<String> getListOfDefaultConfigurationChecksSuppressKeys() {
        return ImmutableList.builder().add((Object)"attachdirectory").add((Object)"attachhome").add((Object)"indexdirectory").add((Object)"indexenabled").add((Object)"indexhome").add((Object)"backupservice").add((Object)"backupservicedirectory").add((Object)"backupservicehome").add((Object)"backupglobaldirectory").add((Object)"mailserver").add((Object)"mailservice").add((Object)"absolutegadgets").add((Object)"dashboards").add((Object)"externalgadgets").add((Object)"gadgets").add((Object)"service").add((Object)"crowdapplicationtype").add((Object)"plaintextencoder").build();
    }

    private static IOFileFilter createNameFilter(String name) {
        return new NameFileFilter(name, IOCase.INSENSITIVE);
    }

    private static IOFileFilter createParentFilter(String name) {
        String s = Pattern.quote(FilenameUtils.separatorsToSystem((String)name));
        return new DelegateFileFilter((FileFilter)new RegexPathFilter(s));
    }

    private static class RegexPathFilter
    implements FileFilter {
        private final Pattern patten;

        public RegexPathFilter(String patten) {
            this.patten = Pattern.compile(patten, 2);
        }

        @Override
        public boolean accept(File pathname) {
            return this.patten.matcher(pathname.getPath()).find();
        }
    }
}

