/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config;

import com.atlassian.jira.functest.config.CheckOptions;
import com.atlassian.jira.functest.config.CheckResultBuilder;
import com.atlassian.jira.functest.config.ConfigurationCheck;
import com.atlassian.jira.functest.config.JiraConfig;
import com.atlassian.jira.functest.config.ps.ConfigPropertySet;

public class IndexDirectoryChecker
implements ConfigurationCheck {
    public static final String CHECKID_INDEX_HOME = "indexhome";
    public static final String CHECKID_INDEX_ENABLED = "indexenabled";
    public static final String CHECKID_INDEX_DIRECTORY = "indexdirectory";
    private static final String PROP_INDEX_OPTION = "jira.option.indexing";
    private static final String PROP_INDEX_PATH = "jira.path.index";
    private static final String PROP_INDEX_DEFAULT_DIR = "jira.path.index.use.default.directory";
    private static final String FUNC_TEST_INDEX = "func_test_index";

    @Override
    public ConfigurationCheck.Result checkConfiguration(JiraConfig config, CheckOptions options) {
        CheckResultBuilder builder = new CheckResultBuilder();
        try {
            this.processConfig(config, options, builder);
        }
        catch (Exception e) {
            return builder.error(e.getMessage()).buildResult();
        }
        return builder.buildResult();
    }

    private void processConfig(JiraConfig config, CheckOptions options, CheckResultBuilder builder) {
        String directory;
        ConfigPropertySet propertySet = config.getApplicationProperties();
        if (options.checkEnabled(CHECKID_INDEX_ENABLED) && !propertySet.getBooleanPropertyDefault(PROP_INDEX_OPTION, false).booleanValue()) {
            builder.warning("File does not have indexing enabled.", CHECKID_INDEX_ENABLED);
        }
        if (options.checkEnabled(CHECKID_INDEX_HOME) && !propertySet.getBooleanPropertyDefault(PROP_INDEX_DEFAULT_DIR, false).booleanValue()) {
            directory = propertySet.getStringPropertyDefault(PROP_INDEX_PATH, "<nothing>");
            builder.error("File has '" + directory + "' configured as its index path. It should be using its JIRA.HOME.", CHECKID_INDEX_HOME);
        }
        if (options.checkEnabled(CHECKID_INDEX_DIRECTORY) && propertySet.contains(PROP_INDEX_PATH) && !FUNC_TEST_INDEX.equals(directory = propertySet.getStringPropertyDefault(PROP_INDEX_PATH, "<nothing>"))) {
            builder.warning("File has '" + directory + "' configured as its index path. It should be using '" + FUNC_TEST_INDEX + "' even with JIRA.HOME configured.", CHECKID_INDEX_DIRECTORY);
        }
    }

    @Override
    public void fixConfiguration(JiraConfig config, CheckOptions options) {
        String index;
        ConfigPropertySet propertySet = config.getApplicationProperties();
        if (options.checkEnabled(CHECKID_INDEX_ENABLED)) {
            propertySet.setBooleanProperty(PROP_INDEX_OPTION, true);
        }
        if (options.checkEnabled(CHECKID_INDEX_HOME)) {
            propertySet.setBooleanProperty(PROP_INDEX_DEFAULT_DIR, true);
        }
        if (options.checkEnabled(CHECKID_INDEX_DIRECTORY) && (index = propertySet.getStringProperty(PROP_INDEX_PATH)) != null) {
            propertySet.setStringProperty(PROP_INDEX_PATH, FUNC_TEST_INDEX);
        }
    }
}

