/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config;

import com.atlassian.jira.functest.config.CheckOptions;
import com.atlassian.jira.functest.config.CheckResultBuilder;
import com.atlassian.jira.functest.config.ConfigurationCheck;
import com.atlassian.jira.functest.config.JiraConfig;
import com.atlassian.jira.functest.config.mail.MailChecker;
import com.atlassian.jira.functest.config.service.ConfigService;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;

public class ServiceChecker
implements ConfigurationCheck {
    public static final String CHECK_SERVICE = "service";
    private static final List<String> IGNORED_SERVICES = ImmutableList.builder().addAll(MailChecker.SERVICES).add((Object)"ExportService").add((Object)"MailQueueService").add((Object)"JiraPluginSchedulerService").build();

    @Override
    public ConfigurationCheck.Result checkConfiguration(JiraConfig config, CheckOptions options) {
        CheckResultBuilder builder = new CheckResultBuilder();
        if (options.checkEnabled(CHECK_SERVICE)) {
            List<ConfigService> services = config.getServices();
            for (ConfigService service : services) {
                if (this.isIgnored(service)) continue;
                String name = service.getName() != null ? service.getName() : "<unknown>";
                builder.error("Service '" + name + "' exits.", CHECK_SERVICE);
            }
        }
        return builder.buildResult();
    }

    @Override
    public void fixConfiguration(JiraConfig config, CheckOptions options) {
        List<ConfigService> services = config.getServices();
        Iterator<ConfigService> iterator = services.iterator();
        while (iterator.hasNext()) {
            ConfigService service = iterator.next();
            if (this.isIgnored(service) || !options.checkEnabled(CHECK_SERVICE)) continue;
            iterator.remove();
        }
    }

    private boolean isIgnored(ConfigService service) {
        for (String ignoredService : IGNORED_SERVICES) {
            if (!service.getClazz().contains(ignoredService)) continue;
            return true;
        }
        return false;
    }
}

