/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config.dashboard;

import com.atlassian.jira.functest.config.ConfigXmlUtils;
import com.atlassian.jira.functest.config.dashboard.ConfigGadget;
import com.atlassian.jira.functest.config.sharing.ConfigSharedEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.dom4j.Element;

public class ConfigDashboard
implements ConfigSharedEntity {
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_USERNAME = "username";
    private static final String ATTRIBUTE_PAGENAME = "pagename";
    private static final String ATTRIBUTE_DESCRIPTION = "description";
    private static final String ATTRIBUTE_SEQUENCE = "sequence";
    private static final String ATTRIBUTE_LAYOUT = "layout";
    private static final String ATTRIBUTE_VERSION = "version";
    private static final String ATTRIBUTE_FAV_COUNT = "favCount";
    private static final String ENTITY_TYPE = "PortalPage";
    private Long id;
    private Long sequence;
    private String owner;
    private String name;
    private String description;
    private Long favouriteCount;
    private Long version;
    private String layout;
    private List<ConfigGadget> gadgets = new ArrayList<ConfigGadget>();

    public ConfigDashboard() {
    }

    static Long parseId(Element element) {
        return ConfigXmlUtils.getLongValue(element, ATTRIBUTE_ID);
    }

    public ConfigDashboard(ConfigDashboard other) {
        this.id = other.id;
        this.owner = other.owner;
        this.name = other.name;
        this.description = other.description;
        this.sequence = other.sequence;
        this.layout = other.layout;
        this.version = other.version;
        this.favouriteCount = other.favouriteCount;
        this.gadgets = new ArrayList<ConfigGadget>(other.gadgets.size());
        for (ConfigGadget gadget : other.gadgets) {
            this.gadgets.add(new ConfigGadget(gadget));
        }
    }

    public ConfigDashboard(Element element) {
        this.id = ConfigDashboard.parseId(element);
        this.owner = ConfigXmlUtils.getTextValue(element, ATTRIBUTE_USERNAME);
        this.name = ConfigXmlUtils.getTextValue(element, ATTRIBUTE_PAGENAME);
        this.description = ConfigXmlUtils.getTextValue(element, ATTRIBUTE_DESCRIPTION);
        this.sequence = ConfigXmlUtils.getLongValue(element, ATTRIBUTE_SEQUENCE);
        this.layout = ConfigXmlUtils.getTextValue(element, ATTRIBUTE_LAYOUT);
        this.version = ConfigXmlUtils.getLongValue(element, ATTRIBUTE_VERSION);
        this.favouriteCount = ConfigXmlUtils.getLongValue(element, ATTRIBUTE_FAV_COUNT);
    }

    public boolean save(Element element) {
        ConfigDashboard oldAttributes = new ConfigDashboard(element);
        if (oldAttributes.isSameSavedState(this)) {
            return false;
        }
        ConfigXmlUtils.setAttribute(element, ATTRIBUTE_ID, this.id);
        ConfigXmlUtils.setAttribute(element, ATTRIBUTE_USERNAME, (Object)this.owner);
        ConfigXmlUtils.setAttribute(element, ATTRIBUTE_PAGENAME, (Object)this.name);
        ConfigXmlUtils.setAttribute(element, ATTRIBUTE_DESCRIPTION, (Object)this.description);
        ConfigXmlUtils.setAttribute(element, ATTRIBUTE_SEQUENCE, this.sequence);
        ConfigXmlUtils.setAttribute(element, ATTRIBUTE_LAYOUT, (Object)this.layout);
        ConfigXmlUtils.setAttribute(element, ATTRIBUTE_VERSION, this.version);
        ConfigXmlUtils.setAttribute(element, ATTRIBUTE_FAV_COUNT, this.favouriteCount);
        return true;
    }

    @Override
    public String getEntityType() {
        return ENTITY_TYPE;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public ConfigDashboard setId(Long id) {
        this.id = id;
        return this;
    }

    public Long getSequence() {
        return this.sequence;
    }

    public ConfigDashboard setSequence(Long sequence) {
        this.sequence = sequence;
        return this;
    }

    public String getOwner() {
        return this.owner;
    }

    public ConfigDashboard setOwner(String owner) {
        this.owner = owner;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ConfigDashboard setName(String name) {
        this.name = name;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public ConfigDashboard setDescription(String description) {
        this.description = description;
        return this;
    }

    public Long getFavouriteCount() {
        return this.favouriteCount;
    }

    public ConfigDashboard setFavouriteCount(Long favouriteCount) {
        this.favouriteCount = favouriteCount;
        return this;
    }

    public Long getVersion() {
        return this.version;
    }

    public ConfigDashboard setVersion(Long version) {
        this.version = version;
        return this;
    }

    public String getLayout() {
        return this.layout;
    }

    public ConfigDashboard setLayout(String layout) {
        this.layout = layout;
        return this;
    }

    public boolean isSystem() {
        return this.owner == null;
    }

    public ConfigDashboard setGadgets(Collection<? extends ConfigGadget> gadgets) {
        this.gadgets = gadgets == null ? new ArrayList<ConfigGadget>() : new ArrayList<ConfigGadget>(gadgets);
        return this;
    }

    public List<ConfigGadget> getGadgets() {
        return this.gadgets;
    }

    public ConfigDashboard reorderGadgets() {
        if (this.gadgets.isEmpty()) {
            return this;
        }
        ArrayList<ConfigGadget> sortedGadgets = new ArrayList<ConfigGadget>(this.gadgets);
        Collections.sort(sortedGadgets, GadgetPositionComparator.INSTANCE);
        int actualColumn = 0;
        int actualRow = 0;
        int lastColumn = ConfigDashboard.getNullAsZero(((ConfigGadget)sortedGadgets.get(0)).getColumnNumber());
        for (ConfigGadget gadget : sortedGadgets) {
            int currentColumn = ConfigDashboard.getNullAsZero(gadget.getColumnNumber());
            if (currentColumn != lastColumn) {
                actualRow = 0;
                ++actualColumn;
                lastColumn = currentColumn;
            }
            gadget.setColumnNumber(actualColumn).setRowNumber(actualRow);
            ++actualRow;
        }
        return this;
    }

    private static int getNullAsZero(Integer integer) {
        return integer == null ? 0 : integer;
    }

    private boolean isSameSavedState(ConfigDashboard dashboard) {
        if (this.description != null ? !this.description.equals(dashboard.description) : dashboard.description != null) {
            return false;
        }
        if (this.favouriteCount != null ? !this.favouriteCount.equals(dashboard.favouriteCount) : dashboard.favouriteCount != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(dashboard.id) : dashboard.id != null) {
            return false;
        }
        if (this.layout != null ? !this.layout.equals(dashboard.layout) : dashboard.layout != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(dashboard.name) : dashboard.name != null) {
            return false;
        }
        if (this.owner != null ? !this.owner.equals(dashboard.owner) : dashboard.owner != null) {
            return false;
        }
        if (this.sequence != null ? !this.sequence.equals(dashboard.sequence) : dashboard.sequence != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(dashboard.version) : dashboard.version != null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigDashboard dashboard = (ConfigDashboard)o;
        return this.isSameSavedState(dashboard) && this.gadgets.equals(dashboard.getGadgets());
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.sequence != null ? this.sequence.hashCode() : 0);
        result = 31 * result + (this.owner != null ? this.owner.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.favouriteCount != null ? this.favouriteCount.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.layout != null ? this.layout.hashCode() : 0);
        result = 31 * result + this.gadgets.hashCode();
        return result;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    private static class GadgetPositionComparator
    implements Comparator<ConfigGadget> {
        private static final Comparator<ConfigGadget> INSTANCE = new GadgetPositionComparator();

        private GadgetPositionComparator() {
        }

        @Override
        public int compare(ConfigGadget o1, ConfigGadget o2) {
            int col1 = GadgetPositionComparator.getIntWithDefault(o1.getColumnNumber(), 0);
            int col2 = GadgetPositionComparator.getIntWithDefault(o2.getColumnNumber(), 0);
            int row1 = GadgetPositionComparator.getIntWithDefault(o1.getRowNumber(), Integer.MAX_VALUE);
            int row2 = GadgetPositionComparator.getIntWithDefault(o2.getRowNumber(), Integer.MAX_VALUE);
            if (col1 == col2) {
                if (row1 == row2) {
                    return 0;
                }
                if (row1 < row2) {
                    return -1;
                }
                return 1;
            }
            if (col1 < col2) {
                return -1;
            }
            return 1;
        }

        private static int getIntWithDefault(Integer intObj, int defaultValue) {
            return intObj == null ? defaultValue : intObj;
        }
    }
}

