/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config.sharing;

import com.atlassian.jira.functest.config.ConfigXmlUtils;
import com.atlassian.jira.functest.config.sharing.ConfigSharedEntity;
import com.atlassian.jira.functest.config.sharing.ConfigSharedEntityCleaner;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;

public class SharePermissionsCleaner
implements ConfigSharedEntityCleaner {
    private final Document document;

    public SharePermissionsCleaner(Document document) {
        this.document = document;
    }

    @Override
    public boolean clean(ConfigSharedEntity entity) {
        List<Element> elementList = this.getElementsForEntity(entity);
        if (elementList.isEmpty()) {
            return false;
        }
        for (Element element : elementList) {
            ConfigXmlUtils.removeElement(element);
        }
        return true;
    }

    private List<Element> getElementsForEntity(ConfigSharedEntity entity) {
        if (entity.getId() == null || StringUtils.isBlank((CharSequence)entity.getEntityType())) {
            return Collections.emptyList();
        }
        return ConfigXmlUtils.getElementsByXpath(this.document, String.format("/entity-engine-xml/SharePermissions[@entityId='%d' and @entityType='%s']", entity.getId(), entity.getEntityType()));
    }
}

