/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config.xml;

import com.atlassian.jira.functest.config.CheckOptionsUtils;
import com.atlassian.jira.functest.config.ConfigFile;
import com.atlassian.jira.functest.config.ConfigFileWalker;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;

public final class UpgradeXmlVerifier {
    private static final String UPGRADE = "upgrade";
    private final File root;

    public UpgradeXmlVerifier(File root) {
        this.root = Assertions.notNull(root);
    }

    public void verify() {
        VerifierWalker walker = new VerifierWalker();
        new ConfigFileWalker(this.root, walker).walk();
        if (!walker.badFiles.isEmpty()) {
            throw new AssertionError((Object)("The following upgrade XMLs do not contain suppress upgrade check: " + walker.badFiles));
        }
    }

    private static final class VerifierWalker
    implements ConfigFileWalker.ConfigVisitor {
        private final List<String> badFiles = Lists.newArrayList();

        private VerifierWalker() {
        }

        @Override
        public void visitConfig(ConfigFile file) {
            if (this.looksLikeUpgradeXml(file) && this.noUpgradeSuppress(file)) {
                this.badFiles.add(file.getFile().getName());
            }
        }

        private boolean noUpgradeSuppress(ConfigFile file) {
            return CheckOptionsUtils.parseOptions(file.readConfig()).checkEnabled(UpgradeXmlVerifier.UPGRADE);
        }

        private boolean looksLikeUpgradeXml(ConfigFile file) {
            File xml = file.getFile();
            return xml.getName().toLowerCase().contains(UpgradeXmlVerifier.UPGRADE) || xml.getParentFile().getName().toLowerCase().contains(UpgradeXmlVerifier.UPGRADE);
        }

        @Override
        public void visitConfigError(File file, ConfigFile.ConfigFileException e) {
            throw e;
        }
    }
}

