/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.DefaultSendBulkMail;
import com.atlassian.jira.functest.framework.FormImpl;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LocatorFactoryImpl;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.AdminTabs;
import com.atlassian.jira.functest.framework.admin.AdminTabsImpl;
import com.atlassian.jira.functest.framework.admin.AdvancedApplicationProperties;
import com.atlassian.jira.functest.framework.admin.AdvancedApplicationPropertiesImpl;
import com.atlassian.jira.functest.framework.admin.Attachments;
import com.atlassian.jira.functest.framework.admin.AttachmentsImpl;
import com.atlassian.jira.functest.framework.admin.CustomFields;
import com.atlassian.jira.functest.framework.admin.CustomFieldsImpl;
import com.atlassian.jira.functest.framework.admin.DefaultMailServerAdministration;
import com.atlassian.jira.functest.framework.admin.FieldConfigurationSchemes;
import com.atlassian.jira.functest.framework.admin.FieldConfigurationSchemesImpl;
import com.atlassian.jira.functest.framework.admin.FieldConfigurations;
import com.atlassian.jira.functest.framework.admin.FieldConfigurationsImpl;
import com.atlassian.jira.functest.framework.admin.GeneralConfiguration;
import com.atlassian.jira.functest.framework.admin.GeneralConfigurationImpl;
import com.atlassian.jira.functest.framework.admin.IssueLinking;
import com.atlassian.jira.functest.framework.admin.IssueLinkingImpl;
import com.atlassian.jira.functest.framework.admin.IssueSecuritySchemes;
import com.atlassian.jira.functest.framework.admin.IssueSecuritySchemesImpl;
import com.atlassian.jira.functest.framework.admin.MailServerAdministration;
import com.atlassian.jira.functest.framework.admin.NotificationSchemes;
import com.atlassian.jira.functest.framework.admin.NotificationSchemesImpl;
import com.atlassian.jira.functest.framework.admin.PermissionSchemes;
import com.atlassian.jira.functest.framework.admin.PermissionSchemesBackdoorImpl;
import com.atlassian.jira.functest.framework.admin.PermissionSchemesImpl;
import com.atlassian.jira.functest.framework.admin.Project;
import com.atlassian.jira.functest.framework.admin.ProjectImpl;
import com.atlassian.jira.functest.framework.admin.ProjectImport;
import com.atlassian.jira.functest.framework.admin.ProjectImportImpl;
import com.atlassian.jira.functest.framework.admin.Resolutions;
import com.atlassian.jira.functest.framework.admin.ResolutionsImpl;
import com.atlassian.jira.functest.framework.admin.Roles;
import com.atlassian.jira.functest.framework.admin.RolesImpl;
import com.atlassian.jira.functest.framework.admin.SendBulkMail;
import com.atlassian.jira.functest.framework.admin.Statuses;
import com.atlassian.jira.functest.framework.admin.StatusesImpl;
import com.atlassian.jira.functest.framework.admin.Subtasks;
import com.atlassian.jira.functest.framework.admin.SubtasksImpl;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.admin.TimeTrackingImpl;
import com.atlassian.jira.functest.framework.admin.UsersAndGroups;
import com.atlassian.jira.functest.framework.admin.UsersAndGroupsImpl;
import com.atlassian.jira.functest.framework.admin.ViewFieldScreens;
import com.atlassian.jira.functest.framework.admin.ViewFieldScreensImpl;
import com.atlassian.jira.functest.framework.admin.ViewServices;
import com.atlassian.jira.functest.framework.admin.ViewWorkflows;
import com.atlassian.jira.functest.framework.admin.ViewWorkflowsImpl;
import com.atlassian.jira.functest.framework.admin.plugins.Plugins;
import com.atlassian.jira.functest.framework.admin.plugins.PluginsImpl;
import com.atlassian.jira.functest.framework.admin.user.shared.DefaultSharedDashboardsAdministration;
import com.atlassian.jira.functest.framework.admin.user.shared.DefaultSharedFiltersAdministration;
import com.atlassian.jira.functest.framework.admin.user.shared.SharedDashboardsAdministration;
import com.atlassian.jira.functest.framework.admin.user.shared.SharedFiltersAdministration;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.backdoor.Backdoor;
import com.atlassian.jira.functest.framework.dump.TestInformationKit;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.util.AsynchronousTasks;
import com.atlassian.jira.functest.matcher.BuildNumberAssert;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.test.util.lic.License;
import com.atlassian.jira.testkit.client.dump.FuncTestTimer;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.testkit.client.log.FuncTestLoggerImpl;
import com.atlassian.jira.testkit.client.xmlbackup.XmlBackupCopier;
import com.atlassian.jira.webtests.CIDefaultLicenseProvider;
import com.atlassian.jira.webtests.LicenseKeys;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.google.common.base.Preconditions;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebRequestSource;
import com.meterware.httpunit.WebTable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.AbstractFileAssert;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AdministrationImpl
implements Administration {
    private static final String IMPORT_DIR = "import";
    private static final Pattern PATTERN_BUILD_NUMBER = Pattern.compile("#(\\d+)");
    private static final String FS = System.getProperty("file.separator");
    private final WebTester tester;
    private final JIRAEnvironmentData environmentData;
    private final FuncTestLogger logger;
    private final XmlBackupCopier xmlBackupCopier;
    private final Navigation navigation;
    private final AsynchronousTasks asynchronousTasks;
    private final TextAssertions text;
    private final GeneralConfiguration generalConfiguration;
    private final Project project;
    private final UsersAndGroups usersAndGroups;
    private final Roles roles;
    private final CustomFields customFields;
    private final PermissionSchemes permissionSchemesBackdoor;
    private final PermissionSchemes permissionSchemesOld;
    private final IssueSecuritySchemes issueSecuritySchemes;
    private final FieldConfigurations fieldConfigurations;
    private final FieldConfigurationSchemes fieldConfigurationSchemes;
    private final Resolutions resolutions;
    private final ViewServices viewServices;
    private final ProjectImport projectImport;
    private final Attachments attachments;
    private final Plugins plugins;
    private final ViewFieldScreens viewFieldScreens;
    private final ViewWorkflows workflows;
    private final MailServerAdministration mailServerAdministration;
    private final SharedFiltersAdministration sharedFiltersAdministration;
    private final SharedDashboardsAdministration sharedDashboardsAdministration;
    private final NotificationSchemes notificationSchemes;
    private final SendBulkMail sendBulkMail;
    private final AdminTabs adminTabs;
    private final AdvancedApplicationProperties advancedApplicationProperties;
    private final Backdoor backdoor;
    private final Statuses statuses;
    private static Set<String> copiedFiles = Collections.synchronizedSet(new HashSet());
    private static final ThreadLocal<String> JIRA_HOME_DIR = new ThreadLocal();
    private static boolean backdoorIsPresent = true;
    public static final String LEGACY_PROJECT_PERMISSIONS_PAGE_DARK_FEATURE = "com.atlassian.jira.permission-schemes.single-page-ui.disabled";

    @Inject
    public AdministrationImpl(WebTester tester, JIRAEnvironmentData environmentData, Navigation navigation, Assertions assertions) {
        this.tester = tester;
        this.environmentData = environmentData;
        this.logger = new FuncTestLoggerImpl(2);
        LocatorFactoryImpl locators = new LocatorFactoryImpl(tester);
        this.backdoor = new Backdoor(environmentData);
        this.xmlBackupCopier = new XmlBackupCopier(environmentData.getBaseUrl());
        this.navigation = navigation;
        this.asynchronousTasks = new AsynchronousTasks(tester, environmentData, 2);
        this.text = assertions.getTextAssertions();
        this.generalConfiguration = new GeneralConfigurationImpl(tester, environmentData);
        this.project = new ProjectImpl(this.backdoor, tester, environmentData, navigation, assertions, this.asynchronousTasks);
        this.usersAndGroups = new UsersAndGroupsImpl(tester, navigation, assertions.getTextAssertions(), locators);
        this.roles = new RolesImpl(tester, environmentData, 3);
        this.customFields = new CustomFieldsImpl(tester, environmentData, navigation, new FormImpl(tester));
        this.permissionSchemesOld = new PermissionSchemesImpl(tester, environmentData);
        this.permissionSchemesBackdoor = new PermissionSchemesBackdoorImpl(this.backdoor, tester, environmentData);
        this.issueSecuritySchemes = new IssueSecuritySchemesImpl(tester, environmentData);
        this.fieldConfigurations = new FieldConfigurationsImpl(tester, environmentData);
        this.fieldConfigurationSchemes = new FieldConfigurationSchemesImpl(tester, environmentData);
        this.resolutions = new ResolutionsImpl(tester, environmentData);
        this.viewServices = new ViewServices(tester, navigation);
        this.projectImport = new ProjectImportImpl(tester, environmentData, navigation, this);
        this.attachments = new AttachmentsImpl(tester, environmentData, navigation);
        this.viewFieldScreens = new ViewFieldScreensImpl(tester, environmentData, navigation);
        this.workflows = new ViewWorkflowsImpl(tester, environmentData, 2, navigation);
        this.plugins = new PluginsImpl(tester, environmentData, 2, navigation, this, locators);
        this.mailServerAdministration = new DefaultMailServerAdministration(tester, navigation, locators);
        this.sharedFiltersAdministration = new DefaultSharedFiltersAdministration(tester, navigation);
        this.sharedDashboardsAdministration = new DefaultSharedDashboardsAdministration(tester, navigation, locators);
        this.sendBulkMail = new DefaultSendBulkMail(navigation);
        this.notificationSchemes = new NotificationSchemesImpl(tester, environmentData, 2);
        this.adminTabs = new AdminTabsImpl(tester, environmentData);
        this.advancedApplicationProperties = new AdvancedApplicationPropertiesImpl(tester, environmentData);
        this.statuses = new StatusesImpl(tester, navigation);
    }

    @Override
    public void reIndex() {
        this.backdoor.indexing().reindexAll();
    }

    @Override
    public void setProfiling(boolean on) {
    }

    @Override
    public void restoreBlankInstance() {
        this.restoreBlankInstanceWithLicense(CIDefaultLicenseProvider.get());
    }

    @Override
    public void restoreBlankServerInstance() {
        this.restoreBlankInstanceWithLicense(LicenseKeys.COMMERCIAL);
    }

    @Override
    public void restoreBlankDataCenterInstance() {
        this.restoreBlankInstanceWithLicense(LicenseKeys.DATA_CENTER_SOFTWARE);
    }

    @Override
    public void restoreBlankInstanceWithLicense(License license) {
        this.restoreDataWithLicense("blankprojects.xml", license.getLicenseString());
    }

    @Override
    public void restoreNotSetupInstance() {
        this.restoreNotSetupInstance(CIDefaultLicenseProvider.get().getLicenseString());
    }

    @Override
    public void restoreNotSetupInstance(String licenseKey) {
        this.restoreNotSetupInstance("TestEmpty.xml", licenseKey);
    }

    @Override
    @Deprecated
    public void restoreNotSetupRenaissanceInstance(String licenseKey) {
        this.restoreNotSetupInstance("TestEmpty.xml", licenseKey);
    }

    private void restoreNotSetupInstance(String fileName, String licenseKey) {
        File file = new File(this.environmentData.getXMLDataLocation(), fileName);
        this.copyFileToJiraImportDirectory(file);
        this.goToRestorePage();
        this.tester.setWorkingForm("restore-xml-data-backup");
        this.tester.setFormElement("license", licenseKey);
        this.tester.setFormElement("filename", file.getName());
        this.tester.checkCheckbox("quickImport", "true");
        this.tester.submit();
        this.waitForRestore();
        this.tester.assertTextPresent("Jira setup");
    }

    @Override
    public void copyFileToJiraImportDirectory(File file) {
        String filename = file.getName();
        if (!copiedFiles.contains(filename)) {
            File jiraImportDirectory = new File(this.getJiraHomeDirectory(), IMPORT_DIR);
            try {
                FileUtils.copyFileToDirectory((File)file, (File)jiraImportDirectory);
                copiedFiles.add(filename);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not copy file " + file.getAbsolutePath() + " to the import directory in jira home " + jiraImportDirectory, e);
            }
        }
    }

    @Override
    public File replaceTokensInFile(String originalXmlFileName, Map<String, String> replacements) throws IOException {
        String resource = this.environmentData.getXMLDataLocation().getAbsolutePath() + "/" + originalXmlFileName;
        String xml = IOUtils.toString((Reader)new FileReader(resource));
        xml = this.replaceTokens(xml, replacements);
        File newData = File.createTempFile(originalXmlFileName, ".xml");
        FileWriter of = new FileWriter(newData);
        of.write(xml);
        of.close();
        return newData;
    }

    @Override
    public void restoreDataWithReplacedTokens(String originalXmlFileName, Map<String, String> replacements) throws IOException {
        this.restoreDataWithReplacedTokens(originalXmlFileName, replacements, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreDataWithReplacedTokens(String originalXmlFileName, Map<String, String> replacements, boolean useDefaultPaths) throws IOException {
        String resource = this.environmentData.getXMLDataLocation().getAbsolutePath() + "/" + originalXmlFileName;
        String xml = IOUtils.toString((Reader)new FileReader(resource));
        xml = this.replaceTokens(xml, replacements);
        File newData = null;
        try {
            newData = this.replaceTokensInFile(originalXmlFileName, replacements);
            this.restoreData(newData.getParent(), newData.getName(), useDefaultPaths);
        }
        finally {
            if (newData.exists()) assert (newData.delete());
        }
    }

    @Override
    public void restoreData(String fileName) {
        if (backdoorIsPresent) {
            try {
                this.backdoor.restoreDataFromResource(fileName);
                this.navigation.login("admin", "admin");
            }
            catch (WebApplicationException uie) {
                this.logger.log((Object)"Backdoor was not present");
                this.logger.log((Throwable)uie);
                backdoorIsPresent = false;
                this.restoreData(fileName, false);
            }
        } else {
            this.restoreData(fileName, false);
        }
    }

    @Override
    public void restoreData(String fileName, boolean useDefaultPaths) {
        this.restoreData(this.environmentData.getXMLDataLocation().getAbsolutePath(), fileName, useDefaultPaths);
    }

    @Override
    public void restoreData(String fileName, Administration.OutgoingMailSettings outgoingMailSetting) {
        this.restoreData(this.environmentData.getXMLDataLocation().getAbsolutePath(), fileName, true, "admin", "admin", false, CIDefaultLicenseProvider.get().getLicenseString(), outgoingMailSetting);
    }

    @Override
    public Administration.Link link() {
        return () -> this.tester.getDialog().isLinkPresent("admin_link") || this.tester.getDialog().isLinkPresent("admin_project_menu");
    }

    @Override
    public void restoreDataAndLogin(String fileName, String username) {
        this.restoreDataAndLogin(fileName, username, false);
    }

    @Override
    public void restoreDataAndLogin(String fileName, String username, boolean useDefaultPaths) {
        this.restoreData(this.environmentData.getXMLDataLocation().getAbsolutePath(), fileName, true, username, username, useDefaultPaths);
    }

    @Override
    public void restoreDataSlowOldWayAndLogin(String fileName, String username) {
        this.restoreDataSlowOldWayAndLogin(fileName, username, false);
    }

    @Override
    public void restoreDataSlowOldWayAndLogin(String fileName, String username, boolean useDefaultPath) {
        this.restoreData(this.environmentData.getXMLDataLocation().getAbsolutePath(), fileName, false, "admin", "admin", useDefaultPath);
    }

    @Override
    public void restoreDataSlowOldWay(String fileName) {
        this.restoreDataSlowOldWay(fileName, false);
    }

    @Override
    public void restoreDataSlowOldWay(String fileName, boolean useDefaultPaths) {
        this.restoreDataSlowOldWay(this.environmentData.getXMLDataLocation().getAbsolutePath(), fileName, useDefaultPaths);
    }

    @Override
    public void restoreDataWithPluginsReload(String fileName) {
        this.restoreDataWithPluginsReload(fileName, false);
    }

    @Override
    public void restoreDataWithPluginsReload(String fileName, boolean useDefaultPaths) {
        this.restoreDataSlowOldWay(this.environmentData.getXMLDataLocation().getAbsolutePath(), fileName, useDefaultPaths);
    }

    public void restoreData(String path, String fileName) {
        this.restoreData(path, fileName, false);
    }

    public void restoreData(String path, String fileName, boolean useDefaultPath) {
        this.restoreData(path, fileName, true, "admin", "admin", useDefaultPath);
    }

    @Override
    public void restoreDataSlowOldWay(String path, String fileName) {
        this.restoreDataSlowOldWay(path, fileName, false);
    }

    @Override
    public void restoreDataSlowOldWay(String path, String fileName, boolean useDefaultPath) {
        this.restoreData(path, fileName, false, "admin", "admin", useDefaultPath);
    }

    private void restoreData(String path, String fileName, boolean clearCache, String username, String password, boolean useDefaultPaths) {
        this.restoreData(path, fileName, clearCache, username, password, useDefaultPaths, CIDefaultLicenseProvider.get().getLicenseString(), null);
    }

    @Override
    public void restoreDataWithLicense(String fileName, String licenseKey, boolean useDefaultPaths) {
        this.restoreData(this.environmentData.getXMLDataLocation().getAbsolutePath(), fileName, true, "admin", "admin", useDefaultPaths, licenseKey, null);
    }

    @Override
    public void restoreDataWithLicense(String fileName, String licenseKey) {
        this.restoreDataWithLicense(fileName, licenseKey, false);
    }

    private void restoreData(String path, String fileName, boolean clearCache, String username, String password, boolean useDefaultPaths, String licenseString, Administration.OutgoingMailSettings outgoingMailSettings) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.SYSTEM_INFO);
        FuncTestTimer timer = TestInformationKit.pullTimer((String)"XML Restore");
        String sourcePath = path + FS + fileName;
        String jiraImportDir = this.getJiraHomeDirectory() + FS + IMPORT_DIR + FS + new File(fileName).getName();
        boolean baseUrlReplaced = this.xmlBackupCopier.copyXmlBackupTo(sourcePath, jiraImportDir);
        this.logger.log((Object)("Restoring data '" + jiraImportDir + "'"));
        this.goToRestorePage();
        this.tester.setWorkingForm("restore-xml-data-backup");
        this.tester.setFormElement("filename", fileName);
        this.tester.setFormElement("license", licenseString);
        if (outgoingMailSettings != null) {
            this.tester.setFormElement("outgoingEmail", outgoingMailSettings.asString());
        }
        if (useDefaultPaths) {
            this.reflectivelySetDefaultPaths(this.tester.getDialog().getForm());
        }
        if (clearCache) {
            this.tester.checkCheckbox("quickImport", "true");
        }
        this.tester.submit();
        this.waitForRestore();
        if (!this.isRestoreSuccessful()) {
            this.assertCauseOfError("The xml data you are trying to import seems to be from a newer version of Jira. This will not work.", jiraImportDir);
            this.assertCauseOfError("You must enter the location of an XML file.", jiraImportDir);
            this.assertCauseOfError("Could not find file at this location.", jiraImportDir);
            this.assertCauseOfError("Invalid license key specified.", jiraImportDir);
            this.assertCauseOfError("The current license is too old to install this version of Jira", jiraImportDir);
            this.assertCauseOfError("Invalid license type for this version of Jira. License should be of type Standard.", jiraImportDir);
            this.assertCauseOfError("Invalid license type for this version of Jira. License should be of type Professional.", jiraImportDir);
            this.assertCauseOfError("Invalid license type for this version of Jira. License should be of type Enterprise.", jiraImportDir);
            this.assertCauseOfError("You must specify an index for the restore process.", jiraImportDir);
            this.assertCauseOfError("Error parsing export file. Your export file is invalid.", jiraImportDir);
            this.assertCauseOfError("specified in the backup file is not valid", jiraImportDir);
            throw new AssertionError((Object)("Failed to restore Jira data from [" + jiraImportDir + "]. See logs for details."));
        }
        this.navigation.disableWebSudo();
        this.navigation.login(username, password);
        long howLong = timer.end();
        this.logger.log((Object)("Restored '" + fileName + "' in " + howLong + "ms"));
        if (!baseUrlReplaced) {
            this.generalConfiguration.setBaseUrl(this.environmentData.getBaseUrl().toString());
        }
        this.tester.beginAt("/");
    }

    private void goToRestorePage() {
        this.tester.gotoPage(this.getRestoreUrl());
        if (this.isOnLoginPage()) {
            this.logger.log((Object)"Got redirected to login page. Falling back to root user.");
            this.navigation.login("root", "root");
            this.tester.gotoPage(this.getRestoreUrl());
        }
    }

    private boolean isOnLoginPage() {
        return this.tester.getTestContext().getWebClient().getCurrentPage().getURL().getPath().endsWith("login.jsp");
    }

    private String getRestoreUrl() {
        return "secure/admin/XmlRestore!default.jspa";
    }

    @Override
    public void restoreI18nData(String fileName) {
        FuncTestTimer timer = TestInformationKit.pullTimer((String)"XML Restore");
        String filePath = this.environmentData.getXMLDataLocation().getAbsolutePath() + "/" + fileName;
        File file = new File(filePath);
        this.copyFileToJiraImportDirectory(file);
        this.logger.log((Object)("Restoring data '" + filePath + "'"));
        this.goToRestorePage();
        this.tester.setWorkingForm("restore-xml-data-backup");
        this.tester.setFormElement("filename", file.getName());
        this.tester.setFormElement("license", CIDefaultLicenseProvider.get().getLicenseString());
        this.tester.checkCheckbox("quickImport", "true");
        this.tester.submit();
        this.waitForRestore();
        if (!this.isRestoreSuccessful()) {
            org.assertj.core.api.Assertions.fail((String)"Your project failed to import successfully. See logs for details");
        }
        long howLong = timer.end();
        this.navigation.disableWebSudo();
        this.navigation.login("admin", "admin");
        this.logger.log((Object)("Restored '" + fileName + "' in " + howLong + "ms"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreDataWithBuildNumber(String fileName, int expectedBuilderNumber) {
        File backupFile = new File(this.environmentData.getXMLDataLocation(), fileName);
        FileInputStream backup = null;
        try {
            backup = new FileInputStream(backupFile);
            BuildNumberAssert.assertThat(backup).hasBuildNumber(expectedBuilderNumber);
        }
        catch (FileNotFoundException missingXmlBackup) {
            org.assertj.core.api.Assertions.fail((String)String.format("The xml backup file: %s could not be found.", fileName));
        }
        finally {
            if (backup != null) {
                IOUtils.closeQuietly((InputStream)backup);
            }
        }
        this.restoreData(fileName);
    }

    private void reflectivelySetDefaultPaths(WebForm jiraForm) {
        Class<WebForm> webFormClass = WebForm.class;
        Class<WebRequestSource> webRequestSourceClass = WebRequestSource.class;
        this.reflectivlySetField(jiraForm, webFormClass, "_formParameters", null);
        this.reflectivlySetField(jiraForm, webFormClass, "_presetParameters", null);
        String postUrl = (String)this.reflectivelyGetField(jiraForm, webRequestSourceClass, "_destination");
        this.reflectivlySetField(jiraForm, webRequestSourceClass, "_destination", postUrl + "?useDefaultPaths=true");
        Class[] paramType = new Class[]{String.class, String.class};
        Object[] params = new String[]{"useDefaultPaths", "true"};
        this.reflectivelyInvoke(jiraForm, webFormClass, "addPresetParameter", paramType, params);
        this.tester.setFormElement("useDefaultPaths", "true");
    }

    private void reflectivelyInvoke(Object self, Class<?> clazz, String methodName, Class[] paramType, Object[] params) {
        Preconditions.checkNotNull((Object)self, (String)"cannot invoke %s on null object", (Object)methodName);
        Method method = null;
        try {
            method = clazz.getDeclaredMethod(methodName, paramType);
            method.setAccessible(true);
            method.invoke(self, params);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(String.format("Error getting method '%s(%s)' for %s : possibly a library update has changed this method", methodName, Arrays.toString(paramType), clazz.getName()), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(String.format("Error invoking method '%s(%s)' for %s : exception raised during method invocation : %s", e.getCause().getMessage(), methodName, Arrays.toString(paramType), clazz.getName()), e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("Error invoking method '%s(%s)' for %s : possibly a security manager has prevented access to this method", methodName, Arrays.toString(paramType), clazz.getName()), e);
        }
        finally {
            if (method != null) {
                method.setAccessible(false);
            }
        }
    }

    private void reflectivlySetField(Object self, Class<?> clazz, String fieldName, Object fieldValue) {
        Preconditions.checkNotNull((Object)self, (String)"cannot set field %s to %s on null object", (Object)fieldName, (Object)fieldValue);
        Field field = null;
        try {
            field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(self, fieldValue);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("Error setting field '%s' to '%s' for %s : possibly a security manager has prevented access to this field", fieldName, fieldValue, clazz.getName()), e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(String.format("Error setting field '%s' to '%s' for %s : possibly a library update has changed this field", fieldName, fieldValue, clazz.getName()), e);
        }
        finally {
            if (field != null) {
                field.setAccessible(false);
            }
        }
    }

    private Object reflectivelyGetField(Object self, Class<?> clazz, String fieldName) {
        Preconditions.checkNotNull((Object)self, (String)"cannot get field %s on null object", (Object)fieldName);
        Field field = null;
        try {
            field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            Object object = field.get(self);
            return object;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("Error getting field '%s' for %s : possibly a security manager has prevented access to this field", fieldName, clazz.getName()), e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(String.format("Error getting field '%s' for %s : possibly a library update has changed this field", fieldName, clazz.getName()), e);
        }
        finally {
            if (field != null) {
                field.setAccessible(false);
            }
        }
    }

    @Override
    public File exportDataToFile(String fileName) {
        String text;
        FuncTestTimer timer = TestInformationKit.pullTimer((String)"XML Export");
        String realFileName = FilenameUtils.getName((String)fileName);
        this.logger.log((Object)("Backing up data to '" + realFileName + "'"));
        this.tester.gotoPage("secure/admin/XmlBackup!default.jspa");
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("filename", realFileName);
        this.tester.submit();
        if (new IdLocator(this.tester, "replace_submit").exists()) {
            this.tester.setWorkingForm("jiraform");
            this.tester.submit();
        }
        if ((text = StringUtils.stripToNull((String)new IdLocator(this.tester, "backup-file").getText())) == null) {
            org.assertj.core.api.Assertions.fail((String)"The restore did not redirect to the result page.");
        }
        timer.end();
        File file = new File(text);
        ((AbstractFileAssert)org.assertj.core.api.Assertions.assertThat((File)file).overridingErrorMessage("Backup returned '" + text + "' which is not an absolute file.", new Object[0])).isAbsolute();
        return file;
    }

    @Override
    public String getCurrentAttachmentPath() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.ATTACHMENTS);
        WebTable attachmentSettings = this.tester.getDialog().getWebTableBySummaryOrId("table-AttachmentSettings");
        if (attachmentSettings.getCellAsText(1, 0).contains("Attachments location")) {
            Node currentNode;
            NodeList attachmentsLocationContents = attachmentSettings.getTableCell(1, 1).getDOM().getChildNodes();
            for (currentNode = attachmentsLocationContents.item(0); currentNode != null && !currentNode.getNodeName().equals("STRONG"); currentNode = currentNode.getNextSibling()) {
            }
            if (currentNode != null) {
                Node pathNode;
                Node linebreakNode = currentNode.getNextSibling();
                Node node = pathNode = linebreakNode != null ? linebreakNode.getNextSibling() : null;
                if (pathNode != null) {
                    return pathNode.getNodeValue().trim();
                }
            }
        }
        throw new RuntimeException("Error occurred when trying to screen-scrape the attachment path. 'Attachments location' did not contain the expected DOM structure.");
    }

    @Override
    public void activateSubTasks() {
        this.logger.log((Object)"activating sub tasks");
        this.tester.gotoPage("/secure/admin/subtasks/ManageSubTasks.jspa");
        if (this.tester.getDialog().isLinkPresentWithText("Enable")) {
            this.tester.clickLinkWithText("Enable");
        } else {
            this.logger.log((Object)"Subtasks already enabled");
        }
    }

    @Override
    public void addSubTaskType(String name) {
        this.activateSubTasks();
        this.tester.setFormElement("name", name);
        this.tester.submit("Add");
    }

    @Override
    public GeneralConfiguration generalConfiguration() {
        return this.generalConfiguration;
    }

    @Override
    public Backdoor backdoor() {
        return this.backdoor;
    }

    @Override
    public Project project() {
        return this.project;
    }

    @Override
    public UsersAndGroups usersAndGroups() {
        return this.usersAndGroups;
    }

    @Override
    public Roles roles() {
        return this.roles;
    }

    @Override
    public CustomFields customFields() {
        return this.customFields;
    }

    @Override
    @Deprecated
    public PermissionSchemes permissionSchemes() {
        if (this.backdoor().darkFeatures().isGlobalEnabled(LEGACY_PROJECT_PERMISSIONS_PAGE_DARK_FEATURE)) {
            return this.permissionSchemesOld;
        }
        return this.permissionSchemesBackdoor;
    }

    @Override
    public IssueSecuritySchemes issueSecuritySchemes() {
        return this.issueSecuritySchemes;
    }

    @Override
    public FieldConfigurations fieldConfigurations() {
        return this.fieldConfigurations;
    }

    @Override
    public FieldConfigurationSchemes fieldConfigurationSchemes() {
        return this.fieldConfigurationSchemes;
    }

    @Override
    public ProjectImport projectImport() {
        return this.projectImport;
    }

    @Override
    public Plugins plugins() {
        return this.plugins;
    }

    @Override
    public void removeGlobalPermission(GlobalPermissionKey permissionKey, String group) {
        String deleteLink = "del_" + permissionKey.getKey() + "_" + group;
        this.navigation.gotoAdminSection(Navigation.AdminSection.GLOBAL_PERMISSIONS);
        if (this.tester.getDialog().isLinkPresent(deleteLink)) {
            this.tester.clickLink(deleteLink);
            this.tester.submit("Delete");
        }
    }

    @Override
    public void removeGlobalPermission(int permission, String group) {
        GlobalPermissionKey permissionKey = (GlobalPermissionKey)GlobalPermissionKey.GLOBAL_PERMISSION_ID_TRANSLATION.get((Object)permission);
        this.removeGlobalPermission(permissionKey, group);
    }

    @Override
    public void addGlobalPermission(GlobalPermissionKey permission, String group) {
        HtmlPage page = new HtmlPage(this.tester);
        String addUrl = page.addXsrfToken("secure/admin/jira/GlobalPermissions.jspa?groupName=" + group + "&globalPermType=" + permission.getKey() + "&action=add");
        this.tester.gotoPage(addUrl);
    }

    @Override
    public void addGlobalPermission(int permission, String group) {
        GlobalPermissionKey permissionKey = (GlobalPermissionKey)GlobalPermissionKey.GLOBAL_PERMISSION_ID_TRANSLATION.get((Object)permission);
        this.addGlobalPermission(permissionKey, group);
    }

    @Override
    public void switchToLicense(License license) {
        this.switchToLicense(license.getLicenseString(), license.getDescription());
    }

    @Override
    public void switchToLicense(String license, String description) {
        this.backdoor.license().replace(license);
    }

    @Override
    public void switchToPersonalLicense() {
        this.switchToLicense(LicenseKeys.PERSONAL_DC.getLicenseString(), "JIRA " + this.getEdition() + ": Personal");
    }

    @Override
    public void switchToStarterLicense() {
        this.switchToLicense(LicenseKeys.STARTER_DC.getLicenseString(), "JIRA " + this.getEdition() + ": Starter");
    }

    @Override
    public String getJiraHomeDirectory() {
        String jiraHome = JIRA_HOME_DIR.get();
        if (jiraHome == null) {
            String jiraHomePath = null;
            try {
                this.navigation.gotoAdminSection(Navigation.AdminSection.SYSTEM_INFO);
                WebTable filePathTable = this.tester.getDialog().getResponse().getTableWithID("file_paths");
                if (filePathTable != null && filePathTable.getTableCellWithID("file_paths_jirahome") != null) {
                    jiraHomePath = filePathTable.getTableCellWithID("file_paths_jirahome").asText().trim();
                }
                if (jiraHomePath == null) {
                    throw new RuntimeException("Can't find JIRA.HOME. Do you have websudo enabled?");
                }
                jiraHome = new File(jiraHomePath).getCanonicalPath();
                JIRA_HOME_DIR.set(jiraHome);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return jiraHome;
    }

    @Override
    public String getSystemTenantHomeDirectory() {
        WebTable filePathTable;
        this.navigation.gotoAdminSection(Navigation.AdminSection.SYSTEM_INFO);
        try {
            filePathTable = this.tester.getDialog().getResponse().getTableWithID("file_paths");
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        if (filePathTable != null && filePathTable.getTableCellWithID("file_paths_jirahome") != null) {
            return filePathTable.getTableCellWithID("file_paths_jirahome").asText().trim();
        }
        return null;
    }

    @Override
    public MailServerAdministration mailServers() {
        return this.mailServerAdministration;
    }

    @Override
    public SharedFiltersAdministration sharedFilters() {
        return this.sharedFiltersAdministration;
    }

    @Override
    public SharedDashboardsAdministration sharedDashboards() {
        return this.sharedDashboardsAdministration;
    }

    @Override
    public SendBulkMail sendBulkMail() {
        return this.sendBulkMail;
    }

    @Override
    public AdminTabs tabs() {
        return this.adminTabs;
    }

    @Override
    public AdvancedApplicationProperties advancedApplicationProperties() {
        return this.advancedApplicationProperties;
    }

    @Override
    public Statuses statuses() {
        return this.statuses;
    }

    private void assertCauseOfError(String errorMessage, String filePath) {
        if (this.tester.getDialog().isTextInResponse(errorMessage)) {
            throw new AssertionError((Object)("Failed to restore Jira data. Cause: " + errorMessage + " File path: [" + filePath + "]"));
        }
    }

    @Override
    public Subtasks subtasks() {
        return new SubtasksImpl(this.tester, this.environmentData);
    }

    @Override
    public IssueLinking issueLinking() {
        return new IssueLinkingImpl(this.tester, this.navigation, this.logger);
    }

    @Override
    public TimeTracking timeTracking() {
        return new TimeTrackingImpl(this.tester, this.environmentData);
    }

    @Override
    public Resolutions resolutions() {
        return this.resolutions;
    }

    @Override
    public ViewServices services() {
        return this.viewServices;
    }

    @Override
    public String getEdition() {
        return "Enterprise";
    }

    @Override
    public long getBuildNumber() {
        IdLocator idLocator = new IdLocator(this.tester, "footer-build-information");
        String buildInfo = idLocator.getText();
        if (StringUtils.isBlank((CharSequence)buildInfo)) {
            throw new RuntimeException("Unable to find build information in the footer.");
        }
        Matcher matcher = PATTERN_BUILD_NUMBER.matcher(buildInfo);
        if (!matcher.find()) {
            throw new RuntimeException("Unable to find build number from the footer.");
        }
        try {
            return Long.parseLong(matcher.group(1));
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Unable to find builder number from the footer.", e);
        }
    }

    private String replaceTokens(String source, Map<String, String> replacements) {
        for (String token : replacements.keySet()) {
            int index = source.indexOf(token);
            if (index < 0) {
                org.assertj.core.api.Assertions.fail((String)("Replacement token '" + token + "' not found"));
            }
            source = source.replaceAll(token, Matcher.quoteReplacement(replacements.get(token)));
        }
        return source;
    }

    @Override
    public void enableAccessLogging() {
        this.logger.log((Object)"enabling access logging");
        this.navigation.gotoAdminSection(Navigation.AdminSection.SYSTEM_INFO);
        this.tester.clickLink("enable_http_access");
    }

    @Override
    public Attachments attachments() {
        return this.attachments;
    }

    @Override
    public ViewFieldScreens viewFieldScreens() {
        return this.viewFieldScreens;
    }

    @Override
    public Administration.Utilities utilities() {
        return serviceId -> {
            this.navigation.gotoPage("ServiceExecutor.jspa");
            this.tester.setFormElement("serviceId", String.valueOf(serviceId));
            this.tester.submit();
            this.tester.assertTextNotPresent("No service with this id exists");
        };
    }

    @Override
    public ViewWorkflows workflows() {
        return this.workflows;
    }

    @Override
    public NotificationSchemes notificationSchemes() {
        return this.notificationSchemes;
    }

    private void waitForIndexCompletion(long sleepTime, int retryCount) {
        this.asynchronousTasks.waitForSuccessfulCompletion(sleepTime, retryCount, "Indexing");
    }

    private boolean isRestoreSuccessful() {
        return this.isOnRestore() && new XPathLocator(this.tester, "//a[@id=\"login\"]").exists();
    }

    private boolean isOnRestore() {
        return this.tester.getDialog().getResponse().getURL().toExternalForm().contains("ImportResult.jspa");
    }

    @Override
    public void waitForRestore() {
        String url = this.tester.getDialog().getResponse().getURL().toExternalForm();
        while (url.contains("importprogress")) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            String subUrl = url.substring(this.environmentData.getBaseUrl().toString().length());
            this.tester.gotoPage(subUrl);
            url = this.tester.getDialog().getResponse().getURL().toExternalForm();
        }
    }
}

