/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.testkit.beans.CustomFieldResponse;
import com.atlassian.jira.testkit.client.restclient.FieldMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;

public class BaseJiraIssueMetaTest
extends BaseJiraFuncTest {
    protected List<String> addSampleCustomFieldsWithOptions(boolean enabled) {
        HashMap<String, String> customFields = new HashMap<String, String>();
        customFields.put("select", "com.atlassian.jira.plugin.system.customfieldtypes:select");
        customFields.put("multiselect", "com.atlassian.jira.plugin.system.customfieldtypes:multiselect");
        customFields.put("cascadingselect", "com.atlassian.jira.plugin.system.customfieldtypes:cascadingselect");
        customFields.put("multicheckboxes", "com.atlassian.jira.plugin.system.customfieldtypes:multicheckboxes");
        customFields.put("radiobuttons", "com.atlassian.jira.plugin.system.customfieldtypes:radiobuttons");
        customFields.forEach((fieldName, fieldType) -> this.addCustomFieldWithOption((String)fieldName, (String)fieldType, enabled));
        return new ArrayList<String>(customFields.keySet());
    }

    protected void addCustomFieldWithOption(String customFieldName, String customFieldType, boolean enabled) {
        String customField = this.backdoor.customFields().createCustomField(customFieldName, null, customFieldType, null);
        String optionValue = "sampleOption";
        this.backdoor.customFields().addOption(customField, "sampleOption");
        this.changeOptionState("sampleOption", customField, enabled);
        this.backdoor.screens().addFieldToScreen("Default Screen", customFieldName);
    }

    protected void assertFieldAllowedValuesEnabled(FieldMetaData fieldMetaData) {
        fieldMetaData.allowedValues.forEach(allowedValue -> {
            Map props = (Map)allowedValue;
            Assertions.assertThat(props.get("disabled")).isEqualTo((Object)Boolean.FALSE);
        });
    }

    protected void assertFieldAllowedValuesDisabled(FieldMetaData fieldMetaData) {
        fieldMetaData.allowedValues.forEach(allowedValue -> {
            Map props = (Map)allowedValue;
            Assertions.assertThat(props.get("disabled")).isEqualTo((Object)Boolean.TRUE);
        });
    }

    private void changeOptionState(String optionValue, String customField, boolean toEnabled) {
        CustomFieldResponse field = this.backdoor.customFields().getCustomField(customField, true);
        field.getConfig().forEach(customFieldConfig -> customFieldConfig.getOptions().stream().filter(o -> optionValue.equals(o.getName())).forEach(o -> {
            if (toEnabled) {
                this.backdoor.customFields().enableOption(o.getId());
            } else {
                this.backdoor.customFields().disableOption(o.getId());
            }
        }));
    }
}

