/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.backdoor.Backdoor;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;
import org.assertj.core.api.Assertions;

public class FieldLayoutSchemes {
    private final Navigation navigation;
    private final WebTester tester;
    private final Backdoor backdoor;

    @Inject
    public FieldLayoutSchemes(Navigation navigation, WebTester tester, Backdoor backdoor) {
        this.navigation = navigation;
        this.tester = tester;
        this.backdoor = backdoor;
    }

    public void gotoFieldLayoutSchemes() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.ISSUE_FIELDS);
    }

    public void addFieldLayoutScheme(String scheme_name, String scheme_desc) {
        this.gotoFieldLayoutSchemes();
        this.tester.clickLink("add-field-configuration-scheme");
        this.tester.setFormElement("fieldLayoutSchemeName", scheme_name);
        this.tester.setFormElement("fieldLayoutSchemeDescription", scheme_desc);
        this.tester.submit("Add");
    }

    public void deleteFieldLayoutScheme(String scheme_name) {
        this.gotoFieldLayoutSchemes();
        this.tester.clickLink("del_" + scheme_name);
        this.tester.assertTextPresent("Delete Field Configuration Scheme");
        this.tester.assertTextPresent(scheme_name);
        this.tester.submit("Delete");
    }

    public void addFieldLayoutSchemeEntry(String issueTypeName, String fieldLayoutName, String schemeName) {
        this.gotoFieldLayoutSchemes();
        this.tester.clickLinkWithText(schemeName);
        this.tester.clickLink("add-issue-type-field-configuration-association");
        this.tester.selectOption("issueTypeId", issueTypeName);
        this.tester.selectOption("fieldConfigurationId", fieldLayoutName);
        this.tester.submit();
        this.tester.assertTextPresent(issueTypeName);
    }

    public void associateFieldLayoutScheme(String projectKey, String scheme_name) {
        String projectId = this.backdoor.project().getProjectId(projectKey).toString();
        this.tester.gotoPage("/secure/admin/SelectFieldLayoutScheme!default.jspa?projectId=" + projectId);
        this.tester.assertTextPresent("Field Layout Configuration Association");
        this.tester.selectOption("schemeId", scheme_name);
        this.tester.submit("Associate");
        Assertions.assertThat((String)this.backdoor.project().getSchemes((String)projectKey).fieldConfigurationScheme.name).isEqualTo(scheme_name);
    }

    public void associateWithDefaultFieldLayout(String projectKey) {
        String projectId = this.backdoor.project().getProjectId(projectKey).toString();
        this.tester.gotoPage("/secure/admin/SelectFieldLayoutScheme!default.jspa?projectId=" + projectId);
        this.tester.assertTextPresent("Field Layout Configuration Association");
        this.tester.selectOption("schemeId", "System Default Field Configuration");
        this.tester.submit("Associate");
    }

    public void copyFieldLayout(String fieldLayoutName) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.FIELD_CONFIGURATION);
        this.tester.assertTextPresent("View Field Configurations");
        this.tester.clickLinkWithText("Copy");
        this.tester.assertTextPresent("Copy Field Configuration:");
        this.tester.setFormElement("fieldLayoutName", fieldLayoutName);
        this.tester.submit();
    }
}

