/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.TestSuiteBuilder;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.log.FuncTestOut;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.atlassian.jira.webtests.util.LocalTestEnvironmentData;
import com.atlassian.jira.webtests.util.TestClassUtils;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class FuncTestSuite {
    private final Set<Class<?>> funcTests = new LinkedHashSet();
    private final Set<Class<?>> bundledPlugins2Tests = new LinkedHashSet();
    private final Set<Class<?>> tpmLdapTests = new LinkedHashSet();

    public TestSuite createTest() {
        return this.createTest(LocalTestEnvironmentData.DEFAULT);
    }

    public TestSuite createTest(JIRAEnvironmentData environment) {
        Set<Class<?>> tests = this.getTests(environment);
        TestSuiteBuilder builder = this.createFuncTestBuilder();
        builder.addTests(tests);
        return builder.build();
    }

    public Set<Class<?>> getTests(JIRAEnvironmentData environmentData) {
        Set<Object> tests;
        if (environmentData.isSingleNamedTest()) {
            tests = new LinkedHashSet();
            tests.add(environmentData.getSingleTestClass());
        } else if (environmentData.isAllTests()) {
            tests = new LinkedHashSet();
            tests.addAll(this.getFuncTests());
            tests.addAll(this.getBundledPlugins2Tests());
        } else {
            tests = environmentData.isBundledPluginsOnly() ? this.getBundledPlugins2Tests() : (environmentData.isTpmLdapTests() ? this.getTpmLdapTests() : this.getFuncTests());
        }
        return tests;
    }

    protected TestSuiteBuilder createFuncTestBuilder() {
        String numberOfBatches = System.getProperty("atlassian.test.suite.numbatches");
        String batchNumber = System.getProperty("atlassian.test.suite.batch");
        if (numberOfBatches != null && batchNumber != null) {
            String batchInfo = "Batch " + batchNumber + " of " + numberOfBatches;
            try {
                int numBatches = Integer.parseInt(numberOfBatches);
                int batch = Integer.parseInt(batchNumber);
                if (batch > 0 && batch <= numBatches) {
                    FuncTestOut.out.println(batchInfo);
                    return new TestSuiteBuilder(batch, numBatches).log(true);
                }
                FuncTestOut.out.println("Batch mode FAIL. Batch information looks wrong-arse: " + batchInfo);
            }
            catch (NumberFormatException e) {
                FuncTestOut.err.println("Batch mode FAIL. Batch information cannot be properly interpreted: " + batchInfo);
                e.printStackTrace(FuncTestOut.err);
            }
        }
        return new TestSuiteBuilder().log(true);
    }

    public Set<Class<?>> getFuncTests() {
        return new LinkedHashSet(this.funcTests);
    }

    public Set<Class<?>> getBundledPlugins2Tests() {
        return new LinkedHashSet(this.bundledPlugins2Tests);
    }

    public Set<Class<?>> getTpmLdapTests() {
        return new LinkedHashSet(this.tpmLdapTests);
    }

    public FuncTestSuite addBundledPluginsTests(List<Class<?>> testClasses) {
        testClasses.forEach(this::addBundledPluginsTest);
        return this;
    }

    public FuncTestSuite addBundledPluginsTest(Class<?> testClass) {
        FuncTestSuite.assertItsATest(testClass);
        this.bundledPlugins2Tests.add(testClass);
        return this;
    }

    public FuncTestSuite addTest(Class<?> testClass) {
        FuncTestSuite.assertItsATest(testClass);
        if (this.isLdapTest(testClass)) {
            this.tpmLdapTests.add(testClass);
        } else {
            this.funcTests.add(testClass);
        }
        return this;
    }

    private boolean isLdapTest(Class<?> testClass) {
        WebTest annotation = testClass.getAnnotation(WebTest.class);
        return annotation != null && Arrays.stream(annotation.value()).anyMatch(category -> category == Category.LDAP);
    }

    public FuncTestSuite addTests(Collection<Class<?>> testClasses) {
        for (Class<?> testCaseClass : testClasses) {
            this.addTest(testCaseClass);
        }
        return this;
    }

    private static void assertItsATest(Class<?> testCaseClass) {
        if (!(Test.class.isAssignableFrom(testCaseClass) || TestClassUtils.isJunit4TestClas(testCaseClass) || TestClassUtils.isJunit5TestClass(testCaseClass))) {
            throw new IllegalArgumentException("The class must be an instanceof of junit.framework.Test to be added - " + testCaseClass);
        }
    }

    public static List<Class<?>> getTestClasses(String packageName, boolean recursive) {
        List<Class<? extends TestCase>> junit3TestClasses = TestClassUtils.getJUnit3TestClasses(packageName, recursive);
        List<Class<?>> jUnit4TestClasses = TestClassUtils.getJUnit4TestClasses(packageName, recursive);
        return Ordering.from((Comparator)new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> o1, Class<?> o2) {
                return o1.getName().compareTo(o2.getName());
            }
        }).sortedCopy(Iterables.concat(junit3TestClasses, jUnit4TestClasses));
    }
}

