/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import java.util.Map;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;
import org.assertj.core.api.Assertions;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.w3c.dom.Document;

public class Indexing {
    private final Navigation navigation;
    private final WebTester tester;
    private final FuncTestLogger logger;
    private final HtmlPage htmlPage;

    @Inject
    public Indexing(Navigation navigation, WebTester tester, HtmlPage htmlPage, FuncTestLogger logger) {
        this.navigation = navigation;
        this.tester = tester;
        this.htmlPage = htmlPage;
        this.logger = logger;
    }

    public void assertIndexedFieldCorrect(String path, Map<String, String> expectedItemNodes, Map<String, String> unexpectedItemNodes, String issueKey) {
        try {
            String xpathExpression;
            this.navigation.gotoPage("/si/jira.issueviews:issue-xml/" + issueKey + "/" + issueKey + ".xml?jira.issue.searchlocation=index");
            Document doc = XMLUnit.buildControlDocument((String)this.htmlPage.asString());
            Assertions.assertThat((String)this.tester.getDialog().getResponse().getContentType()).isEqualTo("text/xml");
            if (expectedItemNodes != null) {
                for (Map.Entry<String, String> e : expectedItemNodes.entrySet()) {
                    xpathExpression = path + "[" + e.getKey() + "= &quot;" + e.getValue() + "&quot; ] ";
                    this.logger.log((Object)("Searching for existence of xpath " + xpathExpression));
                    XMLAssert.assertXpathExists((String)xpathExpression, (Document)doc);
                }
            }
            if (unexpectedItemNodes != null) {
                for (Map.Entry<String, String> e : unexpectedItemNodes.entrySet()) {
                    xpathExpression = path + "[" + e.getKey() + "= &quot;" + e.getValue() + "&quot; ] ";
                    this.logger.log((Object)("Searching for nonexistence of xpath " + xpathExpression));
                    XMLAssert.assertXpathNotExists((String)xpathExpression, (Document)doc);
                }
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            this.navigation.gotoPage("/secure/Dashboard.jspa");
        }
    }

    public void assertIndexContainsItem(String xpath, String issueKey) {
        try {
            this.navigation.gotoPage("/si/jira.issueviews:issue-xml/" + issueKey + "/" + issueKey + ".xml?jira.issue.searchlocation=index");
            Document doc = XMLUnit.buildControlDocument((String)this.htmlPage.asString());
            Assertions.assertThat((String)this.tester.getDialog().getResponse().getContentType()).isEqualTo("text/xml");
            XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            this.navigation.gotoPage("/secure/Dashboard.jspa");
        }
    }

    public void assertIndexNotContainsItem(String xpath, String issueKey) {
        try {
            this.navigation.gotoPage("/si/jira.issueviews:issue-xml/" + issueKey + "/" + issueKey + ".xml?jira.issue.searchlocation=index");
            Document doc = XMLUnit.buildControlDocument((String)this.htmlPage.asString());
            Assertions.assertThat((String)this.tester.getDialog().getResponse().getContentType()).isEqualTo("text/xml");
            XMLAssert.assertXpathNotExists((String)xpath, (Document)doc);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            this.navigation.gotoPage("/secure/Dashboard.jspa");
        }
    }
}

