/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import java.util.Optional;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;
import org.assertj.core.api.Fail;
import org.assertj.core.api.OptionalAssert;

public class ProgressBar {
    private final WebTester tester;
    private final Assertions assertions;
    private final TextAssertions textAssertions;
    private final HtmlPage htmlPage;

    @Inject
    public ProgressBar(WebTester tester, Assertions assertions, TextAssertions textAssertions, HtmlPage htmlPage) {
        this.tester = tester;
        this.assertions = assertions;
        this.textAssertions = textAssertions;
        this.htmlPage = htmlPage;
    }

    public long getSubmittedTaskId() {
        this.waitForStableTaskPage();
        return this.getTaskIdFromProgressBarUI();
    }

    public void waitForTaskAcknowledgement(long taskId) {
        this.waitForTaskState(taskId, "Acknowledge");
    }

    private void waitForTaskState(long taskId, String desiredTaskState) {
        String taskState;
        do {
            taskState = this.waitForStableTaskPage();
            long taskIdTest = this.getSubmittedTaskId();
            if (taskId != taskIdTest) {
                Fail.fail((String)("Expecting taskid <" + taskId + "> but got <" + taskIdTest + ">"));
            }
            if (taskState.equals(desiredTaskState)) {
                return;
            }
            if (!taskState.equals("Refresh")) continue;
            this.tester.submit("Refresh");
        } while (!desiredTaskState.equalsIgnoreCase(taskState));
    }

    private String waitForStableTaskPage() {
        int MAX_ITERATIONS = 100;
        int its = 0;
        while (true) {
            if (++its > 100) {
                Fail.fail((String)"The task took longer than 100 attempts!  Why?");
            }
            if (this.getResponseText().contains("type=\"submit\" name=\"Refresh\"")) {
                return "Refresh";
            }
            if (this.getResponseText().contains("type=\"submit\" name=\"Done\"")) {
                this.validateProgressBarUI("Done");
                return "Done";
            }
            if (this.getResponseText().contains("input type=\"submit\" name=\"Acknowledge\"")) {
                this.validateProgressBarUI("Acknowledge");
                return "Acknowledge";
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                Fail.fail((String)"Test interupted");
                continue;
            }
            break;
        }
    }

    private String getResponseText() {
        return this.tester.getDialog().getResponseText();
    }

    private long getTaskIdFromProgressBarUI() {
        String taskLocatorStr = "<div class=\"pb_border\" id=\"pb_taskid_";
        int startIndex = this.getResponseText().indexOf("<div class=\"pb_border\" id=\"pb_taskid_");
        if (startIndex == -1) {
            Fail.fail((String)"Failed to find task progress bar as expected");
        }
        int endIndex = this.getResponseText().indexOf("\">", startIndex += "<div class=\"pb_border\" id=\"pb_taskid_".length());
        String taskId = this.getResponseText().substring(startIndex, endIndex);
        return Long.parseLong(taskId);
    }

    public void validateProgressBarUI(String desiredTaskState) {
        Optional<Integer> leftPercentage = this.htmlPage.getRegexMatch("pb_barlefttd.+style\\s*=\\s*\"[^\"]*width\\s*\\:\\s+(\\d+)%.*\"").map(Integer::new);
        Optional<Integer> rightPercentage = this.htmlPage.getRegexMatch("pb_barrighttd.+style\\s*=\\s*\"[^\"]*width\\s*\\:\\s+(\\d+)%.*\"").map(Integer::new);
        if ("Acknowledge".equalsIgnoreCase(desiredTaskState) || "Done".equalsIgnoreCase(desiredTaskState)) {
            this.tester.assertTextPresent("Task completed");
            this.tester.assertTextPresent("Started");
            this.tester.assertTextPresent("Finished");
            org.assertj.core.api.Assertions.assertThat(rightPercentage).isEmpty();
            org.assertj.core.api.Assertions.assertThat(leftPercentage).contains((Object)100);
            if ("Done".equalsIgnoreCase(desiredTaskState)) {
                this.tester.assertTextPresent("<span>Started");
                this.textAssertions.assertRegexMatch(this.tester.getDialog().getResponseText(), "by <a href=\"[^\"]*/secure/admin/user/ViewUser.jspa\\?name=");
                this.assertions.assertNodeHasText(new CssLocator(this.tester, ".aui-message.aui-message-info"), "This task has finished running.");
                this.assertions.assertNodeHasText(new CssLocator(this.tester, ".aui-message.aui-message-info"), "who started this task should acknowledge it.");
            }
        } else {
            this.tester.assertTextNotPresent("Task completed");
            this.tester.assertTextNotPresent("Finished");
            if (!leftPercentage.isPresent()) {
                org.assertj.core.api.Assertions.assertThat(rightPercentage).contains((Object)100);
            } else if (!rightPercentage.isPresent()) {
                org.assertj.core.api.Assertions.assertThat(leftPercentage).contains((Object)100);
            } else {
                ((OptionalAssert)org.assertj.core.api.Assertions.assertThat(leftPercentage).overridingErrorMessage("Task should not be complete", new Object[0])).hasValueSatisfying(value -> org.assertj.core.api.Assertions.assertThat((Integer)value).isNotEqualTo(100));
                ((OptionalAssert)org.assertj.core.api.Assertions.assertThat(rightPercentage).overridingErrorMessage("Task should not be complete", new Object[0])).hasValueSatisfying(value -> org.assertj.core.api.Assertions.assertThat((Integer)value).isNotEqualTo(100));
                org.assertj.core.api.Assertions.assertThat((Integer)leftPercentage.get()).isEqualTo(100 - rightPercentage.get());
            }
        }
    }
}

