/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.httpclient.api.HttpStatus;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.testkit.client.log.FuncTestLoggerImpl;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.assertj.core.error.MultipleAssertionsError;

public class SmokeTester {
    private final FuncTestLogger log;
    private final Navigation navigation;
    private final Assertions assertions;

    @Inject
    public SmokeTester(Navigation navigation, Assertions assertions) {
        this.navigation = navigation;
        this.assertions = assertions;
        this.log = new FuncTestLoggerImpl();
    }

    public SmokeTestRunner test() {
        return new SmokeTestRunner();
    }

    private static class TestedPage {
        final String url;
        final String expectedText;

        private TestedPage(String url, String expectedText) {
            this.url = url;
            this.expectedText = expectedText;
        }
    }

    public class SmokeTestRunner {
        private final List<TestedPage> pages = new ArrayList<TestedPage>();

        public SmokeTestRunner page(String url, String expectedText) {
            this.pages.add(new TestedPage(url, expectedText));
            return this;
        }

        public void run() {
            ArrayList<AssertionError> assertionErrors = new ArrayList<AssertionError>();
            SmokeTester.this.log.log((Object)"Beginning Jira Smoke tests");
            for (TestedPage page : this.pages) {
                try {
                    SmokeTester.this.log.log((Object)String.format("\nTesting %s", page.url));
                    this.testPage(page.url, page.expectedText);
                }
                catch (AssertionError err) {
                    SmokeTester.this.log.log((Object)"Test failed! Details:");
                    SmokeTester.this.log.log((Throwable)((Object)err));
                    assertionErrors.add(err);
                }
            }
            if (!assertionErrors.isEmpty()) {
                throw new MultipleAssertionsError(assertionErrors);
            }
        }

        private void testPage(String pageUrl, String expectedText) {
            SmokeTester.this.navigation.gotoPage(pageUrl);
            SmokeTester.this.assertions.assertHttpStatusCode(HttpStatus.OK);
            SmokeTester.this.assertions.getTextAssertions().assertTextPresent(expectedText);
        }
    }
}

