/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.junit.runner.Description;

public class TestAnnotationsExtractor {
    private final Description description;

    public TestAnnotationsExtractor(Description description) {
        this.description = description;
    }

    public <A extends Annotation> Optional<A> findAnnotationFor(Class<A> annotationClass) {
        return Stream.of(() -> this.getFromMethod(annotationClass), () -> this.getFromClass(annotationClass)).map(Supplier::get).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    private <A extends Annotation> Optional<A> getFromClass(Class<A> annotationClass) {
        A annotation = this.description.getTestClass().getAnnotation(annotationClass);
        return Optional.ofNullable(annotation);
    }

    private <A extends Annotation> Optional<A> getFromMethod(Class<A> annotationClass) {
        return Optional.ofNullable(this.description.getMethodName()).flatMap(methodName -> this.getFromMethod((String)methodName, annotationClass));
    }

    private <A extends Annotation> Optional<A> getFromMethod(String methodName, Class<A> annotationClass) {
        try {
            return Optional.ofNullable(this.description.getTestClass().getMethod(methodName, new Class[0]).getAnnotation(annotationClass));
        }
        catch (NoSuchMethodException ignored) {
            return Optional.empty();
        }
    }
}

