/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LocatorFactoryImpl;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.UserProfile;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.util.dom.DomKit;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.testkit.client.log.FuncTestLoggerImpl;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;

public class UserProfileImpl
implements UserProfile {
    private final WebTester tester;
    private final LocatorFactory locators;
    private final FuncTestLogger logger;

    @Inject
    public UserProfileImpl(WebTester tester, JIRAEnvironmentData environmentData, Navigation navigation) {
        this.tester = tester;
        this.locators = new LocatorFactoryImpl(tester);
        this.logger = new FuncTestLoggerImpl(2);
    }

    @Override
    public String userName() {
        this.gotoCurrentUserProfile();
        return DomKit.getCollapsedText(this.locators.id("up-user-title-name").getNode());
    }

    @Override
    public UserProfile.Link link() {
        return new DefaultLink(this.tester);
    }

    @Override
    public void changeUserNotificationType(boolean useHtml) {
        this.logger.log((Object)("Changing user notification type to " + (useHtml ? "HTML" : "plain text")));
        this.gotoCurrentUserProfile();
        this.gotoEditUserPreferences();
        if (useHtml) {
            this.tester.selectOption("userNotificationsMimeType", "HTML");
        } else {
            this.tester.selectOption("userNotificationsMimeType", "Text");
        }
        this.tester.submit();
    }

    @Override
    public void changeUserSharingType(boolean global) {
        this.logger.log((Object)("changing user sharing default to '" + (global ? "public" : "private") + "'."));
        this.gotoCurrentUserProfile();
        this.gotoEditUserPreferences();
        this.tester.setFormElement("shareDefault", String.valueOf(!global));
        this.tester.submit();
    }

    @Override
    public void changeDefaultSharingType(boolean global) {
        this.logger.log((Object)("changing default user sharing to '" + (global ? "public" : "private") + "'."));
        this.gotoEditDefaultPreferences();
        this.tester.setFormElement("sharePublic", String.valueOf(!global));
        this.tester.submit("Update");
    }

    @Override
    public void changeUserLanguage(String lang) {
        this.logger.log((Object)("Changing user language to '" + lang + "'"));
        this.gotoCurrentUserProfile();
        this.gotoEditUserPreferences();
        this.tester.selectOption("userLocale", lang);
        this.tester.submit();
    }

    @Override
    public void changeUserLanguageByValue(String langValue) {
        this.logger.log((Object)("Changing user language to '" + langValue + "'"));
        this.gotoCurrentUserProfile();
        this.gotoEditUserPreferences();
        this.tester.getDialog().setFormParameter("userLocale", langValue);
        this.tester.submit();
    }

    @Override
    public void changeUserLanguageToJiraDefault() {
        this.changeUserLanguageByValue("-1");
    }

    private void gotoEditDefaultPreferences() {
        this.tester.gotoPage("secure/admin/jira/EditUserDefaultSettings!default.jspa");
    }

    private void gotoEditUserPreferences() {
        this.tester.clickLink("edit_prefs_lnk");
    }

    @Override
    public void gotoCurrentUserProfile() {
        this.tester.clickLink("view_profile");
    }

    @Override
    public void gotoUserProfile(String userName) {
        this.tester.gotoPage("/secure/ViewProfile.jspa?name=" + userName);
    }

    @Override
    public UserProfile changeUserTimeZone(String timeZoneID) {
        this.gotoCurrentUserProfile();
        this.gotoEditUserPreferences();
        this.tester.setFormElement("defaultUserTimeZone", timeZoneID == null ? "JIRA" : timeZoneID);
        this.tester.submit();
        return this;
    }

    @Override
    public UserProfile changeNotifyMyChanges(boolean notify) {
        this.gotoCurrentUserProfile();
        this.gotoEditUserPreferences();
        this.tester.selectOption("notifyOwnChanges", notify ? "Notify me" : "Do not notify me");
        this.tester.submit();
        return this;
    }

    @Override
    public UserProfile changeAutowatch(boolean autowatch) {
        this.gotoCurrentUserProfile();
        this.gotoEditUserPreferences();
        this.tester.selectOption("autoWatchPreference", autowatch ? "Enabled" : "Disabled");
        this.tester.submit();
        return this;
    }

    @Override
    public UserProfile changeQuickSearchingMode(String quickSearchingMode) {
        this.gotoCurrentUserProfile();
        this.gotoEditUserPreferences();
        this.tester.selectOption("smartQueryInQuickSearch", quickSearchingMode.equals("smartquery") ? "Smart query" : "Text");
        this.tester.submit();
        return this;
    }

    public static class DefaultLink
    implements UserProfile.Link {
        private final WebTester tester;

        public DefaultLink(WebTester tester) {
            this.tester = tester;
        }

        @Override
        public boolean isPresent() {
            return new IdLocator(this.tester, "header-details-user-fullname").exists();
        }
    }
}

