/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.Form;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.CustomFields;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.util.dom.DomKit;
import com.atlassian.jira.functest.framework.util.url.URLUtil;
import com.atlassian.jira.issue.fields.FieldId;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import java.net.URL;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;
import org.assertj.core.api.Fail;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CustomFieldsImpl
implements CustomFields {
    private final WebTester tester;
    private final Navigation navigation;
    private final Form form;

    @Inject
    public CustomFieldsImpl(WebTester tester, JIRAEnvironmentData environmentData, Navigation navigation, Form form) {
        this.tester = tester;
        this.navigation = navigation;
        this.form = form;
    }

    @Override
    public String addCustomField(String fieldType, String fieldName) {
        return this.addCustomField(fieldType, fieldName, new String[0], new String[0]);
    }

    @Override
    public String addCustomField(String fieldType, String fieldName, String[] issueTypes, String[] projects) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
        this.tester.clickLink("add_custom_fields");
        this.tester.setFormElement("fieldType", fieldType);
        this.tester.submit("nextBtn");
        this.tester.setFormElement("fieldName", fieldName);
        if (issueTypes.length == 0) {
            this.form.selectOption("issuetypes", "Any issue type");
        } else {
            this.form.selectOptionsByValue("issuetypes", issueTypes);
        }
        if (projects.length == 0) {
            this.tester.checkCheckbox("global", "true");
        } else {
            this.tester.checkCheckbox("global", "false");
        }
        this.form.selectOptionsByValue("projects", projects);
        this.tester.submit("nextBtn");
        String customFieldId = this.getQueryParamValueFromResponse("fieldId");
        this.tester.checkCheckbox("associatedScreens", "1");
        this.tester.submit("Update");
        return customFieldId;
    }

    @Override
    public String setCustomFieldSearcher(String customFieldId, String searcherKey) {
        if (searcherKey == null) {
            searcherKey = "-1";
        }
        this.tester.gotoPage("/secure/admin/EditCustomField!default.jspa?id=" + customFieldId);
        this.tester.setWorkingForm("jiraform");
        String oldSearcher = this.tester.getDialog().getForm().getParameterValue("searcher");
        this.tester.setFormElement("searcher", searcherKey);
        this.tester.submit("Update");
        return oldSearcher;
    }

    @Override
    public String renameCustomField(String numericCustomFieldId, String newCustomFieldName) {
        this.tester.gotoPage("/secure/admin/EditCustomField!default.jspa?id=" + numericCustomFieldId);
        this.tester.setWorkingForm("jiraform");
        String oldName = this.tester.getDialog().getForm().getParameterValue("name");
        this.tester.setFormElement("name", newCustomFieldName);
        this.tester.submit("Update");
        return oldName;
    }

    @Override
    public String addConfigurationSchemeContext(String customFieldId, String label, String[] issueTypeIds, String[] projectIds) {
        return this.addConfigurationSchemeContext(FieldId.fromCustomFieldId((long)Long.parseLong(customFieldId)), label, issueTypeIds, projectIds);
    }

    @Override
    public String addConfigurationSchemeContext(FieldId fieldId, String label, String[] issueTypeIds, String[] projectIds) {
        this.goToCustomFieldConfiguration(fieldId);
        this.tester.clickLinkWithText("Add new context");
        this.updateConfigurationSchemeContext(label, issueTypeIds, projectIds, true);
        return this.getSchemeIdForLabel(fieldId, label);
    }

    private String getSchemeIdForLabel(FieldId fieldId, String label) {
        this.goToCustomFieldConfiguration(fieldId);
        XPathLocator locator = new XPathLocator(this.tester, "//td[@class='jiraformheader']/h3[text() = '" + label + "']");
        if (!locator.exists()) {
            Fail.fail((String)("Could not find label '" + label + "' for custom field '" + fieldId.getCustomFieldId() + "'"));
            return null;
        }
        Element table = DomKit.getFirstParentByTag((Element)locator.getNodes()[0], "table");
        String schemeTableId = table.getAttribute("id");
        return schemeTableId.substring(12);
    }

    @Override
    public void editConfigurationSchemeContextById(String customFieldId, String fieldConfigSchemeId, String label, String[] issueTypeIds, String[] projectIds) {
        this.tester.gotoPage("/secure/admin/ManageConfigurationScheme!default.jspa?fieldConfigSchemeId=" + fieldConfigSchemeId + "&customFieldId=" + customFieldId);
        this.updateConfigurationSchemeContext(label, issueTypeIds, projectIds, false);
    }

    @Override
    public void editConfigurationSchemeContextByLabel(String numericCustomFieldId, String label, String newLabel, String[] issueTypeIds, String[] projectIds) {
        this.editConfigurationSchemeContextById(numericCustomFieldId, this.getSchemeIdForLabel(FieldId.fromCustomFieldId((long)Long.parseLong(numericCustomFieldId)), label), newLabel, issueTypeIds, projectIds);
    }

    private void updateConfigurationSchemeContext(String label, String[] issueTypeIds, String[] projectIds, boolean isAdd) {
        this.tester.setWorkingForm("jiraform");
        if (label != null) {
            this.tester.setFormElement("name", label);
        }
        if (issueTypeIds != null) {
            if (issueTypeIds.length == 0) {
                this.form.selectOption("issuetypes", "Any issue type");
            } else {
                this.form.selectOptionsByValue("issuetypes", issueTypeIds);
            }
        }
        if (projectIds != null) {
            XPathLocator locator = new XPathLocator(this.tester, "//input[@id='global_true']");
            if (locator.exists()) {
                if (projectIds.length == 0) {
                    this.tester.checkCheckbox("global", "true");
                } else {
                    this.tester.checkCheckbox("global", "false");
                }
            }
            this.form.selectOptionsByValue("projects", projectIds);
        }
        if (isAdd) {
            this.tester.submit("Add");
        } else {
            this.tester.submit("Modify");
        }
    }

    @Override
    public void removeGlobalContext(String customFieldId) {
        this.goToCustomFieldConfiguration(customFieldId);
        XPathLocator locator = new XPathLocator(this.tester, "//a[@title = 'Delete Scheme']");
        if (locator.getNodes().length == 0) {
            throw new IllegalArgumentException("Could not find any links with the title 'Delete Scheme'.");
        }
        String schemeTableId = null;
        for (Node node : locator.getNodes()) {
            XPathLocator globLoc;
            Element table = DomKit.getFirstParentByTag((Element)node, "table");
            if (table == null || (globLoc = new XPathLocator(table, ".//dd[text() = 'Global (all issues)']")).getNodes().length <= 0) continue;
            schemeTableId = table.getAttribute("id");
            break;
        }
        if (schemeTableId != null) {
            this.removeConfigurationSchemeContextById(customFieldId, schemeTableId.substring(12));
        }
    }

    @Override
    public void removeConfigurationSchemeContextById(String numericCustomFieldId, String fieldConfigSchemeId) {
        this.tester.gotoPage(String.format("/secure/admin/ConfigureCustomField!delete.jspa?customFieldId=%s&fieldConfigSchemeId=%s", numericCustomFieldId, fieldConfigSchemeId));
        this.tester.submit("delete-context");
    }

    @Override
    public void removeConfigurationSchemeContextByLabel(String numericCustomFieldId, String fieldConfigSchemeLabel) {
        this.removeConfigurationSchemeContextById(numericCustomFieldId, this.getSchemeIdForLabel(FieldId.fromCustomFieldId((long)Long.parseLong(numericCustomFieldId)), fieldConfigSchemeLabel));
    }

    @Override
    public void removeCustomField(String customFieldId) {
        this.navigation.gotoPage("/secure/admin/DeleteCustomField!default.jspa?id=" + CustomFields.numericCfId(customFieldId));
        this.tester.submit("Delete");
    }

    @Override
    public void addOptions(String numericCustomFieldId, String ... options) {
        this.goToCustomFieldConfiguration(numericCustomFieldId);
        this.tester.clickLinkWithText("Edit Options");
        for (String option : options) {
            this.tester.setWorkingForm("jiraform");
            this.tester.setFormElement("addValue", option);
            this.tester.submit();
        }
    }

    @Override
    public void setDefaultValue(String numericCustomFieldId, String defValue) {
        this.setDefaultValue(FieldId.fromCustomFieldId((long)Long.parseLong(numericCustomFieldId)), defValue);
    }

    @Override
    public void setDefaultValue(FieldId fieldId, String defValue) {
        this.goToCustomFieldConfiguration(fieldId);
        this.navigation.clickLinkWithExactText("Edit Default Value");
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement(fieldId.toFullId(), defValue);
        this.tester.submit();
    }

    @Override
    public void setCascadingSelectDefaultValue(String numericCustomFieldId, String defValue, String cascadingDefValue) {
        this.goToCustomFieldConfiguration(numericCustomFieldId);
        this.navigation.clickLinkWithExactText("Edit Default Value");
        this.tester.setWorkingForm("jiraform");
        this.form.selectOptionsByDisplayName("customfield_" + numericCustomFieldId, defValue, new String[0]);
        this.form.selectOptionsByDisplayName("customfield_" + numericCustomFieldId + ":1", cascadingDefValue, new String[0]);
        this.tester.submit();
    }

    @Override
    public void removeOptions(String numericCustomFieldId, String ... options) {
        this.goToCustomFieldConfiguration(numericCustomFieldId);
        this.tester.clickLinkWithText("Edit Options");
        for (String option : options) {
            this.tester.clickLink("del_" + option);
            this.tester.submit("Delete");
        }
    }

    @Override
    public void disableOptions(String numericCustomFieldId, String ... options) {
        this.goToCustomFieldConfiguration(numericCustomFieldId);
        this.tester.clickLinkWithText("Edit Options");
        for (String option : options) {
            this.tester.clickLink("disable_" + option);
        }
    }

    @Override
    public void enableOptions(String numericCustomFieldId, String ... options) {
        this.goToCustomFieldConfiguration(numericCustomFieldId);
        this.tester.clickLinkWithText("Edit Options");
        for (String option : options) {
            this.tester.clickLink("enable_" + option);
        }
    }

    @Override
    public void editOptionValue(String numericCustomFieldId, String option, String newValue) {
        this.goToCustomFieldConfiguration(numericCustomFieldId);
        this.tester.clickLinkWithText("Edit Options");
        this.tester.clickLink("edit_" + option);
        this.tester.setFormElement("value", newValue);
        this.tester.submit("Update");
    }

    @Override
    public void goToCustomFieldConfiguration(String numericCustomFieldId) {
        this.goToCustomFieldConfiguration(FieldId.fromCustomFieldId((long)Long.parseLong(numericCustomFieldId)));
    }

    @Override
    public void goToCustomFieldConfiguration(FieldId fieldId) {
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?fieldId=" + fieldId.toFullId());
    }

    private String getQueryParamValueFromResponse(String paramName) {
        URL url = this.tester.getDialog().getResponse().getURL();
        return URLUtil.getQueryParamValueFromUrl(url, paramName);
    }
}

