/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.NavigationImpl;
import com.atlassian.jira.functest.framework.admin.GeneralConfiguration;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.testkit.client.log.FuncTestLoggerImpl;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;

public class GeneralConfigurationImpl
implements GeneralConfiguration {
    private final WebTester tester;
    private final JIRAEnvironmentData environmentData;
    private final FuncTestLogger logger;
    private Navigation navigation;

    @Inject
    public GeneralConfigurationImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        this.tester = tester;
        this.environmentData = environmentData;
        this.logger = new FuncTestLoggerImpl(2);
        this.navigation = null;
    }

    @Override
    public void setAllowUnassignedIssues(boolean enable) {
        this.gotoEditGeneralConfig();
        this.tester.getDialog().setFormParameter("allowUnassigned", String.valueOf(enable));
        this.tester.submit();
    }

    @Override
    public void setExternalUserManagement(boolean enable) {
        this.gotoEditGeneralConfig();
        if (enable) {
            this.tester.checkCheckbox("externalUM", "true");
            this.tester.selectOption("mode", "Private");
        } else {
            this.tester.checkCheckbox("externalUM", "false");
        }
        this.tester.submit();
    }

    @Override
    public void enableVoting() {
        this.gotoEditGeneralConfig();
        this.tester.getDialog().setFormParameter("voting", "true");
        this.tester.submit();
    }

    @Override
    public void setCommentVisibility(GeneralConfiguration.CommentVisibility commentVisibility) {
        this.gotoEditGeneralConfig();
        this.tester.checkCheckbox("groupVisibility", commentVisibility.getCheckBoxValue().toString());
        this.tester.submit();
    }

    @Override
    public void setUserEmailVisibility(GeneralConfiguration.EmailVisibility emailVisibility) {
        this.gotoEditGeneralConfig();
        this.tester.getDialog().setFormParameter("emailVisibility", String.valueOf((Object)emailVisibility));
        this.tester.submit();
    }

    @Override
    public void setJqlAutocomplete(boolean enable) {
        this.gotoEditGeneralConfig();
        this.tester.getDialog().setFormParameter("jqlAutocompleteDisabled", String.valueOf(!enable));
        this.tester.submit();
    }

    @Override
    public void disableVoting() {
        this.gotoEditGeneralConfig();
        this.tester.getDialog().setFormParameter("voting", "false");
        this.tester.submit();
    }

    @Override
    public void setBaseUrl(String baseUrl) {
        this.logger.log((Object)("Setting baseurl to '" + baseUrl + "'"));
        this.gotoEditGeneralConfig();
        this.tester.setFormElement("baseURL", baseUrl);
        this.tester.submit();
    }

    @Override
    public void fixBaseUrl() {
        this.setBaseUrl(this.environmentData.getBaseUrl().toString());
    }

    @Override
    public void setJiraLocale(String locale) {
        String[] localeOptions;
        this.logger.log((Object)("Setting locale to '" + locale + "'"));
        this.gotoEditGeneralConfig();
        this.tester.setWorkingForm("jiraform");
        String localeToSelect = null;
        for (String localeOption : localeOptions = this.tester.getDialog().getOptionsFor("defaultLocale")) {
            if (localeOption.equals(locale)) {
                localeToSelect = locale;
                continue;
            }
            if (!localeOption.equals(locale.concat(" [Default]"))) continue;
            localeToSelect = locale.concat(" [Default]");
        }
        ((AbstractStringAssert)Assertions.assertThat((String)("The locale: " + locale + "could not be found as an option in the Default Language select list on the Administration --> General Configuration --> Edit Configuration Page")).overridingErrorMessage(localeToSelect, new Object[0])).isNotNull();
        this.tester.selectOption("defaultLocale", localeToSelect);
        this.tester.submit();
    }

    @Override
    public void setJiraLocaleByValue(String localeValue) {
        this.gotoEditGeneralConfig();
        this.tester.setWorkingForm("jiraform");
        Object[] defaultLocales = this.tester.getDialog().getOptionValuesFromSelectList("defaultLocale");
        ((ObjectArrayAssert)Assertions.assertThat((Object[])defaultLocales).overridingErrorMessage("Tried to set locale value to " + localeValue + " but could not find an option for the value", new Object[0])).contains((Object[])new String[]{localeValue});
        this.tester.setFormElement("defaultLocale", localeValue);
        this.tester.submit();
    }

    @Override
    public void setJiraLocaleToSystemDefault() {
        this.setJiraLocaleByValue("-1");
    }

    @Override
    public void disableWatching() {
        this.gotoEditGeneralConfig();
        this.tester.getDialog().setFormParameter("watching", "false");
        this.tester.submit();
    }

    @Override
    public void enableWatching() {
        this.gotoEditGeneralConfig();
        this.tester.getDialog().setFormParameter("watching", "true");
        this.tester.submit();
    }

    @Override
    public void turnOnGZipCompression() {
        this.gotoEditGeneralConfig();
        this.tester.checkCheckbox("useGzip", "true");
        this.tester.submit();
    }

    @Override
    public void setDefaultUserTimeZone(String timeZoneID) {
        this.gotoEditGeneralConfig();
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("defaultTimeZoneId", timeZoneID == null ? "System" : timeZoneID);
        this.tester.submit();
    }

    protected Navigation getNavigation() {
        if (this.navigation == null) {
            this.navigation = new NavigationImpl(this.tester, this.environmentData);
        }
        return this.navigation;
    }

    private void gotoEditGeneralConfig() {
        this.getNavigation().gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.getNavigation().webSudoAuthenticate("admin");
        this.tester.clickLink("edit-app-properties");
    }
}

