/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.NavigationImpl;
import com.atlassian.jira.functest.framework.admin.EditNotifications;
import com.atlassian.jira.functest.framework.admin.EditNotificationsImpl;
import com.atlassian.jira.functest.framework.admin.NotificationSchemes;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;

public class NotificationSchemesImpl
implements NotificationSchemes {
    private static final String ADD_NOTIFICATION_SCHEME_LINK_ID = "add-notification-scheme";
    private final WebTester tester;
    private final JIRAEnvironmentData environmentData;
    private final EditNotifications editNotifications;
    private Navigation navigation;

    @Inject
    public NotificationSchemesImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        this.tester = tester;
        this.environmentData = environmentData;
        this.editNotifications = new EditNotificationsImpl(tester, environmentData);
    }

    public NotificationSchemesImpl(WebTester tester, JIRAEnvironmentData environmentData, int logIndentLevel) {
        this(tester, environmentData);
    }

    @Override
    public NotificationSchemes goTo() {
        this.getNavigation().gotoAdminSection(Navigation.AdminSection.NOTIFICATION_SCHEMES);
        return this;
    }

    private Navigation getNavigation() {
        if (this.navigation == null) {
            this.navigation = new NavigationImpl(this.tester, this.environmentData);
        }
        return this.navigation;
    }

    @Override
    public EditNotifications addNotificationScheme(String name, String description) {
        this.tester.clickLink(ADD_NOTIFICATION_SCHEME_LINK_ID);
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("name", name);
        this.tester.setFormElement("description", description);
        this.tester.submit("Add");
        return this.editNotifications;
    }

    @Override
    public EditNotifications editNotifications(int id) {
        this.tester.clickLink(id + "_edit");
        return this.editNotifications;
    }
}

