/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.NavigationImpl;
import com.atlassian.jira.functest.framework.admin.PermissionSchemes;
import com.atlassian.jira.functest.framework.util.form.FormParameterUtil;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.webtests.LegacyProjectPermissionKeyMapping;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import net.sourceforge.jwebunit.WebTester;

public class PermissionSchemesImpl
implements PermissionSchemes,
PermissionSchemes.PermissionScheme {
    private final WebTester tester;
    private final JIRAEnvironmentData environmentData;
    private Navigation navigation;

    public PermissionSchemesImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        this.tester = tester;
        this.environmentData = environmentData;
    }

    @Override
    public PermissionSchemes.PermissionScheme defaultScheme() {
        this.getNavigation().gotoAdminSection(Navigation.AdminSection.PERMISSION_SCHEMES);
        this.tester.clickLinkWithText("Default Permission Scheme");
        return this;
    }

    @Override
    public PermissionSchemes.PermissionScheme scheme(String schemeName) {
        this.getNavigation().gotoAdminSection(Navigation.AdminSection.PERMISSION_SCHEMES);
        this.tester.clickLinkWithText(schemeName);
        return this;
    }

    @Override
    public void grantPermissionToGroup(int permission, String groupName) {
        this.grantPermissionToGroup(LegacyProjectPermissionKeyMapping.getKey(permission), groupName);
    }

    @Override
    public void grantPermissionToGroup(String permission, String groupName) {
        this.grantPermissionToGroup(new ProjectPermissionKey(permission), groupName);
    }

    @Override
    public void grantPermissionToGroup(ProjectPermissionKey permission, String groupName) {
        this.tester.clickLink("add_perm_" + permission.permissionKey());
        this.tester.checkCheckbox("type", "group");
        FormParameterUtil formParameterUtil = new FormParameterUtil(this.tester, "jiraform", " Add ");
        formParameterUtil.addOptionToHtmlSelect("group", new String[]{groupName});
        formParameterUtil.setFormElement("group", groupName);
        formParameterUtil.submitForm();
    }

    @Override
    public void grantPermissionToReporter(int permission) {
        this.grantPermissionToReporter(LegacyProjectPermissionKeyMapping.getKey(permission));
    }

    @Override
    public void grantPermissionToReporter(String permission) {
        this.grantPermissionToReporter(new ProjectPermissionKey(permission));
    }

    @Override
    public void grantPermissionToReporter(ProjectPermissionKey permission) {
        this.tester.clickLink("add_perm_" + permission.permissionKey());
        this.tester.checkCheckbox("type", "reporter");
        this.tester.submit(" Add ");
    }

    @Override
    public void grantPermissionToProjectLead(int permission) {
        this.grantPermissionToProjectLead(LegacyProjectPermissionKeyMapping.getKey(permission));
    }

    @Override
    public void grantPermissionToProjectLead(String permission) {
        this.grantPermissionToProjectLead(new ProjectPermissionKey(permission));
    }

    @Override
    public void grantPermissionToProjectLead(ProjectPermissionKey permission) {
        this.tester.clickLink("add_perm_" + permission.permissionKey());
        this.tester.checkCheckbox("type", "lead");
        this.tester.submit(" Add ");
    }

    @Override
    public void grantPermissionToCurrentAssignee(int permission) {
        this.grantPermissionToCurrentAssignee(LegacyProjectPermissionKeyMapping.getKey(permission));
    }

    @Override
    public void grantPermissionToCurrentAssignee(String permission) {
        this.grantPermissionToCurrentAssignee(new ProjectPermissionKey(permission));
    }

    @Override
    public void grantPermissionToCurrentAssignee(ProjectPermissionKey permission) {
        this.tester.clickLink("add_perm_" + permission.permissionKey());
        this.tester.checkCheckbox("type", "assignee");
        this.tester.submit(" Add ");
    }

    @Override
    public void grantPermissionToUserCustomFieldValue(int permission, String customFieldId) {
        this.grantPermissionToUserCustomFieldValue(LegacyProjectPermissionKeyMapping.getKey(permission), customFieldId);
    }

    @Override
    public void grantPermissionToUserCustomFieldValue(String permission, String customFieldId) {
        this.grantPermissionToUserCustomFieldValue(new ProjectPermissionKey(permission), customFieldId);
    }

    @Override
    public void grantPermissionToUserCustomFieldValue(ProjectPermissionKey permission, String customFieldId) {
        this.tester.clickLink("add_perm_" + permission.permissionKey());
        this.tester.checkCheckbox("type", "userCF");
        this.tester.setFormElement("userCF", customFieldId);
        this.tester.submit(" Add ");
    }

    @Override
    public void grantPermissionToGroupCustomFieldValue(int permission, String customFieldId) {
        this.grantPermissionToGroupCustomFieldValue(LegacyProjectPermissionKeyMapping.getKey(permission), customFieldId);
    }

    @Override
    public void grantPermissionToGroupCustomFieldValue(String permission, String customFieldId) {
        this.grantPermissionToGroupCustomFieldValue(new ProjectPermissionKey(permission), customFieldId);
    }

    @Override
    public void grantPermissionToGroupCustomFieldValue(ProjectPermissionKey permission, String customFieldId) {
        this.tester.clickLink("add_perm_" + permission.permissionKey());
        this.tester.checkCheckbox("type", "groupCF");
        this.tester.setFormElement("groupCF", customFieldId);
        this.tester.submit(" Add ");
    }

    @Override
    public void grantPermissionToProjectRole(int permission, String projectRoleId) {
        this.grantPermissionToProjectRole(LegacyProjectPermissionKeyMapping.getKey(permission), projectRoleId);
    }

    @Override
    public void grantPermissionToProjectRole(String permission, String projectRoleId) {
        this.grantPermissionToProjectRole(new ProjectPermissionKey(permission), projectRoleId);
    }

    @Override
    public void grantPermissionToProjectRole(ProjectPermissionKey permission, String projectRoleId) {
        this.tester.clickLink("add_perm_" + permission.permissionKey());
        this.tester.checkCheckbox("type", "projectrole");
        this.tester.setFormElement("projectrole", projectRoleId);
        this.tester.submit(" Add ");
    }

    @Override
    public void grantPermissionToApplicationRole(ProjectPermissionKey permission, String applicationRoleId) {
        this.tester.clickLink("add_perm_" + permission.permissionKey());
        this.tester.checkCheckbox("type", "applicationRole");
        this.tester.setFormElement("applicationRole", applicationRoleId);
        this.tester.submit(" Add ");
    }

    @Override
    public void grantPermissionToSingleUser(int permission, String username) {
        this.grantPermissionToSingleUser(LegacyProjectPermissionKeyMapping.getKey(permission), username);
    }

    @Override
    public void grantPermissionToSingleUser(String permission, String username) {
        this.grantPermissionToSingleUser(new ProjectPermissionKey(permission), username);
    }

    @Override
    public void grantPermissionToSingleUser(ProjectPermissionKey permission, String username) {
        this.tester.clickLink("add_perm_" + permission.permissionKey());
        this.tester.checkCheckbox("type", "user");
        this.tester.setFormElement("user", username);
        this.tester.submit(" Add ");
    }

    @Override
    public void removePermission(int permissionType, String permissionParam) {
        this.removePermission(LegacyProjectPermissionKeyMapping.getKey(permissionType), permissionParam);
    }

    @Override
    public void removePermission(String permission, String groupName) {
        if (this.tester.getDialog().isLinkPresent("del_perm_" + permission + "_" + groupName)) {
            this.tester.clickLink("del_perm_" + permission + "_" + groupName);
            this.tester.submit("Delete");
        }
    }

    @Override
    public void removePermission(ProjectPermissionKey permissionType, String permissionParam) {
        this.removePermission(permissionType.permissionKey(), permissionParam);
    }

    @Override
    public void removePermission(GlobalPermissionKey permissionType, String permissionParam) {
        this.removePermission(permissionType.getKey(), permissionParam);
    }

    private Navigation getNavigation() {
        if (this.navigation == null) {
            this.navigation = new NavigationImpl(this.tester, this.environmentData);
        }
        return this.navigation;
    }
}

