/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LocatorFactoryImpl;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.Project;
import com.atlassian.jira.functest.framework.backdoor.Backdoor;
import com.atlassian.jira.functest.framework.util.AsynchronousTasks;
import com.atlassian.jira.functest.framework.util.form.FormParameterUtil;
import com.atlassian.jira.testkit.beans.WorkflowSchemeData;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.ProjectControl;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.testkit.client.log.FuncTestLoggerImpl;
import com.atlassian.jira.testkit.client.restclient.Component;
import com.atlassian.jira.testkit.client.restclient.ComponentClient;
import com.atlassian.jira.testkit.client.restclient.Version;
import com.atlassian.jira.testkit.client.restclient.VersionClient;
import com.atlassian.jira.util.ProgressPageControl;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import net.sourceforge.jwebunit.WebTester;
import org.assertj.core.api.Assertions;

public class ProjectImpl
implements Project {
    private final Backdoor backdoor;
    private final WebTester tester;
    private final com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData;
    private final AsynchronousTasks asynchronousTasks;
    private final FuncTestLogger logger;
    private final LocatorFactory locators;
    private final ProjectControl projectControl;

    @Inject
    public ProjectImpl(Backdoor backdoor, WebTester tester, com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData, Navigation navigation, com.atlassian.jira.functest.framework.assertions.Assertions assertions, AsynchronousTasks asynchronousTasks) {
        this.backdoor = backdoor;
        this.tester = tester;
        this.environmentData = environmentData;
        this.asynchronousTasks = asynchronousTasks;
        this.projectControl = new ProjectControl((JIRAEnvironmentData)environmentData);
        this.logger = new FuncTestLoggerImpl(2);
        this.locators = new LocatorFactoryImpl(tester);
    }

    @Override
    public long addProject(String name, String key, String lead) {
        long projectIdFromKey = this.getProjectIdFromKey(key);
        if (projectIdFromKey != -1L) {
            this.logger.log((Object)("Project " + name + " exists "));
            return projectIdFromKey;
        }
        this.logger.log((Object)("Adding project " + name));
        return this.projectControl.addProject(name, key, lead);
    }

    @Override
    public void editProject(long projectId, String name, String description, String url) {
        this.tester.gotoPage("/secure/project/EditProject!default.jspa?pid=" + projectId);
        this.tester.assertTextPresent("action=\"EditProject.jspa\"");
        if (name != null) {
            this.tester.setFormElement("name", name);
        }
        if (description != null) {
            this.tester.setFormElement("description", description);
        }
        if (url != null) {
            this.tester.setFormElement("url", url);
        }
        this.tester.submit();
        String projectKey = this.getProjectKeyFromId(projectId);
        com.atlassian.jira.testkit.client.restclient.Project project = this.backdoor.project().getProject(projectKey);
        if (name != null) {
            Assertions.assertThat((String)project.name).isEqualTo(name);
        }
        if (description != null) {
            Assertions.assertThat((String)project.description).isEqualTo(description);
        }
        if (url != null) {
            Assertions.assertThat((String)project.url).isEqualTo(url);
        }
    }

    @Override
    public void deleteProject(long projectId) {
        this.tester.gotoPage("/secure/admin/DeleteProject!default.jspa?pid=" + projectId);
        this.tester.submit("delete");
        this.tester.assertTextPresent("Delete project");
        ProgressPageControl.waitAndReload(this.tester, "project-delete-form", "refresh", "acknowledge");
    }

    @Override
    public void deleteProject(String projectName) {
        this.deleteProject(this.getProjectIdFromName(projectName));
    }

    @Override
    public String addComponent(String projectKey, String componentName, String description, String leadUserName) {
        ComponentClient componentClient = new ComponentClient((JIRAEnvironmentData)this.environmentData);
        Component component = componentClient.create(new Component().project(projectKey).name(componentName).description(description).leadUserName(leadUserName));
        return "" + component.id;
    }

    @Override
    public String addVersion(String projectKey, String versionName, String description, String releaseDate) {
        VersionClient versionClient = new VersionClient((JIRAEnvironmentData)this.environmentData);
        Version version = new Version();
        version.project(projectKey).name(versionName).description(description).userReleaseDate(releaseDate);
        Version newVersion = versionClient.create(version);
        return "" + newVersion.id;
    }

    private String getProjectKeyFromId(Long projectId) {
        List<com.atlassian.jira.testkit.client.restclient.Project> projects = this.backdoor.project().getProjects();
        for (com.atlassian.jira.testkit.client.restclient.Project project : projects) {
            if (Long.parseLong(project.id) != projectId) continue;
            return project.key;
        }
        return null;
    }

    private long getProjectIdFromName(String projectName) {
        List<com.atlassian.jira.testkit.client.restclient.Project> projects = this.backdoor.project().getProjects();
        for (com.atlassian.jira.testkit.client.restclient.Project project : projects) {
            if (!project.name.equals(projectName)) continue;
            return Long.valueOf(project.id);
        }
        throw new IllegalArgumentException("Project '" + projectName + "' does not exist.");
    }

    private Version getVersionByName(String projectKey, String versionName) {
        List<Version> versions = this.backdoor.project().getVersionsForProject(projectKey);
        for (Version version : versions) {
            if (!version.name.equals(versionName)) continue;
            return version;
        }
        return null;
    }

    private Component getComponentByName(String projectKey, String componentName) {
        List<Component> components = this.backdoor.project().getComponentsForProject(projectKey);
        for (Component component : components) {
            if (!component.name.equals(componentName)) continue;
            return component;
        }
        return null;
    }

    @Override
    public void archiveVersion(String projectKey, String versionName) {
        Version versionByName = this.getVersionByName(projectKey, versionName);
        VersionClient versionClient = new VersionClient((JIRAEnvironmentData)this.environmentData);
        versionClient.putResponse(versionByName.archived(Boolean.valueOf(true)));
    }

    @Override
    public void releaseVersion(String projectKey, String versionName, String releaseDate) {
        Version versionByName = this.getVersionByName(projectKey, versionName);
        VersionClient versionClient = new VersionClient((JIRAEnvironmentData)this.environmentData);
        versionClient.putResponse(versionByName.released(Boolean.valueOf(true)).userReleaseDate(releaseDate));
    }

    @Override
    public void unreleaseVersion(String projectKey, String versionName, String releaseDate) {
        Version versionByName = this.getVersionByName(projectKey, versionName);
        VersionClient versionClient = new VersionClient((JIRAEnvironmentData)this.environmentData);
        versionClient.putResponse(versionByName.released(Boolean.valueOf(false)).userReleaseDate(releaseDate));
    }

    @Override
    public void deleteVersion(String projectKey, String versionName) {
        Version versionByName = this.getVersionByName(projectKey, versionName);
        VersionClient versionClient = new VersionClient((JIRAEnvironmentData)this.environmentData);
        versionClient.delete("" + versionByName.id);
    }

    @Override
    public void editVersionDetails(String projectKey, String versionName, String name, String description, String releaseDate) {
        Version versionByName = this.getVersionByName(projectKey, versionName);
        if (name != null) {
            versionByName.name(name);
        }
        if (description != null) {
            versionByName.description(description);
        }
        if (releaseDate != null) {
            versionByName.userReleaseDate(releaseDate);
        }
        VersionClient versionClient = new VersionClient((JIRAEnvironmentData)this.environmentData);
        versionClient.putResponse(versionByName);
    }

    @Override
    public void editComponent(String projectKey, String componentName, String name, String description, String leadUserName) {
        ComponentClient componentClient = new ComponentClient((JIRAEnvironmentData)this.environmentData);
        Component component = this.getComponentByName(projectKey, componentName);
        if (name != null) {
            component.name(name);
        }
        if (description != null) {
            component.description(description);
        }
        if (leadUserName != null) {
            component.leadUserName(leadUserName);
        }
        componentClient.putResponse(component);
    }

    @Override
    public void associateFieldConfigurationScheme(String projectName, String newFieldConfigurationSchemeName) {
        Long projectId = this.getProjectIdFromName(projectName);
        this.tester.gotoPage("/secure/admin/SelectFieldLayoutScheme!default.jspa?projectId=" + projectId);
        this.tester.setWorkingForm("jiraform");
        if (newFieldConfigurationSchemeName == null) {
            newFieldConfigurationSchemeName = "System Default Field Configuration";
        }
        this.tester.selectOption("schemeId", newFieldConfigurationSchemeName);
        this.tester.submit("Associate");
        Assertions.assertThat((String)this.backdoor.project().getSchemes((Long)projectId).fieldConfigurationScheme.name).isEqualTo(newFieldConfigurationSchemeName);
    }

    @Override
    public void associateIssueLevelSecurityScheme(String projectName, String newIssueLevelSecuritySchemeName) {
        Long projectId = this.getProjectIdFromName(projectName);
        this.tester.gotoPage("/secure/project/SelectProjectIssueSecurityScheme!default.jspa?projectId=" + projectId);
        this.tester.setWorkingForm("jiraform");
        String issueLevelSecuritySchemeNameToSet = newIssueLevelSecuritySchemeName;
        if (issueLevelSecuritySchemeNameToSet == null) {
            issueLevelSecuritySchemeNameToSet = "None";
        }
        this.tester.selectOption("newSchemeId", issueLevelSecuritySchemeNameToSet);
        this.tester.submit("Next >>");
        this.tester.submit("Associate");
        this.tester.assertTextPresent("Associate Issue Security Scheme to Project");
        ProgressPageControl.waitAndReload(this.tester, "assignissuesecurityprogressform", "Refresh", "Acknowledge");
        if (newIssueLevelSecuritySchemeName == null) {
            Assertions.assertThat((Object)this.backdoor.project().getSchemes((Long)projectId).issueSecurityScheme).isNull();
        } else {
            Assertions.assertThat((String)this.backdoor.project().getSchemes((Long)projectId).issueSecurityScheme.name).isEqualTo(newIssueLevelSecuritySchemeName);
        }
    }

    @Override
    public void removeAssociationOfIssueLevelSecurityScheme(String projectName) {
        this.associateIssueLevelSecurityScheme(projectName, null);
    }

    @Override
    public void associateWorkflowScheme(String projectName, String workflowSchemeName, Map<String, String> statusMapping, boolean wait) {
        this.tester.gotoPage("/secure/project/SelectProjectWorkflowScheme!default.jspa?projectId=" + this.getProjectIdFromName(projectName));
        if (workflowSchemeName.equals("Default") && this.tester.getDialog().getElement("schemeId_select") == null) {
            return;
        }
        this.tester.setWorkingForm("jiraform");
        this.tester.selectOption("schemeId", workflowSchemeName);
        this.tester.submit("Associate");
        this.associateWorkflowScheme(statusMapping, wait);
    }

    @Override
    public void createWorkflowSchemeDraft(String projectKey) {
        WorkflowSchemeData workflowSchemeData = this.backdoor.workflowSchemes().getWorkflowSchemeByProjectKey(projectKey);
        if (workflowSchemeData.getId() == null) {
            workflowSchemeData = this.backdoor.workflowSchemes().createScheme(workflowSchemeData);
            this.backdoor.project().setWorkflowScheme(projectKey, workflowSchemeData.getId());
        }
        this.backdoor.workflowSchemes().createDraft(workflowSchemeData);
    }

    @Override
    public void assignToDraftScheme(String projectKey, String workflowName, String ... issueTypeIds) {
        WorkflowSchemeData workflowSchemeData = this.backdoor.workflowSchemes().getWorkflowSchemeByProjectKey(projectKey);
        workflowSchemeData.setDefaultWorkflow(workflowName);
        for (String issueTypeId : issueTypeIds) {
            workflowSchemeData.setMapping(issueTypeId, workflowName);
        }
        this.backdoor.workflowSchemes().updateDraftScheme(workflowSchemeData.getId().longValue(), workflowSchemeData);
    }

    @Override
    public void associateWorkflowScheme(String projectName, String workflowSchemeName) {
        this.associateWorkflowScheme(projectName, workflowSchemeName, null, true);
    }

    @Override
    public void publishWorkflowSchemeDraft(String projectName, Long schemeId, Map<String, String> statusMapping, boolean wait) {
        this.tester.gotoPage("/secure/project/SelectProjectWorkflowSchemeStep2!default.jspa?projectId=" + this.getProjectIdFromName(projectName) + "&schemeId=" + schemeId + "&draftMigration=true");
        this.associateWorkflowScheme(statusMapping, wait);
    }

    private void associateWorkflowScheme(Map<String, String> statusMapping, boolean wait) {
        boolean thereAreIssuesToMigrate;
        boolean bl = thereAreIssuesToMigrate = !this.locators.id("workflow-associate-noissues").exists();
        if (statusMapping != null && !statusMapping.isEmpty()) {
            for (Map.Entry<String, String> entry : statusMapping.entrySet()) {
                this.tester.selectOption(entry.getKey(), entry.getValue());
            }
        }
        if (!this.tester.getDialog().hasSubmitButton("Associate")) {
            return;
        }
        this.tester.submit("Associate");
        if (thereAreIssuesToMigrate && wait) {
            this.waitForWorkflowMigration(1000L, 100);
        }
    }

    @Override
    public void associateNotificationScheme(String projectKey, String notificationSchemeName) {
        Long projectId = this.getProjectIdFromKey(projectKey);
        this.tester.gotoPage("secure/project/SelectProjectScheme!default.jspa?projectId=" + projectId);
        this.tester.setWorkingForm("jiraform");
        this.tester.selectOption("schemeIds", notificationSchemeName);
        this.tester.submit("Associate");
    }

    @Override
    public void waitForWorkflowMigration(long sleepTime, int retryCount) {
        this.asynchronousTasks.waitForSuccessfulCompletion(sleepTime, retryCount, "Workflow Migration");
    }

    @Override
    public void setProjectLead(String projectName, String userName) {
        Long projectId = this.getProjectIdFromName(projectName);
        this.tester.gotoPage("secure/project/EditProjectLeadAndDefaultAssignee!default.jspa?pid=" + projectId);
        FormParameterUtil formParameterUtil = new FormParameterUtil(this.tester, "project-edit-lead-and-default-assignee", "Update");
        formParameterUtil.addOptionToHtmlSelect("lead", new String[]{userName});
        formParameterUtil.setFormElement("lead", userName);
        formParameterUtil.submitForm();
    }

    @Override
    public boolean projectWithKeyExists(String projectKey) {
        this.logger.log((Object)("Checking if project with key '" + projectKey + "' exists"));
        return this.getProjectIdFromKey(projectKey) != -1L;
    }

    private long getProjectIdFromKey(String projectKey) {
        try {
            return this.backdoor.project().getProjectId(projectKey);
        }
        catch (WebApplicationException e) {
            return -1L;
        }
    }
}

