/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.ProjectImport;
import com.atlassian.jira.functest.framework.admin.ProjectImportTypeFix;
import com.atlassian.jira.functest.framework.backdoor.Backdoor;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.assertj.core.api.Fail;

public class ProjectImportImpl
implements ProjectImport {
    private final WebTester tester;
    private final Navigation navigation;
    private final Administration administration;
    private final Backdoor backdoor;

    @Inject
    public ProjectImportImpl(WebTester tester, JIRAEnvironmentData environmentData, Navigation navigation, Administration administration) {
        this.tester = tester;
        this.navigation = navigation;
        this.administration = administration;
        this.backdoor = new Backdoor(environmentData);
    }

    @Override
    public File doImportToSummary(String backupFileName, String currentSystemXML, String attachmentPath) {
        File tempFile = this.importAndExportBackupAndSetupCurrentInstance(backupFileName, currentSystemXML);
        File jiraImportDirectory = new File(this.administration.getJiraHomeDirectory(), "import");
        try {
            FileUtils.copyFileToDirectory((File)tempFile, (File)jiraImportDirectory);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not copy file " + tempFile.getAbsolutePath() + " to the import directory in jira home " + jiraImportDirectory, e);
        }
        this.importToPreImportSummaryPage(attachmentPath, tempFile);
        return tempFile;
    }

    public void importToPreImportSummaryPage(String attachmentPath, File tempFile) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_IMPORT);
        this.tester.setWorkingForm("project-import");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupPath", tempFile.getAbsolutePath());
        if (attachmentPath != null) {
            this.tester.setFormElement("backupAttachmentPath", attachmentPath);
        }
        this.tester.submit();
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("Project Import: Select Project to Import");
        this.tester.selectOption("projectKey", "monkey");
        this.tester.submit("Next");
        this.advanceThroughWaitingPage();
    }

    public File importAndExportBackupAndSetupCurrentInstance(String backupFileName, String currentSystemXML) {
        this.administration.restoreData(backupFileName);
        File tempFile = this.administration.exportDataToFile(FilenameUtils.removeExtension((String)backupFileName) + "_out.xml");
        ProjectImportTypeFix fix = new ProjectImportTypeFix(this.backdoor);
        fix.rewriteProjectTypes(tempFile);
        this.administration.restoreData(currentSystemXML);
        fix.updateAllProjectsToBusinessType();
        this.administration.attachments().enable();
        return tempFile;
    }

    private void advanceThroughWaitingPage() {
        int count = 0;
        while (this.tester.getDialog().getResponseText().indexOf("Project Import: Progress") != -1) {
            this.tester.submit("Refresh");
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (++count < 100) continue;
            Fail.fail((String)"Our project import backup selection has taken too long!");
        }
    }
}

