/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.config.ConfigFile;
import com.atlassian.jira.functest.framework.backdoor.Backdoor;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.testkit.client.restclient.Project;
import java.io.File;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;

public class ProjectImportTypeFix {
    private static final String BUSINESS = "business";
    private final Backdoor backdoor;

    public ProjectImportTypeFix(Backdoor backdoor) {
        this.backdoor = backdoor;
    }

    public void updateAllProjectsToBusinessType() {
        for (Project project : this.backdoor.project().getProjects()) {
            this.backdoor.project().updateProjectType(Long.valueOf(project.id), new ProjectTypeKey(BUSINESS));
        }
    }

    public void rewriteProjectTypes(File backupFile) {
        ConfigFile configFile = ConfigFile.create(backupFile);
        Document document = configFile.readConfig();
        boolean updatedProjects = false;
        List projects = document.getRootElement().elements("Project");
        for (Element project : projects) {
            Attribute projecttype = project.attribute("projecttype");
            if (projecttype == null) continue;
            projecttype.setValue(BUSINESS);
            updatedProjects = true;
        }
        if (updatedProjects) {
            configFile.writeFile(document);
        }
    }
}

